/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement.util;

import com.simibubi.create.content.curiosities.tools.ExtendoGripItem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
public abstract class PoleHelper<T extends Comparable<T>>
implements IPlacementHelper {
    protected final Predicate<BlockState> statePredicate;
    protected final IProperty<T> property;
    protected final Function<BlockState, Direction.Axis> axisFunction;

    public PoleHelper(Predicate<BlockState> statePredicate, Function<BlockState, Direction.Axis> axisFunction, IProperty<T> property) {
        this.statePredicate = statePredicate;
        this.axisFunction = axisFunction;
        this.property = property;
    }

    public boolean matchesAxis(BlockState state, Direction.Axis axis) {
        if (!this.statePredicate.test(state)) {
            return false;
        }
        return this.axisFunction.apply(state) == axis;
    }

    public int attachedPoles(World world, BlockPos pos, Direction direction) {
        BlockPos checkPos = pos.func_177972_a(direction);
        BlockState state = world.func_180495_p(checkPos);
        int count = 0;
        while (this.matchesAxis(state, direction.func_176740_k())) {
            ++count;
            checkPos = checkPos.func_177972_a(direction);
            state = world.func_180495_p(checkPos);
        }
        return count;
    }

    @Override
    public Predicate<BlockState> getStatePredicate() {
        return this.statePredicate;
    }

    @Override
    public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray) {
        List<Direction> directions = IPlacementHelper.orderedByDistance(pos, ray.func_216347_e(), dir -> dir.func_176740_k() == this.axisFunction.apply(state));
        for (Direction dir2 : directions) {
            BlockPos newPos;
            BlockState newState;
            int poles;
            IAttributeInstance reach;
            int range = (Integer)AllConfigs.SERVER.curiosities.placementAssistRange.get();
            if (player != null && (reach = player.func_110148_a(PlayerEntity.REACH_DISTANCE)).func_180374_a(ExtendoGripItem.singleRangeAttributeModifier)) {
                range += 4;
            }
            if ((poles = this.attachedPoles(world, pos, dir2)) >= range || !(newState = world.func_180495_p(newPos = pos.func_177967_a(dir2, poles + 1))).func_185904_a().func_76222_j()) continue;
            return PlacementOffset.success((Vec3i)newPos, bState -> (BlockState)bState.func_206870_a(this.property, state.func_177229_b(this.property)));
        }
        return PlacementOffset.fail();
    }
}

