/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.worldWrappers;

import com.simibubi.create.foundation.render.backend.instancing.IFlywheelWorld;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedChunkProvider;
import com.simibubi.create.foundation.utility.worldWrappers.WrappedWorld;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.lighting.WorldLightManager;

public class PlacementSimulationWorld
extends WrappedWorld
implements IFlywheelWorld {
    public HashMap<BlockPos, BlockState> blocksAdded;
    public HashMap<BlockPos, TileEntity> tesAdded;
    public HashSet<SectionPos> spannedChunks;
    public WorldLightManager lighter;
    public WrappedChunkProvider field_73020_y;
    private final BlockPos.Mutable scratch = new BlockPos.Mutable();

    public PlacementSimulationWorld(World wrapped) {
        this(wrapped, new WrappedChunkProvider());
    }

    public PlacementSimulationWorld(World wrapped, WrappedChunkProvider chunkProvider) {
        super(wrapped, chunkProvider);
        this.field_73020_y = chunkProvider.setWorld(this);
        this.spannedChunks = new HashSet();
        this.lighter = new WorldLightManager((IChunkLightProvider)chunkProvider, true, false);
        this.blocksAdded = new HashMap();
        this.tesAdded = new HashMap();
    }

    @Override
    public WorldLightManager func_225524_e_() {
        return this.lighter;
    }

    public void setTileEntities(Collection<TileEntity> tileEntities) {
        this.tesAdded.clear();
        tileEntities.forEach(te -> this.tesAdded.put(te.func_174877_v(), (TileEntity)te));
    }

    public void clear() {
        this.blocksAdded.clear();
    }

    @Override
    public boolean func_180501_a(BlockPos pos, BlockState newState, int flags) {
        SectionPos sectionPos = SectionPos.func_218167_a((BlockPos)pos);
        if (this.spannedChunks.add(sectionPos)) {
            this.lighter.func_215566_a(sectionPos, false);
        }
        this.lighter.func_215568_a(pos);
        this.blocksAdded.put(pos, newState);
        return true;
    }

    public boolean func_175656_a(BlockPos pos, BlockState state) {
        return this.func_180501_a(pos, state, 0);
    }

    @Override
    public TileEntity func_175625_s(BlockPos pos) {
        return this.tesAdded.get(pos);
    }

    @Override
    public boolean func_217375_a(BlockPos pos, Predicate<BlockState> condition) {
        return condition.test(this.func_180495_p(pos));
    }

    public boolean func_195588_v(BlockPos pos) {
        return true;
    }

    public boolean isAreaLoaded(BlockPos center, int range) {
        return true;
    }

    public BlockState getBlockState(int x, int y, int z) {
        return this.func_180495_p((BlockPos)this.scratch.func_181079_c(x, y, z));
    }

    @Override
    public BlockState func_180495_p(BlockPos pos) {
        BlockState state = this.blocksAdded.get(pos);
        if (state != null) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }
}

