/*
 * Decompiled with CFR 0.152.
 */
package su226.creeperconfetti;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;
import su226.creeperconfetti.Mod;

public class Config {
    public static float chance = 0.1f;
    public static float damage = 0.0f;
    public static float soundChance = 0.05f;
    static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("creeperconfetti.properties");

    static float parseRangedFloat(String s, float min, float max, float def) {
        if (s == null) {
            return def;
        }
        try {
            return Math.min(Math.max(Float.parseFloat(s), min), max);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    static void serialize() {
        Properties prop = new Properties();
        prop.setProperty("chance", Float.toString(chance));
        prop.setProperty("damage", Float.toString(damage));
        prop.setProperty("soundChance", Float.toString(soundChance));
        try {
            OutputStream s = Files.newOutputStream(configPath, new OpenOption[0]);
            prop.store(s, "Creeper Confetti Config");
            s.close();
        }
        catch (IOException e) {
            Mod.LOG.warn("Failed to write config!");
        }
    }

    static void deserialize() {
        Properties prop = new Properties();
        try {
            InputStream s = Files.newInputStream(configPath, new OpenOption[0]);
            prop.load(s);
            chance = Config.parseRangedFloat(prop.getProperty("chance"), 0.0f, 1.0f, 0.1f);
            damage = Config.parseRangedFloat(prop.getProperty("damage"), 0.0f, 1.0f, 0.0f);
            soundChance = Config.parseRangedFloat(prop.getProperty("soundChance"), 0.0f, 1.0f, 0.05f);
        }
        catch (IOException e) {
            Mod.LOG.warn("Failed to read config!");
        }
        Config.serialize();
    }
}

