/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod;

import com.croparia.mod.client.render.RenderingHandler;
import com.croparia.mod.core.init.BlockInit;
import com.croparia.mod.core.init.ContainerInit;
import com.croparia.mod.core.init.CropsInit;
import com.croparia.mod.core.init.ItemInit;
import com.croparia.mod.core.init.TileEntityInit;
import com.croparia.mod.core.util.ModDispenserBehavior;
import com.croparia.mod.core.util.ModPotionBrewing;
import com.croparia.mod.core.util.ModRecipesRegistry;
import com.croparia.mod.world.generation.PlantsGenerations;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="croparia")
public class CropariaMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String mod_id = "croparia";
    public static final ItemGroup MAIN = new CropariaGroup("MAIN");
    public static final ItemGroup CROP = new CropariaCropGroup("CROP");

    public CropariaMod() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::doClientStuff);
        bus.addGenericListener(Feature.class, PlantsGenerations::registerFeatures);
        CropsInit.register();
        ItemInit.ITEMS.register(bus);
        BlockInit.BLOCKS.register(bus);
        TileEntityInit.TILE_ENTITIES.register(bus);
        ContainerInit.CONTAINER_TYPES.register(bus);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, PlantsGenerations::generatePlants);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        ModRecipesRegistry.registerInfusorRecipe();
        ModRecipesRegistry.registerRitualRecipe();
        ModPotionBrewing.addBrewingRecipe();
        ModDispenserBehavior.registerBehavior();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderingHandler.init();
    }

    public static void say(String message, World world, BlockPos pos) {
        PlayerEntity player = world.func_217366_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 5.0, false);
        player.func_145747_a((ITextComponent)new StringTextComponent(message), player.func_110124_au());
    }

    public static class CropariaGroup
    extends ItemGroup {
        public CropariaGroup(String label) {
            super(label);
        }

        public ItemStack func_78016_d() {
            return ((Item)ItemInit.ELEMATILIUS.get()).func_190903_i();
        }
    }

    public static class CropariaCropGroup
    extends ItemGroup {
        public CropariaCropGroup(String label) {
            super(label);
        }

        public ItemStack func_78016_d() {
            return ((BlockNamedItem)CropsInit.ELEMENTAL.getSeeds().get()).func_190903_i();
        }
    }
}

