/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.common.blocks;

import com.croparia.mod.common.blocks.tileEntity.CollectorTE;
import com.croparia.mod.core.init.TileEntityInit;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockCollector
extends Block
implements ITileEntityProvider {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public BlockCollector() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200944_c());
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof CollectorTE) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((CollectorTE)tileentity), (BlockPos)pos);
        }
        return ActionResultType.CONSUME;
    }

    private boolean connectedToPower(World worldIn, BlockPos pos, Direction facing) {
        for (Direction direction : Direction.values()) {
            if (direction == facing || !worldIn.func_175709_b(pos.func_177972_a(direction), direction)) continue;
            return true;
        }
        return false;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean powered = (Boolean)state.func_177229_b((Property)POWERED);
        boolean powerConnected = this.connectedToPower(worldIn, pos, (Direction)state.func_177229_b((Property)FACING));
        if (!powered && powerConnected) {
            worldIn.func_175656_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)((Direction)state.func_177229_b((Property)FACING)))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(true)));
        } else if (powered && !powerConnected) {
            worldIn.func_175656_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)((Direction)state.func_177229_b((Property)FACING)))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return side != Direction.NORTH;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return ((TileEntityType)TileEntityInit.COLLECTOR_TE.get()).func_200968_a();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED});
    }
}

