/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.core.util.recipes;

import com.croparia.mod.core.rituals.FirstRitual;
import com.croparia.mod.core.rituals.RitualUtils;
import com.croparia.mod.core.rituals.SecondRitual;
import com.croparia.mod.core.util.recipes.IRitualRecipe;
import com.croparia.mod.core.util.recipes.RecipeTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualRecipe
implements IRitualRecipe {
    public static List<RitualRecipe> recipes = new ArrayList<RitualRecipe>();
    private final Item base;
    private final BlockState blockNeed;
    private final ItemStack result;
    private final int ritualTier;
    private final ResourceLocation id;

    public RitualRecipe(ResourceLocation id, Item base, BlockState blockNeed, ItemStack result, int ritualTier) {
        this.base = base;
        this.blockNeed = blockNeed;
        this.result = result;
        this.ritualTier = ritualTier;
        this.id = id;
    }

    public static void craft(ItemStack input, World world, BlockPos pos) {
        boolean ret = false;
        int index = 0;
        while (!ret && index < recipes.size()) {
            if (RitualRecipe.recipes.get((int)index).base == input.func_77973_b()) {
                switch (RitualRecipe.recipes.get((int)index).ritualTier) {
                    case 1: {
                        if (!FirstRitual.checkRitual(RitualRecipe.recipes.get((int)index).blockNeed, world, pos, false)) break;
                        ret = true;
                        break;
                    }
                    case 2: {
                        if (!SecondRitual.checkRitual(RitualRecipe.recipes.get((int)index).blockNeed, world, pos, false)) break;
                        ret = true;
                    }
                }
            }
            if (ret) continue;
            ++index;
        }
        if (ret) {
            RitualUtils.endFirst(RitualRecipe.recipes.get((int)index).result, input, pos, world);
        }
    }

    public static void addRecipe(String id, Item input, BlockState blockNeed, Item output, int ritualTier) {
        recipes.add(new RitualRecipe(new ResourceLocation("croparia" + id), input, blockNeed, new ItemStack((IItemProvider)output), ritualTier));
    }

    public static void addRecipe(String id, Item input, BlockState blockNeed, ItemStack output, int ritualTier) {
        recipes.add(new RitualRecipe(new ResourceLocation("croparia" + id), input, blockNeed, output, ritualTier));
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ItemStack getBlockNeed() {
        return new ItemStack((IItemProvider)this.blockNeed.func_177230_c());
    }

    public int getRitualTier() {
        return this.ritualTier;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.base}));
        return list;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return true;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return null;
    }

    public IRecipeType<?> func_222127_g() {
        return RecipeTypes.RITUAL;
    }
}

