/*
 * Decompiled with CFR 0.152.
 */
package com.croparia.mod.world.feature;

import com.croparia.mod.common.blocks.CropariaCrops;
import com.croparia.mod.core.init.CropsInit;
import com.croparia.mod.core.util.FruitsEnum;
import com.croparia.mod.world.config.PlantsConfig;
import com.google.common.collect.ImmutableSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class FruitsFeature
extends Feature<PlantsConfig> {
    public static final Set<BlockState> BLOCKSTATE_WHITELIST = ImmutableSet.of((Object)Blocks.field_196658_i.func_176223_P(), (Object)Blocks.field_150346_d.func_176223_P(), (Object)Blocks.field_196660_k.func_176223_P());

    public FruitsFeature() {
        super(PlantsConfig.CODEC);
    }

    public boolean generate(@Nonnull ISeedReader world, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull PlantsConfig config) {
        boolean any = false;
        int dist = Math.min(8, Math.max(1, config.getPatchRadius()));
        for (int i = 0; i < config.getPatchCount(); ++i) {
            if (rand.nextInt(config.getPatchChance()) != 0) continue;
            int x = pos.func_177958_n() + rand.nextInt(16);
            int z = pos.func_177952_p() + rand.nextInt(16);
            int y = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z);
            FruitsEnum fruit = FruitsEnum.byId(rand.nextInt(7));
            BlockState state = (BlockState)((CropariaCrops)CropsInit.getFruit(fruit).getCrop().get()).func_176223_P().func_206870_a((Property)CropsBlock.field_176488_a, (Comparable)Integer.valueOf(7));
            for (int j = 0; j < config.getPatchDensity() * config.getPatchChance(); ++j) {
                int z1;
                int y1;
                int x1 = x + rand.nextInt(dist * 2) - dist;
                BlockPos pos2 = new BlockPos(x1, y1 = y + rand.nextInt(4) - rand.nextInt(4), z1 = z + rand.nextInt(dist * 2) - dist);
                if (!world.func_175623_d(pos2) || world.func_230315_m_().func_236037_d_() && y1 >= 127 || !BLOCKSTATE_WHITELIST.contains(world.func_180495_p(pos2.func_177977_b()))) continue;
                world.func_180501_a(pos2, state, 2);
                any = true;
            }
        }
        return any;
    }
}

