/*
 * Decompiled with CFR 0.152.
 */
package com.raptorbk.CyanWarriorSwordsRedux.items.blocks.testfurn;

import com.google.common.collect.Maps;
import com.raptorbk.CyanWarriorSwordsRedux.init.ModItems;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;

public class TransmutationFurnaceRecipes {
    private static final TransmutationFurnaceRecipes COOKING_BASE = new TransmutationFurnaceRecipes();
    private final Map<ItemStack, ItemStack> cookingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static TransmutationFurnaceRecipes instance() {
        return COOKING_BASE;
    }

    private TransmutationFurnaceRecipes() {
        this.addCookingRecipe(new ItemStack((Item)ModItems.fire_SWORD), new ItemStack(ModItems.fire_ESSENCE), 1.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.water_SWORD), new ItemStack(ModItems.water_ESSENCE), 1.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.earth_SWORD), new ItemStack(ModItems.earth_ESSENCE), 1.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.wind_SWORD), new ItemStack(ModItems.wind_ESSENCE), 1.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.thunder_SWORD), new ItemStack(ModItems.thunder_ESSENCE), 1.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.dark_SWORD), new ItemStack(ModItems.dark_ESSENCE), 1.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.light_SWORD), new ItemStack(ModItems.light_ESSENCE), 1.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.ender_SWORD), new ItemStack(ModItems.ender_ESSENCE), 1.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.beast_SWORD), new ItemStack(ModItems.beast_ESSENCE), 1.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.combustion_SWORD), new ItemStack(ModItems.fire_ESSENCE), 2.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.ice_SWORD), new ItemStack(ModItems.water_ESSENCE), 2.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.wild_NATURE), new ItemStack(ModItems.earth_ESSENCE), 2.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.wind_IMPULSE), new ItemStack(ModItems.wind_ESSENCE), 2.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.thunder_SHOCK), new ItemStack(ModItems.thunder_ESSENCE), 2.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.dark_NETHER), new ItemStack(ModItems.dark_ESSENCE), 2.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.light_NETHER), new ItemStack(ModItems.light_ESSENCE), 2.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.ender_PORTAL), new ItemStack(ModItems.ender_ESSENCE), 2.0f);
        this.addCookingRecipe(new ItemStack((Item)ModItems.golem_SWORD), new ItemStack(ModItems.beast_ESSENCE), 2.0f);
    }

    public void addCookingRecipeForBlock(Block input, ItemStack stack, float experience) {
        this.addCooking(Item.func_150898_a((Block)input), stack, experience);
    }

    public void addCooking(Item input, ItemStack stack, float experience) {
        this.addCookingRecipe(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
    }

    public void addCookingRecipe(ItemStack input, ItemStack stack, float experience) {
        if (this.getCookingResult(input) != ItemStack.field_190927_a) {
            FMLLog.log.info("Ignored cooking recipe with conflicting input: {} = {}", (Object)input, (Object)stack);
            return;
        }
        this.cookingList.put(input, stack);
        this.experienceList.put(stack, Float.valueOf(experience));
    }

    public ItemStack getCookingResult(ItemStack stack) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.cookingList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue();
        }
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getCookingList() {
        return this.cookingList;
    }

    public float getCookingExperience(ItemStack stack) {
        float ret = stack.func_77973_b().getSmeltingExperience(stack);
        if (ret != -1.0f) {
            return ret;
        }
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

