/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.diamondglass.blocks;

import com.kreezcraft.diamondglass.DiamondConfig;
import com.kreezcraft.diamondglass.DiamondGlass;
import com.kreezcraft.diamondglass.client.IHasModel;
import com.kreezcraft.diamondglass.init.InitBlocks;
import com.kreezcraft.diamondglass.init.InitItems;
import com.kreezcraft.diamondglass.items.ItemSlab;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class ModSlab
extends Block
implements IHasModel {
    public static final PropertyEnum<SlabVariant> VARIANT = PropertyEnum.func_177709_a((String)"half", SlabVariant.class);

    public ModSlab(String name, Block block) {
        super(Material.field_151576_e);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(DiamondConfig.nondiamondLevel.standardHardness);
        this.func_149752_b(DiamondConfig.nondiamondLevel.standardResistance);
        this.func_149647_a(DiamondGlass.creativeTab);
        this.setRegistryName(name);
        this.func_149663_c("diamondglass." + name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)SlabVariant.LOWER)));
        InitBlocks.BLOCKS.add(this);
        InitItems.ITEMS.add((Item)new ItemSlab(this));
        this.setHarvestLevel("pickaxe", 1);
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_177229_b(VARIANT) == SlabVariant.DOUBLE;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 1;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((SlabVariant)((Object)state.func_177229_b(VARIANT))).getAABB();
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_185900_c(world, pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, state.func_177229_b(VARIANT) == SlabVariant.DOUBLE ? 2 : 1));
        return ret;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        SlabVariant variant = SlabVariant.LOWER;
        if (meta == 1) {
            variant = SlabVariant.UPPER;
        } else if (meta == 2) {
            variant = SlabVariant.DOUBLE;
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)variant));
    }

    public int func_176201_c(IBlockState state) {
        return ((SlabVariant)((Object)state.func_177229_b(VARIANT))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public IBlockState getUpper() {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)SlabVariant.UPPER));
    }

    public IBlockState getLower() {
        return this.func_176223_P();
    }

    public IBlockState getDouble() {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)SlabVariant.DOUBLE));
    }

    public IBlockState getOpposite(IBlockState state) {
        if (state == this.getUpper()) {
            return this.getLower();
        }
        return this.getUpper();
    }

    @Override
    public void registerModels() {
        DiamondGlass.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "half=lower");
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        return super.getHarvestTool(state);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return super.isToolEffective(type, state);
    }

    public static enum SlabVariant implements IStringSerializable
    {
        LOWER("lower", new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), 0),
        UPPER("upper", new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0), 1),
        DOUBLE("double", Block.field_185505_j, 2);

        private String name;
        private AxisAlignedBB aabb;
        private int meta;

        private SlabVariant(String name_, AxisAlignedBB AABB_, int meta_) {
            this.name = name_;
            this.aabb = AABB_;
            this.meta = meta_;
        }

        public String func_176610_l() {
            return this.name;
        }

        public AxisAlignedBB getAABB() {
            return this.aabb;
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

