/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.diamondglass.items;

import com.kreezcraft.diamondglass.DiamondGlass;
import com.kreezcraft.diamondglass.blocks.ModSlab;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSlab
extends ItemBlock {
    private ModSlab realBlock;
    private PropertyEnum<ModSlab.SlabVariant> VARIANT;

    public ItemSlab(ModSlab block) {
        super((Block)block);
        this.realBlock = (ModSlab)this.field_150939_a;
        this.VARIANT = ModSlab.VARIANT;
        this.func_77656_e(0);
        String name = block.getRegistryName().func_110623_a();
        this.setRegistryName(name);
        this.func_77655_b("diamondglass." + name);
        this.func_77637_a(DiamondGlass.creativeTab);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state;
        Block block;
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            System.out.println("Calling onItemUse with facing " + facing.func_176610_l() + " and hitY " + hitY);
        }
        if (!((block = (state = world.func_180495_p(pos)).func_177230_c()).func_176200_f((IBlockAccess)world, pos) || block == this.field_150939_a && this.checkOppositeByFacing(state, facing))) {
            pos = pos.func_177972_a(facing);
        }
        state = world.func_180495_p(pos);
        IBlockState placeState = this.getByHitY(hitY);
        if (player.func_175151_a(pos, facing, stack) && facing.func_176740_k().func_176720_b() && state.func_177230_c() == this.field_150939_a) {
            placeState = this.realBlock.getDouble();
            if (this.doubleSlab(world, pos)) {
                return this.shrinkAndSucceed(world, pos, player, stack);
            }
        } else if (this.validEditable(state, world, pos, facing, stack, player) && facing.func_176740_k().func_176722_c() ? world.func_175656_a(pos, placeState) : (this.validEditable(state, world, pos, facing, stack, player) && facing.func_176740_k().func_176720_b() ? world.func_175656_a(pos, placeState = this.realBlock.getOpposite(placeState)) : player.func_175151_a(pos, facing, stack) && facing.func_176740_k().func_176722_c() && state.func_177230_c() == this.field_150939_a && this.canBeMerged(state, placeState) && this.doubleSlab(world, pos))) {
            return this.shrinkAndSucceed(world, pos, player, stack);
        }
        return EnumActionResult.FAIL;
    }

    private boolean validEditable(IBlockState state, World world, BlockPos pos, EnumFacing facing, ItemStack stack, EntityPlayer player) {
        return state.func_177230_c().func_176200_f((IBlockAccess)world, pos) && player.func_175151_a(pos, facing, stack);
    }

    private boolean canBeMerged(IBlockState state, IBlockState state2) {
        if (state != this.realBlock.getDouble() && state2 != this.realBlock.getDouble()) {
            return state != state2;
        }
        return false;
    }

    private boolean checkOppositeByFacing(IBlockState state, EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return state.func_177229_b(this.VARIANT) == ModSlab.SlabVariant.UPPER;
        }
        if (facing == EnumFacing.UP) {
            return state.func_177229_b(this.VARIANT) == ModSlab.SlabVariant.LOWER;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return world.func_72917_a(Block.field_185505_j.func_186670_a(pos.func_177972_a(side)), null);
    }

    private EnumActionResult shrinkAndSucceed(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), world, pos, (Entity)player);
        world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        stack.func_190918_g(1);
        return EnumActionResult.SUCCESS;
    }

    private IBlockState getByHitY(float hitY) {
        if ((double)hitY >= 0.5) {
            return this.field_150939_a.func_176223_P().func_177226_a(this.VARIANT, (Comparable)((Object)ModSlab.SlabVariant.UPPER));
        }
        return this.field_150939_a.func_176223_P();
    }

    private boolean doubleSlab(World world, BlockPos pos) {
        return world.func_175656_a(pos, this.realBlock.getDouble());
    }
}

