/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.diamondglass;

import com.kreezcraft.diamondglass.DiamondGlass;
import com.kreezcraft.diamondglass.block.BasicBlock;
import com.kreezcraft.diamondglass.block.BasicSandBlock;
import com.kreezcraft.diamondglass.block.BasicSlab;
import com.kreezcraft.diamondglass.block.BasicStair;
import com.kreezcraft.diamondglass.block.DiamondGlassBlock;
import com.kreezcraft.diamondglass.block.DiamondGlassPane;
import com.kreezcraft.diamondglass.block.DiamondGlassSlab;
import com.kreezcraft.diamondglass.block.DiamondGlassStair;
import com.kreezcraft.diamondglass.block.RainbowPane;
import com.kreezcraft.diamondglass.block.RainbowSlab;
import com.kreezcraft.diamondglass.block.RainbowStair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="diamondglass")
public class InitBlocks {
    public static final float glassHardness = 6.0f;
    public static List<Block> glass = new ArrayList<Block>();
    public static List<Block> pane = new ArrayList<Block>();
    public static List<Block> stair = new ArrayList<Block>();
    public static List<Block> slab = new ArrayList<Block>();
    public static Block diamondSand = new BasicSandBlock("diamondsand", 0.5f, 1200.0f);
    public static Block diamondSandstone = new BasicBlock("diamondsandstone", 0.8f);
    public static Block diamondSandstoneSmooth = new BasicBlock("diamondsandstonesmooth", 0.8f);
    public static Block diamondSandstoneChiseled = new BasicBlock("diamondsandstonechiseled", 0.8f);
    public static Block diamondSandstoneSlab = new BasicSlab(diamondSandstone, "diamondsandstone");
    public static Block diamondSandstoneSmoothSlab = new BasicSlab(diamondSandstoneSmooth, "diamondsandstonesmooth");
    public static Block diamondSandstoneChiseledSlab = new BasicSlab(diamondSandstoneChiseled, "diamondsandstonechiseled");
    public static Block diamondSandstoneStair = new BasicStair(diamondSandstone, "diamondsandstone");
    public static Block diamondSandstoneSmoothStair = new BasicStair(diamondSandstoneSmooth, "diamondsandstonesmooth");
    public static Block diamondSandstoneChiseledStair = new BasicStair(diamondSandstoneChiseled, "diamondsandstonechiseled");
    public static Block rainbowGlass = new GlassBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200948_a(6.0f, 1200.0f).func_226896_b_().func_200947_a(SoundType.field_185853_f));
    public static Block rainbowPane = new RainbowPane();
    public static Block rainbowGlassSlab = new RainbowSlab();
    public static Block rainbowGlassStair = new RainbowStair();

    public static void register() {
        for (DyeColor color : DyeColor.values()) {
            DiamondGlass.LOGGER.debug("Creating Blocks for " + color.toString());
            glass.add(new DiamondGlassBlock(color));
            pane.add((Block)new DiamondGlassPane(color));
            stair.add((Block)new DiamondGlassStair(glass.get(color.ordinal()), color));
            slab.add((Block)new DiamondGlassSlab(color));
        }
        DiamondGlass.Registry.registerBlocks(glass);
        DiamondGlass.Registry.registerBlocks(pane);
        DiamondGlass.Registry.registerBlocks(stair);
        DiamondGlass.Registry.registerBlocks(slab);
        DiamondGlass.Registry.register(diamondSand);
        DiamondGlass.Registry.register(diamondSandstone);
        DiamondGlass.Registry.register(diamondSandstoneSmooth);
        DiamondGlass.Registry.register(diamondSandstoneChiseled);
        DiamondGlass.Registry.register(diamondSandstoneStair);
        DiamondGlass.Registry.register(diamondSandstoneSmoothStair);
        DiamondGlass.Registry.register(diamondSandstoneChiseledStair);
        DiamondGlass.Registry.register(diamondSandstoneSlab);
        DiamondGlass.Registry.register(diamondSandstoneSmoothSlab);
        DiamondGlass.Registry.register(diamondSandstoneChiseledSlab);
        rainbowGlass.setRegistryName(new ResourceLocation("diamondglass", "rainbowglass"));
        DiamondGlass.Registry.register(rainbowGlass);
        DiamondGlass.Registry.register(rainbowPane);
        DiamondGlass.Registry.register(rainbowGlassSlab);
        DiamondGlass.Registry.register(rainbowGlassStair);
    }

    public static void setupRenderLayers() {
        glass.forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == RenderType.func_228645_f_()));
        pane.forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == RenderType.func_228645_f_()));
        stair.forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == RenderType.func_228645_f_()));
        slab.forEach(block -> RenderTypeLookup.setRenderLayer((Block)block, layer -> layer == RenderType.func_228645_f_()));
        RenderTypeLookup.setRenderLayer((Block)rainbowGlass, layer -> layer == RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)rainbowPane, layer -> layer == RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)rainbowGlassStair, layer -> layer == RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)rainbowGlassSlab, layer -> layer == RenderType.func_228645_f_());
    }
}

