/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.diamondglass.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DGconfig {
    public static ForgeConfigSpec.IntValue rarity;
    public static ForgeConfigSpec.IntValue vein_size;
    public static ForgeConfigSpec.IntValue max_spawn_height;
    public static ForgeConfigSpec.BooleanValue enable_server_config_sync;
    public static ForgeConfigSpec.BooleanValue send_config_sync_packet;
    public static ForgeConfigSpec.BooleanValue overworld;
    public static ForgeConfigSpec.IntValue min_spawn_height;

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.comment("Note that almost all config changes require a server restart and/or a full minecraft restart. Dimensional Ore Configuration").push("dimensional_ore");
        overworld = builder.comment("Spawn diamondsand in the overworld? Default = true").define("overworld", true);
        builder.pop();
        builder.comment("Rarity Configuration").push("Diamond Sand Overworld");
        rarity = builder.comment("Rarity of diamond sand veins. Default = 6").defineInRange("rarity", 6, 0, 100);
        vein_size = builder.comment("Maximum vein size for an diamondsand Ore vein. For reference, diamonds have a max vein size of 8. Default = 7").defineInRange("vein_size", 7, 0, 64);
        max_spawn_height = builder.comment("Maximum spawn height size for an diamondsand ore vein. Default = 16").defineInRange("max_spawn_height", 64, 1, 255);
        min_spawn_height = builder.comment("Maximum spawn height size for an diamondsand ore vein. Default = 16").defineInRange("min_spawn_height", 20, 1, 255);
        builder.pop();
        builder.push("network");
        enable_server_config_sync = builder.comment("Sync your config to the server upon joining? (Requires a Minecraft restart afterwards)").define("enable_server_config_sync", true);
        send_config_sync_packet = builder.comment("Sends a packet that attempts to sync the client config file to the server?").define("send_config_sync_packet", true);
        builder.pop();
    }
}

