/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.diamondglass.world;

import com.kreezcraft.diamondglass.DiamondGlass;
import com.kreezcraft.diamondglass.InitBlocks;
import com.kreezcraft.diamondglass.config.DGconfig;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="diamondglass", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModFeatures {
    public static Feature DIAMOND_GLASS_ORE = (Feature)new DiamondGlassOre((Codec<OreFeatureConfig>)OreFeatureConfig.field_236566_a_).setRegistryName("diamond_glass_ore");
    public static final ConfiguredFeature<?, ?> DIAMOND_SAND_CONFIG = (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)"diamond_sand", (Object)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, InitBlocks.diamondSand.func_176223_P(), ((Integer)DGconfig.vein_size.get()).intValue())).func_242733_d(((Integer)DGconfig.max_spawn_height.get()).intValue())).func_242728_a()).func_242731_b(((Integer)DGconfig.min_spawn_height.get()).intValue()));

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        DiamondGlass.LOGGER.debug("Diamond Glass: Registering features...");
        event.getRegistry().register((IForgeRegistryEntry)DIAMOND_GLASS_ORE);
        DiamondGlass.LOGGER.info("Diamond Glass: Features registered!");
    }

    @SubscribeEvent
    public void onBiomeLoading(BiomeLoadingEvent biome) {
        if (biome.getCategory() == Biome.Category.NETHER || biome.getCategory() == Biome.Category.THEEND) {
            return;
        }
        if (((Boolean)DGconfig.overworld.get()).booleanValue()) {
            biome.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> DIAMOND_SAND_CONFIG);
        }
    }

    public static class DiamondGlassOre
    extends OreFeature {
        public DiamondGlassOre(Codec<OreFeatureConfig> codec) {
            super(codec);
        }

        public boolean func_241855_a(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, OreFeatureConfig config) {
            if (rand.nextInt(100) <= (Integer)DGconfig.rarity.get()) {
                return super.func_241855_a(reader, generator, rand, pos, config);
            }
            return false;
        }
    }
}

