/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shaped_nbt;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipeFactory;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.NBTRecipeSerializer;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shaped_nbt.ShapedNBTRecipe;
import de.geheimagentnr1.recipes_lib.elements.recipes.nbt.shaped_nbt.ShapedNBTRecipeFactory;
import de.geheimagentnr1.recipes_lib.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;

public class ShapedNBTRecipeSerializer
extends NBTRecipeSerializer<ShapedNBTRecipe> {
    public ShapedNBTRecipeSerializer() {
        this.setRegistryName("crafting_shaped_nbt");
    }

    @Override
    @Nonnull
    protected Pair<NonNullList<Ingredient>, NBTRecipeFactory<ShapedNBTRecipe>> readRecipeData(@Nonnull JsonObject json) {
        Map<String, Ingredient> keys = this.readKeys(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
        String[] pattern = this.shrink(this.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
        int width = pattern[0].length();
        int height = pattern.length;
        return new Pair<NonNullList<Ingredient>, NBTRecipeFactory<ShapedNBTRecipe>>(this.deserializeIngredients(pattern, keys, width, height), new ShapedNBTRecipeFactory(width, height));
    }

    private Map<String, Ingredient> readKeys(JsonObject json) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : json.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    private String[] patternFromJson(JsonArray patternArray) {
        String[] pattern = new String[patternArray.size()];
        if (pattern.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (pattern.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < pattern.length; ++i) {
            String rowPattern = JSONUtils.func_151206_a((JsonElement)patternArray.get(i), (String)("pattern[" + i + "]"));
            if (rowPattern.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && pattern[0].length() != rowPattern.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            pattern[i] = rowPattern;
        }
        return pattern;
    }

    private String[] shrink(String ... pattern) {
        int first = Integer.MAX_VALUE;
        int last = 0;
        int row = 0;
        int column = 0;
        for (int index = 0; index < pattern.length; ++index) {
            String s = pattern[index];
            first = Math.min(first, this.firstNonSpace(s));
            int lastIndex = this.lastNonSpace(s);
            last = Math.max(last, lastIndex);
            if (lastIndex < 0) {
                if (row == index) {
                    ++row;
                }
                ++column;
                continue;
            }
            column = 0;
        }
        if (pattern.length == column) {
            return new String[0];
        }
        String[] shortPattern = new String[pattern.length - column - row];
        for (int index = 0; index < shortPattern.length; ++index) {
            shortPattern[index] = pattern[index + row].substring(first, last + 1);
        }
        return shortPattern;
    }

    private int firstNonSpace(String str) {
        int i;
        for (i = 0; i < str.length() && str.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private int lastNonSpace(String str) {
        int i;
        for (i = str.length() - 1; i >= 0 && str.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private NonNullList<Ingredient> deserializeIngredients(String[] pattern, Map<String, Ingredient> keys, int patternWidth, int patternHeight) {
        NonNullList ingredients = NonNullList.func_191197_a((int)(patternWidth * patternHeight), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(keys.keySet());
        set.remove(" ");
        for (int i = 0; i < pattern.length; ++i) {
            for (int j = 0; j < pattern[i].length(); ++j) {
                String key = pattern[i].substring(j, j + 1);
                Ingredient ingredient = keys.get(key);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + key + "' but it's not defined in the key");
                }
                set.remove(key);
                ingredients.set(j + patternWidth * i, (Object)ingredient);
            }
        }
        if (set.isEmpty()) {
            return ingredients;
        }
        throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
    }

    @Override
    @Nonnull
    protected Pair<Integer, NBTRecipeFactory<ShapedNBTRecipe>> readRecipeData(@Nonnull PacketBuffer buffer) {
        int width = buffer.func_150792_a();
        int height = buffer.func_150792_a();
        return new Pair<Integer, NBTRecipeFactory<ShapedNBTRecipe>>(width * height, new ShapedNBTRecipeFactory(width, height));
    }

    @Override
    protected void writeRecipeData(@Nonnull PacketBuffer buffer, @Nonnull ShapedNBTRecipe recipe) {
        buffer.func_150787_b(recipe.getRecipeWidth());
        buffer.func_150787_b(recipe.getRecipeHeight());
    }
}

