/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.recipes_lib.elements.recipes.renaming;

import de.geheimagentnr1.recipes_lib.elements.recipes.RecipeSerializers;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt.MatchType;
import de.geheimagentnr1.recipes_lib.elements.recipes.ingredients.nbt.NBTIngredient;
import de.geheimagentnr1.recipes_lib.helpers.ShaplessRecipesHelper;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class RenamingRecipe
implements ICraftingRecipe {
    public static final String registry_name = "renaming";
    private final ResourceLocation id;
    private final Ingredient ingredient;
    private final NonNullList<Ingredient> ingredients;
    private final boolean isSimple;

    RenamingRecipe(ResourceLocation _id, Ingredient _ingredient) {
        this.id = _id;
        this.ingredient = _ingredient;
        this.ingredients = NonNullList.func_191196_a();
        this.ingredients.addAll(Arrays.asList(this.buildNameTagIngredient(), this.ingredient));
        this.isSimple = this.ingredients.stream().allMatch(Ingredient::isSimple);
    }

    private Ingredient buildNameTagIngredient() {
        CompoundNBT name_tag_nbt = new CompoundNBT();
        name_tag_nbt.func_218657_a("display", (INBT)new CompoundNBT());
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151057_cb);
        stack.func_77982_d(name_tag_nbt);
        return NBTIngredient.fromStack(stack, MatchType.CONTAINS);
    }

    @Nonnull
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    @Nonnull
    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.RENAMING;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.ingredient.func_193365_a()[0];
    }

    @Nonnull
    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public boolean matches(@Nonnull CraftingInventory inv, @Nonnull World worldIn) {
        return ShaplessRecipesHelper.matches(this, inv, this.ingredients, this.isSimple);
    }

    @Nonnull
    public ItemStack getCraftingResult(@Nonnull CraftingInventory inv) {
        ItemStack stack;
        int j;
        ItemStack result = ItemStack.field_190927_a;
        ITextComponent resultDisplayName = null;
        for (j = 0; j < inv.func_70302_i_(); ++j) {
            stack = inv.func_70301_a(j);
            if (stack.func_190926_b() || stack.func_77973_b() == Items.field_151057_cb) continue;
            result = stack.func_77946_l();
        }
        for (j = 0; j < inv.func_70302_i_(); ++j) {
            stack = inv.func_70301_a(j);
            if (stack.func_77973_b() != Items.field_151057_cb) continue;
            resultDisplayName = stack.func_200301_q();
        }
        if (result.func_200301_q().equals(resultDisplayName)) {
            return ItemStack.field_190927_a;
        }
        result.func_200302_a(resultDisplayName);
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }
}

