/*
 * Decompiled with CFR 0.152.
 */
package me.elementz.enchantingbooks;

import java.util.Map;
import me.elementz.enchantingbooks.blocks.BlockRegistration;
import me.elementz.enchantingbooks.config.Config;
import me.elementz.enchantingbooks.item.CustomBookItem;
import me.elementz.enchantingbooks.item.CustomEnchantedBookItem;
import me.elementz.enchantingbooks.item.ItemRegistration;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.EnchantmentContainer;
import net.minecraft.inventory.container.GrindstoneContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enchantingbooks")
public class EnchantingBooks {
    public static final String ID = "enchantingbooks";
    public static final String VERSION = "1.1.0";
    private static final Logger LOGGER = LogManager.getLogger();

    public EnchantingBooks() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("enchantingbooks-common.toml"));
        ItemRegistration.register();
        BlockRegistration.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("[Enchanting Books] - Hit Pre Init - 1.1.0");
    }

    @SubscribeEvent
    public void onEnchantmentChange(PlayerContainerEvent.Open event) {
        if (!(event.getContainer() instanceof EnchantmentContainer)) {
            return;
        }
        EnchantmentContainer container = (EnchantmentContainer)event.getContainer();
        Slot slot = (Slot)container.field_75151_b.get(0);
        Inventory inventory = (Inventory)slot.field_75224_c;
        inventory.func_110134_a(invBasic -> {
            ItemStack itemStack = invBasic.func_70301_a(0);
            if (!(itemStack.func_77973_b() instanceof CustomBookItem) || !itemStack.func_77948_v()) {
                return;
            }
            Map<Enchantment, Integer> enchantments = EnchantingBooks.getEnchantments(itemStack);
            if (itemStack.func_77973_b() == ItemRegistration.IRON_BOOK.get()) {
                itemStack = new ItemStack((IItemProvider)ItemRegistration.ENCHANTED_IRON_BOOK.get(), 1);
            } else if (itemStack.func_77973_b() == ItemRegistration.GOLDEN_BOOK.get()) {
                itemStack = new ItemStack((IItemProvider)ItemRegistration.ENCHANTED_GOLDEN_BOOK.get(), 1);
            } else if (itemStack.func_77973_b() == ItemRegistration.DIAMOND_BOOK.get()) {
                itemStack = new ItemStack((IItemProvider)ItemRegistration.ENCHANTED_DIAMOND_BOOK.get(), 1);
            } else if (itemStack.func_77973_b() == ItemRegistration.NETHERITE_BOOK.get()) {
                itemStack = new ItemStack((IItemProvider)ItemRegistration.ENCHANTED_NETHERITE_BOOK.get(), 1);
            }
            EnchantingBooks.setEnchantments(enchantments, itemStack);
            invBasic.func_70299_a(0, itemStack);
        });
    }

    @SubscribeEvent
    public void onGrindstoneChange(PlayerContainerEvent.Open event) {
        if (!(event.getContainer() instanceof GrindstoneContainer)) {
            return;
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        ItemStack itemStackLeft = event.getLeft();
        ItemStack itemStackRight = event.getRight();
        int i = 0;
        int j = 0;
        int k = 0;
        boolean flag = false;
        if (itemStackRight.func_77973_b() instanceof CustomEnchantedBookItem || itemStackLeft.func_77973_b() instanceof CustomEnchantedBookItem) {
            Map<Enchantment, Integer> enchantmentsLeft = EnchantingBooks.getEnchantments(itemStackLeft);
            Map<Enchantment, Integer> enchantmentsRight = EnchantingBooks.getEnchantments(itemStackRight);
            if (enchantmentsRight.isEmpty()) {
                return;
            }
            flag = itemStackRight.func_77973_b() instanceof EnchantedBookItem && !enchantmentsRight.isEmpty() ? true : itemStackRight.func_77973_b() instanceof CustomEnchantedBookItem && !enchantmentsRight.isEmpty();
            ItemStack itemStackOut = itemStackLeft.func_77946_l();
            boolean flag2 = false;
            boolean flag3 = false;
            j = j + itemStackOut.func_82838_A() + (itemStackRight.func_190926_b() ? 0 : itemStackRight.func_82838_A());
            for (Enchantment enchantment1 : enchantmentsRight.keySet()) {
                int j2;
                if (enchantment1 == null) continue;
                int i2 = enchantmentsLeft.getOrDefault(enchantment1, 0);
                j2 = i2 == (j2 = enchantmentsRight.get(enchantment1).intValue()) ? j2 + 1 : Math.max(j2, i2);
                boolean flag1 = enchantment1.func_92089_a(itemStackOut);
                if (event.getPlayer().func_184812_l_() || itemStackLeft.func_77973_b() instanceof CustomEnchantedBookItem || itemStackRight.func_77973_b() instanceof CustomEnchantedBookItem) {
                    flag1 = true;
                }
                for (Enchantment enchantment : enchantmentsLeft.keySet()) {
                    if (enchantment == enchantment1 || enchantment1.func_191560_c(enchantment)) continue;
                    flag1 = false;
                    ++i;
                }
                if (!flag1) {
                    flag3 = true;
                    continue;
                }
                flag2 = true;
                if (j2 > enchantment1.func_77325_b()) {
                    j2 = enchantment1.func_77325_b();
                }
                enchantmentsLeft.put(enchantment1, j2);
                int k3 = 0;
                switch (enchantment1.func_77324_c()) {
                    case COMMON: {
                        k3 = 1;
                        break;
                    }
                    case UNCOMMON: {
                        k3 = 2;
                        break;
                    }
                    case RARE: {
                        k3 = 4;
                        break;
                    }
                    case VERY_RARE: {
                        k3 = 8;
                    }
                }
                if (flag) {
                    k3 = Math.max(1, k3 / 2);
                }
                i += k3 * j2;
                if (itemStackOut.func_190916_E() <= 1) continue;
                i = 40;
            }
            if (flag3 && !flag2) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)event.getName())) {
                if (itemStackOut.func_82837_s()) {
                    k = 1;
                    i += k;
                    itemStackOut.func_135074_t();
                }
            } else if (!event.getName().equals(itemStackOut.func_200301_q().getString())) {
                k = 1;
                i += k;
                itemStackOut.func_200302_a((ITextComponent)new StringTextComponent(event.getName()));
            }
            if (flag && !itemStackOut.isBookEnchantable(itemStackRight)) {
                itemStackOut = ItemStack.field_190927_a;
            }
            event.setCost(j + i);
            if (i <= 0) {
                itemStackOut = ItemStack.field_190927_a;
            }
            if (k == i && k > 0 && event.getCost() >= 40) {
                event.setCost(39);
            }
            if (event.getCost() >= 40 && !event.getPlayer().func_184812_l_()) {
                itemStackOut = ItemStack.field_190927_a;
            }
            if (!itemStackOut.func_190926_b()) {
                int k2 = itemStackOut.func_82838_A();
                if (!itemStackRight.func_190926_b() && k2 < itemStackRight.func_82838_A()) {
                    k2 = itemStackRight.func_82838_A();
                }
                if (k != i || k == 0) {
                    k2 = EnchantingBooks.getNewRepairCost(k2);
                }
                itemStackOut.func_82841_c(k2);
                EnchantingBooks.setEnchantments(enchantmentsLeft, itemStackOut);
            }
            event.setOutput(itemStackOut);
        }
    }

    public static int getNewRepairCost(int oldRepairCost) {
        return oldRepairCost * 2 + 1;
    }

    public static void setEnchantments(Map<Enchantment, Integer> enchMap, ItemStack stack) {
        ListNBT listnbt = new ListNBT();
        for (Map.Entry<Enchantment, Integer> entry : enchMap.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("id", String.valueOf(Registry.field_212628_q.func_177774_c((Object)enchantment)));
            compoundnbt.func_74777_a("lvl", (short)i);
            listnbt.add((Object)compoundnbt);
            if (stack.func_77973_b() instanceof CustomEnchantedBookItem) {
                CustomEnchantedBookItem.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(enchantment, i));
                continue;
            }
            if (!(stack.func_77973_b() instanceof EnchantedBookItem)) continue;
            EnchantedBookItem.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(enchantment, i));
        }
        if (listnbt.isEmpty()) {
            stack.func_196083_e("Enchantments");
        } else if (!(stack.func_77973_b() instanceof CustomEnchantedBookItem) && !(stack.func_77973_b() instanceof EnchantedBookItem)) {
            stack.func_77983_a("Enchantments", (INBT)listnbt);
        }
    }

    public static Map<Enchantment, Integer> getEnchantments(ItemStack stack) {
        if (stack.func_77973_b() instanceof CustomEnchantedBookItem) {
            ListNBT listnbt = stack.func_77973_b() instanceof CustomEnchantedBookItem ? CustomEnchantedBookItem.func_92110_g((ItemStack)stack) : stack.func_77986_q();
            return EnchantmentHelper.func_226652_a_((ListNBT)listnbt);
        }
        ListNBT listnbt = stack.func_77973_b() instanceof EnchantedBookItem ? EnchantedBookItem.func_92110_g((ItemStack)stack) : stack.func_77986_q();
        return EnchantmentHelper.func_226652_a_((ListNBT)listnbt);
    }
}

