/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Inventories;

public class EdCatwalkBlock
extends DecorBlock.HorizontalFourWayWaterLoggable
implements IDecorBlock {
    final Block railing_block;
    final AxisAlignedBB base_aabb;

    public EdCatwalkBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB base_aabb, AxisAlignedBB railing_aabb, Block railing_block) {
        super(config, properties, base_aabb, railing_aabb, 0);
        this.railing_block = railing_block;
        this.base_aabb = base_aabb;
    }

    @Override
    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false));
    }

    public static boolean place_consume(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, int shrink) {
        if (!world.func_180501_a(pos, state, 3)) {
            return false;
        }
        world.func_184133_a(player, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!player.func_184812_l_() && !world.func_201670_d()) {
            ItemStack stack = player.func_184586_b(hand);
            if (shrink >= 0) {
                stack.func_190918_g(shrink);
            } else if (stack.func_190916_E() < stack.func_77976_d()) {
                stack.func_190917_f(Math.abs(shrink));
            } else {
                Inventories.give(player, new ItemStack((IItemProvider)stack.func_77973_b(), Math.abs(shrink)));
            }
            Inventories.setItemInPlayerHand(player, hand, stack);
        }
        return true;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Item item = player.func_184586_b(hand).func_77973_b();
        if (!(item instanceof BlockItem)) {
            return ActionResultType.PASS;
        }
        Block block = ((BlockItem)item).func_179223_d();
        if (block == this) {
            if (hit.func_216354_b().func_176740_k().func_176722_c()) {
                return ActionResultType.PASS;
            }
            BlockPos adjacent_pos = pos.func_177972_a(player.func_174811_aO());
            BlockState adjacent_state = world.func_180495_p(adjacent_pos);
            if (adjacent_state.func_196953_a((BlockItemUseContext)new DirectionalPlaceContext(world, adjacent_pos, hit.func_216354_b().func_176734_d(), player.func_184586_b(hand), hit.func_216354_b()))) {
                BlockState place_state = this.func_176223_P();
                place_state = (BlockState)place_state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(adjacent_state.func_204520_s().func_206886_c() == Fluids.field_204546_a));
                EdCatwalkBlock.place_consume(place_state, world, adjacent_pos, player, hand, 1);
            }
            return world.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        if (block == this.railing_block) {
            BooleanProperty railing;
            Direction face = hit.func_216354_b();
            Vector3d rhv = hit.func_216347_e().func_178788_d(Vector3d.func_237489_a_((Vector3i)hit.func_216350_a()));
            if (face.func_176740_k().func_176722_c()) {
                if (rhv.func_216369_h(Vector3d.func_237491_b_((Vector3i)face.func_176730_m())).func_186678_a(2.0).func_189985_c() < 0.99) {
                    face = face.func_176734_d();
                }
            } else if (player.func_195048_a(Vector3d.func_237489_a_((Vector3i)pos)) < 3.0) {
                face = Direction.func_210769_a((double)rhv.field_72450_a, (double)0.0, (double)rhv.field_72449_c);
            } else {
                face = Direction.func_210769_a((double)player.func_70040_Z().field_72450_a, (double)0.0, (double)player.func_70040_Z().field_72449_c);
                List free_sides = Arrays.stream(Direction.values()).filter(d -> d.func_176740_k().func_176722_c() && world.func_180495_p(pos.func_177972_a(d)).func_177230_c() != this).collect(Collectors.toList());
                if (free_sides.isEmpty()) {
                    return world.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
                }
                if (!free_sides.contains(face)) {
                    face = (Direction)free_sides.get(0);
                }
            }
            boolean add = (Boolean)state.func_177229_b((Property)(railing = EdCatwalkBlock.getDirectionProperty(face))) == false;
            EdCatwalkBlock.place_consume((BlockState)state.func_206870_a((Property)railing, (Comparable)Boolean.valueOf(add)), world, pos, player, hand, add ? 1 : -1);
            return world.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean hasDynamicDropList() {
        return true;
    }

    @Override
    public List<ItemStack> dropList(BlockState state, World world, @Nullable TileEntity te, boolean explosion) {
        if (world.func_201670_d()) {
            return Collections.singletonList(ItemStack.field_190927_a);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((IItemProvider)state.func_177230_c().func_199767_j()));
        int n = ((Boolean)state.func_177229_b((Property)NORTH) != false ? 1 : 0) + ((Boolean)state.func_177229_b((Property)EAST) != false ? 1 : 0) + ((Boolean)state.func_177229_b((Property)SOUTH) != false ? 1 : 0) + ((Boolean)state.func_177229_b((Property)WEST) != false ? 1 : 0);
        if (n > 0) {
            drops.add(new ItemStack((IItemProvider)ModContent.STEEL_RAILING, n));
        }
        return drops;
    }
}

