/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Fluidics;
import wile.engineersdecor.libmc.detail.Overlay;

public class EdFluidBarrel {
    private static int capacity_ = 12000;
    private static int item_fluid_handler_transfer_rate_ = 1000;
    private static int tile_fluid_handler_transfer_rate_ = 1000;

    public static void on_config(int tank_capacity, int transfer_rate) {
        capacity_ = MathHelper.func_76125_a((int)tank_capacity, (int)2000, (int)64000);
        item_fluid_handler_transfer_rate_ = tile_fluid_handler_transfer_rate_ = MathHelper.func_76125_a((int)tank_capacity, (int)50, (int)4096);
        ModConfig.log("Config fluid barrel: capacity:" + capacity_ + "mb, transfer-rate:" + tile_fluid_handler_transfer_rate_ + "mb/t.");
    }

    public static class FluidBarrelItem
    extends BlockItem {
        public FluidBarrelItem(Block block, Item.Properties builder) {
            super(block, builder);
        }

        private static CompoundNBT read_fluid_nbt(ItemStack stack) {
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
                return new CompoundNBT();
            }
            CompoundNBT nbt = stack.func_77978_p().func_74775_l("tedata");
            if (!nbt.func_150297_b("tank", 10)) {
                return new CompoundNBT();
            }
            return nbt.func_74775_l("tank");
        }

        private static void write_fluid_nbt(ItemStack stack, CompoundNBT fluid_nbt) {
            if (fluid_nbt == null || fluid_nbt.isEmpty()) {
                if (!stack.func_77942_o() || !stack.func_77978_p().func_150297_b("tedata", 10)) {
                    return;
                }
                CompoundNBT tag = stack.func_77978_p();
                CompoundNBT tedata = tag.func_74775_l("tedata");
                if (tedata.func_74764_b("tank")) {
                    tedata.func_82580_o("tank");
                }
                if (tedata.isEmpty()) {
                    tag.func_82580_o("tedata");
                }
                stack.func_77982_d(tag.isEmpty() ? null : tag);
            } else {
                CompoundNBT tedata;
                CompoundNBT tag = stack.func_77978_p();
                if (tag == null) {
                    tag = new CompoundNBT();
                }
                if ((tedata = tag.func_74775_l("tedata")) == null) {
                    tedata = new CompoundNBT();
                }
                tedata.func_218657_a("tank", (INBT)fluid_nbt);
                tag.func_218657_a("tedata", (INBT)tedata);
                stack.func_77982_d(tag);
            }
        }

        public static FluidStack getFluid(ItemStack stack) {
            CompoundNBT nbt = FluidBarrelItem.read_fluid_nbt(stack);
            return nbt.isEmpty() ? FluidStack.EMPTY : FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt);
        }

        public static ItemStack setFluid(ItemStack stack, FluidStack fs) {
            FluidBarrelItem.write_fluid_nbt(stack, fs.writeToNBT(new CompoundNBT()));
            return stack;
        }

        public int getItemStackLimit(ItemStack stack) {
            return !FluidBarrelItem.getFluid(stack).isEmpty() ? 1 : super.getItemStackLimit(stack);
        }

        public boolean showDurabilityBar(ItemStack stack) {
            return !FluidBarrelItem.getFluid(stack).isEmpty();
        }

        public double getDurabilityForDisplay(ItemStack stack) {
            return 1.0 - MathHelper.func_151237_a((double)((double)FluidBarrelItem.getFluid(stack).getAmount() / (double)capacity_), (double)0.0, (double)1.0);
        }

        public int getRGBDurabilityForDisplay(ItemStack stack) {
            return 0x336633;
        }

        public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
            return new Fluidics.FluidContainerItemCapabilityWrapper(stack, capacity_, item_fluid_handler_transfer_rate_, s -> FluidBarrelItem.read_fluid_nbt(s), (s, n) -> FluidBarrelItem.write_fluid_nbt(s, n), e -> true);
        }

        public boolean hasContainerItem(ItemStack stack) {
            return true;
        }

        public ItemStack getContainerItem(ItemStack stack) {
            FluidStack fs = FluidBarrelItem.getFluid(stack);
            if (fs.getAmount() > 1000) {
                fs.shrink(1000);
            } else {
                fs = FluidStack.EMPTY;
            }
            return FluidBarrelItem.setFluid(stack, fs);
        }
    }

    public static class FluidBarrelTileEntity
    extends TileEntity
    implements ICapabilityProvider,
    ITickableTileEntity {
        private final int TICK_INTERVAL = 10;
        private int tick_timer_ = 0;
        private final Fluidics.Tank tank_ = new Fluidics.Tank(EdFluidBarrel.access$000());
        private final LazyOptional<IFluidHandler> fluid_handler_;

        public FluidBarrelTileEntity() {
            this(ModContent.TET_FLUID_BARREL);
        }

        public FluidBarrelTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.tank_.setInteractionNotifier((t, d) -> this.on_tank_changed());
            this.fluid_handler_ = this.tank_.createFluidHandler();
        }

        public void readnbt(CompoundNBT nbt) {
            this.tank_.load(nbt);
        }

        public CompoundNBT writenbt(CompoundNBT nbt) {
            this.tank_.save(nbt);
            return nbt;
        }

        public boolean handlePlayerInteraction(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand) {
            SoundEvent se;
            if (world.func_201670_d()) {
                return false;
            }
            Tuple<Fluid, Integer> transferred = Fluidics.manualTrackedFluidHandlerInteraction(world, pos, null, player, hand);
            if (transferred == null) {
                world.func_184133_a(null, pos, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 0.2f, 0.02f);
            } else if ((Integer)transferred.func_76340_b() > 0) {
                se = transferred.func_76341_a() == Fluids.field_204547_b ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
                world.func_184133_a(null, pos, se, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                se = transferred.func_76341_a() == Fluids.field_204547_b ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                world.func_184133_a(null, pos, se, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            int vol = this.tank_.getFluidAmount();
            int cap = this.tank_.getCapacity();
            String name = new TranslationTextComponent(this.tank_.getFluid().getTranslationKey()).getString();
            if (vol > 0 && cap > 0) {
                Overlay.show(player, (ITextComponent)Auxiliaries.localizable("block.engineersdecor.fluid_barrel.status", Integer.toString(vol), Integer.toString(cap), name));
            } else {
                Overlay.show(player, (ITextComponent)Auxiliaries.localizable("block.engineersdecor.fluid_barrel.status.empty", Integer.toString(vol), Integer.toString(cap)));
            }
            return true;
        }

        public double getNormalizedFillLevel() {
            return this.tank_.isEmpty() ? 0.0 : (double)this.tank_.getFluidAmount() / (double)this.tank_.getCapacity();
        }

        protected void on_tank_changed() {
            if (this.tick_timer_ > 2) {
                this.tick_timer_ = 2;
            }
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            return this.writenbt(nbt);
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.fluid_handler_.invalidate();
        }

        public CompoundNBT clear_getnbt() {
            return this.tank_.save(new CompoundNBT());
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.fluid_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private boolean transfer_down() {
            int nfilled;
            if (this.tank_.isEmpty()) {
                return false;
            }
            IFluidHandler fh = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177977_b(), (Direction)Direction.UP).orElse(null);
            if (fh == null) {
                return false;
            }
            FluidStack fs = this.tank_.getFluid().copy();
            if (fs.getAmount() > tile_fluid_handler_transfer_rate_) {
                fs.setAmount(tile_fluid_handler_transfer_rate_);
            }
            if ((nfilled = fh.fill(fs, IFluidHandler.FluidAction.EXECUTE)) <= 0) {
                return false;
            }
            this.tank_.drain(nfilled, IFluidHandler.FluidAction.EXECUTE);
            return true;
        }

        public void func_73660_a() {
            double norm_level;
            int fill_level;
            if (this.field_145850_b.func_201670_d() || --this.tick_timer_ >= 0) {
                return;
            }
            this.tick_timer_ = 10;
            BlockState state = this.func_195044_w();
            Block block = state.func_177230_c();
            if (!(block instanceof FluidBarrelBlock)) {
                return;
            }
            if (((Direction)state.func_177229_b((Property)FluidBarrelBlock.FACING)).func_176740_k().func_200128_b()) {
                this.transfer_down();
            }
            int n = fill_level = (norm_level = this.getNormalizedFillLevel()) <= 0.0 ? 0 : (int)MathHelper.func_151237_a((double)(norm_level * 4.0 + 0.5), (double)1.0, (double)4.0);
            if (fill_level != (Integer)state.func_177229_b((Property)FluidBarrelBlock.FILL_LEVEL)) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)FluidBarrelBlock.FILL_LEVEL, (Comparable)Integer.valueOf(fill_level)), 2);
                this.field_145850_b.func_195593_d(this.field_174879_c, block);
            }
        }
    }

    public static class FluidBarrelBlock
    extends DecorBlock.DirectedWaterLoggable
    implements IDecorBlock,
    StandardBlocks.IBlockItemFactory {
        public static final int FILL_LEVEL_MAX = 4;
        public static final IntegerProperty FILL_LEVEL = IntegerProperty.func_177719_a((String)"level", (int)0, (int)4);

        public FluidBarrelBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
            this.func_180632_j((BlockState)((BlockState)super.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0)));
        }

        @Override
        public BlockItem getBlockItem(Block block, Item.Properties builder) {
            return new FluidBarrelItem(block, builder);
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof FluidBarrelTileEntity)) {
                return stacks;
            }
            ItemStack stack = new ItemStack((IItemProvider)this, 1);
            CompoundNBT te_nbt = ((FluidBarrelTileEntity)te).clear_getnbt();
            if (!te_nbt.isEmpty()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("tedata", (INBT)te_nbt);
                stack.func_77982_d(nbt);
            }
            stacks.add(stack);
            return stacks;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
            if (!(stack.func_77973_b() instanceof FluidBarrelItem) || Auxiliaries.Tooltip.helpCondition()) {
                super.func_190948_a(stack, world, tooltip, flag);
                return;
            }
            FluidStack fs = FluidBarrelItem.getFluid(stack);
            if (!fs.isEmpty()) {
                tooltip.add((ITextComponent)Auxiliaries.localizable(this.func_149739_a() + ".status.tip", Integer.toString(fs.getAmount()), Integer.toString(capacity_), new TranslationTextComponent(fs.getTranslationKey())));
            } else {
                tooltip.add((ITextComponent)Auxiliaries.localizable(this.func_149739_a() + ".status.tip.empty", "0", Integer.toString(capacity_)));
            }
            if (!Auxiliaries.Tooltip.extendedTipCondition()) {
                super.func_190948_a(stack, world, tooltip, flag);
            }
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new FluidBarrelTileEntity();
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{FILL_LEVEL});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            BlockState state = super.func_196258_a(context);
            if (!context.func_195999_j().func_225608_bj_()) {
                state = (BlockState)state.func_206870_a((Property)FACING, (Comparable)Direction.UP);
            }
            return state;
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.field_72995_K) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
                return;
            }
            CompoundNBT te_nbt = stack.func_77978_p().func_74775_l("tedata");
            if (te_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof FluidBarrelTileEntity)) {
                return;
            }
            ((FluidBarrelTileEntity)te).readnbt(te_nbt);
            ((FluidBarrelTileEntity)te).func_70296_d();
            world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (player.func_184586_b(hand).func_77973_b() == this.func_199767_j()) {
                return ActionResultType.PASS;
            }
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof FluidBarrelTileEntity)) {
                return ActionResultType.FAIL;
            }
            if (!((FluidBarrelTileEntity)te).handlePlayerInteraction(state, world, pos, player, hand)) {
                return ActionResultType.PASS;
            }
            world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            return ActionResultType.CONSUME;
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState state, World world, BlockPos pos) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof FluidBarrelTileEntity)) {
                return 0;
            }
            return (int)MathHelper.func_151237_a((double)(((FluidBarrelTileEntity)te).getNormalizedFillLevel() * 15.0), (double)0.0, (double)15.0);
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }
    }
}

