/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Fluidics;

public class EdFreezer {
    public static void on_config(int consumption, int cooldown_per_second) {
        FreezerTileEntity.on_config(consumption, cooldown_per_second);
    }

    public static class FreezerTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    IEnergyStorage,
    ICapabilityProvider {
        public static final int TICK_INTERVAL = 20;
        public static final int MAX_FLUID_LEVEL = 2000;
        public static final int MAX_ENERGY_BUFFER = 32000;
        public static final int MAX_ENERGY_TRANSFER = 8192;
        public static final int TANK_CAPACITY = 2000;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 92;
        public static final int DEFAULT_COOLDOWN_RATE = 2;
        public static final int PHASE_EMPTY = 0;
        public static final int PHASE_WATER = 1;
        public static final int PHASE_ICE = 2;
        public static final int PHASE_PACKEDICE = 3;
        public static final int PHASE_BLUEICE = 4;
        private static int energy_consumption = 92;
        private static int cooldown_rate = 2;
        private static int reheat_rate = 1;
        private final Fluidics.Tank tank_ = new Fluidics.Tank(2000, 2000, 2000, fs -> fs.getFluid() == Fluids.field_204546_a);
        private int tick_timer_;
        private int energy_stored_;
        private int progress_;
        private boolean force_block_update_;
        private LazyOptional<IItemHandler> item_handler_ = LazyOptional.of(() -> new FreezerItemHandler(this));
        private final LazyOptional<IFluidHandler> fluid_handler_ = LazyOptional.of(() -> new Fluidics.SingleTankFluidHandler(this.tank_));
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int consumption, int cooldown_per_second) {
            energy_consumption = MathHelper.func_76125_a((int)consumption, (int)8, (int)4096);
            cooldown_rate = MathHelper.func_76125_a((int)cooldown_per_second, (int)1, (int)5);
            reheat_rate = MathHelper.func_76125_a((int)(cooldown_per_second / 2), (int)1, (int)5);
            ModConfig.log("Config freezer energy consumption:" + energy_consumption + "rf/t, cooldown-rate: " + cooldown_rate + "%/s.");
        }

        public FreezerTileEntity() {
            this(ModContent.TET_FREEZER);
        }

        public FreezerTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public int progress() {
            return this.progress_;
        }

        public int phase() {
            if (this.tank_.getFluidAmount() < 1000) {
                return 0;
            }
            if (this.progress_ >= 100) {
                return 4;
            }
            if (this.progress_ >= 70) {
                return 3;
            }
            if (this.progress_ >= 30) {
                return 2;
            }
            return 1;
        }

        public ItemStack getIceItem(boolean extract) {
            ItemStack stack;
            switch (this.phase()) {
                case 2: {
                    stack = new ItemStack((IItemProvider)Items.field_221770_cu);
                    break;
                }
                case 3: {
                    stack = new ItemStack((IItemProvider)Items.field_221898_fg);
                    break;
                }
                case 4: {
                    stack = new ItemStack((IItemProvider)Items.field_222047_ii);
                    break;
                }
                default: {
                    return ItemStack.field_190927_a;
                }
            }
            if (extract) {
                this.reset_process();
            }
            return stack;
        }

        public int comparator_signal() {
            return this.phase() * 4;
        }

        protected void reset_process() {
            this.force_block_update_ = true;
            this.tank_.drain(1000);
            this.tick_timer_ = 0;
            this.progress_ = 0;
        }

        public void readnbt(CompoundNBT nbt) {
            this.energy_stored_ = nbt.func_74762_e("energy");
            this.progress_ = nbt.func_74762_e("progress");
            this.tank_.load(nbt);
        }

        protected void writenbt(CompoundNBT nbt) {
            nbt.func_74768_a("energy", MathHelper.func_76125_a((int)this.energy_stored_, (int)0, (int)32000));
            nbt.func_74768_a("progress", MathHelper.func_76125_a((int)this.progress_, (int)0, (int)100));
            this.tank_.save(nbt);
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.energy_handler_.invalidate();
            this.fluid_handler_.invalidate();
            this.item_handler_.invalidate();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return 32000;
        }

        public int getEnergyStored() {
            return this.energy_stored_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.energy_stored_ >= 32000) {
                return 0;
            }
            int n = Math.min(maxReceive, 32000 - this.energy_stored_);
            if (n > 8192) {
                n = 8192;
            }
            if (!simulate) {
                this.energy_stored_ += n;
                this.func_70296_d();
            }
            return n;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.fluid_handler_.cast();
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 20;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof FreezerBlock)) {
                return;
            }
            boolean dirty = false;
            int last_phase = this.phase();
            if (this.tank_.getFluidAmount() < 1000) {
                this.progress_ = 0;
            } else if (this.energy_stored_ <= 0 || this.field_145850_b.func_175640_z(this.field_174879_c)) {
                this.progress_ = MathHelper.func_76125_a((int)(this.progress_ - reheat_rate), (int)0, (int)100);
            } else if (this.progress_ >= 100) {
                this.progress_ = 100;
                this.energy_stored_ = MathHelper.func_76125_a((int)(this.energy_stored_ - energy_consumption * 20 / 20), (int)0, (int)32000);
            } else {
                this.energy_stored_ = MathHelper.func_76125_a((int)(this.energy_stored_ - energy_consumption * 20), (int)0, (int)32000);
                this.progress_ = MathHelper.func_76125_a((int)(this.progress_ + cooldown_rate), (int)0, (int)100);
            }
            int new_phase = this.phase();
            if (new_phase > last_phase) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187749_eC, SoundCategory.BLOCKS, 0.2f, 0.7f);
            } else if (new_phase < last_phase) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187749_eC, SoundCategory.BLOCKS, 0.2f, 0.7f);
            }
            if (this.force_block_update_ || (Integer)state.func_177229_b((Property)FreezerBlock.PHASE) != new_phase) {
                state = (BlockState)state.func_206870_a((Property)FreezerBlock.PHASE, (Comparable)Integer.valueOf(new_phase));
                this.field_145850_b.func_180501_a(this.field_174879_c, state, 19);
                this.field_145850_b.func_195593_d(this.func_174877_v(), state.func_177230_c());
                this.force_block_update_ = false;
            }
            if (dirty) {
                this.func_70296_d();
            }
        }

        protected static class FreezerItemHandler
        implements IItemHandler {
            private FreezerTileEntity te;

            FreezerItemHandler(FreezerTileEntity te) {
                this.te = te;
            }

            public int getSlots() {
                return 1;
            }

            public int getSlotLimit(int index) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }

            @Nonnull
            public ItemStack getStackInSlot(int index) {
                return index != 0 ? ItemStack.field_190927_a : this.te.getIceItem(false);
            }

            @Nonnull
            public ItemStack insertItem(int index, @Nonnull ItemStack stack, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack extractItem(int index, int amount, boolean simulate) {
                return this.te.getIceItem(!simulate);
            }
        }
    }

    public static class FreezerBlock
    extends DecorBlock.Horizontal
    implements IDecorBlock {
        public static final int PHASE_MAX = 4;
        public static final IntegerProperty PHASE = IntegerProperty.func_177719_a((String)"phase", (int)0, (int)4);

        public FreezerBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{PHASE});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)super.func_196258_a(context).func_206870_a((Property)PHASE, (Comparable)Integer.valueOf(0));
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState state, World world, BlockPos pos) {
            return MathHelper.func_76125_a((int)((Integer)state.func_177229_b((Property)PHASE) * 4), (int)0, (int)15);
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new FreezerTileEntity();
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof FreezerTileEntity)) {
                return stacks;
            }
            ((FreezerTileEntity)te).reset_process();
            stacks.add(new ItemStack((IItemProvider)this, 1));
            return stacks;
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (player.func_225608_bj_()) {
                return ActionResultType.PASS;
            }
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            FreezerTileEntity te = this.getTe(world, pos);
            if (te == null) {
                return ActionResultType.FAIL;
            }
            ItemStack stack = player.func_184586_b(hand);
            boolean dirty = false;
            if (Fluidics.manualFluidHandlerInteraction(world, pos, null, player, hand)) {
                world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.5f, 1.4f);
                return ActionResultType.CONSUME;
            }
            if (stack.func_77973_b() == Items.field_151131_as) {
                return ActionResultType.CONSUME;
            }
            if (stack.func_190926_b()) {
                ItemStack ice = te.getIceItem(true);
                if (!ice.func_190926_b()) {
                    player.func_191521_c(ice);
                    world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.3f, 1.1f);
                } else {
                    world.func_184133_a(null, pos, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 0.2f, 0.02f);
                }
                return ActionResultType.CONSUME;
            }
            return ActionResultType.PASS;
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rnd) {
        }

        @Nullable
        private FreezerTileEntity getTe(World world, BlockPos pos) {
            TileEntity te = world.func_175625_s(pos);
            return !(te instanceof FreezerTileEntity) ? null : (FreezerTileEntity)te;
        }
    }
}

