/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.client.ContainerGui;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.TooltipDisplay;

public class EdHopper {
    public static void on_config() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class HopperGui
    extends ContainerGui<HopperContainer> {
        protected final PlayerEntity player_;
        protected final TooltipDisplay tooltip_ = new TooltipDisplay();

        public HopperGui(HopperContainer container, PlayerInventory player_inventory, ITextComponent title) {
            super(container, player_inventory, title);
            this.player_ = player_inventory.field_70458_d;
        }

        public void func_231160_c_() {
            super.func_231160_c_();
            String prefix = ModContent.FACTORY_HOPPER.func_149739_a() + ".tooltips.";
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            this.tooltip_.init(new TooltipDisplay.TipRange(x0 + 148, y0 + 22, 3, 3, (ITextComponent)new TranslationTextComponent(prefix + "delayindicator")), new TooltipDisplay.TipRange(x0 + 130, y0 + 9, 40, 10, (ITextComponent)new TranslationTextComponent(prefix + "range")), new TooltipDisplay.TipRange(x0 + 130, y0 + 22, 40, 10, (ITextComponent)new TranslationTextComponent(prefix + "period")), new TooltipDisplay.TipRange(x0 + 130, y0 + 35, 40, 10, (ITextComponent)new TranslationTextComponent(prefix + "count")), new TooltipDisplay.TipRange(x0 + 133, y0 + 49, 9, 9, (ITextComponent)new TranslationTextComponent(prefix + "rssignal")), new TooltipDisplay.TipRange(x0 + 145, y0 + 49, 9, 9, (ITextComponent)new TranslationTextComponent(prefix + "inversion")), new TooltipDisplay.TipRange(x0 + 159, y0 + 49, 9, 9, (ITextComponent)new TranslationTextComponent(prefix + "triggermode")));
        }

        public void func_230430_a_(MatrixStack mx, int mouseX, int mouseY, float partialTicks) {
            this.func_230446_a_(mx);
            super.func_230430_a_(mx, mouseX, mouseY, partialTicks);
            if (!this.tooltip_.render(mx, this, mouseX, mouseY)) {
                this.func_230459_a_(mx, mouseX, mouseY);
            }
        }

        protected void func_230451_b_(MatrixStack mx, int x, int y) {
        }

        protected void func_184098_a(Slot slot, int slotId, int button, ClickType type) {
            this.tooltip_.resetTimer();
            if (type == ClickType.QUICK_MOVE && slot != null && slot.func_75216_d() && Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("slot", slotId);
                ((HopperContainer)this.field_147002_h).onGuiAction("quick-move-all", nbt);
            } else {
                super.func_184098_a(slot, slotId, button, type);
            }
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
            this.tooltip_.resetTimer();
            HopperContainer container = (HopperContainer)this.func_212873_a_();
            int mx = (int)(mouseX - (double)this.getGuiLeft() + 0.5);
            int my = (int)(mouseY - (double)this.getGuiTop() + 0.5);
            if (!this.func_195359_a(126, 1, 49, 60, mouseX, mouseY)) {
                return super.func_231044_a_(mouseX, mouseY, mouseButton);
            }
            if (this.func_195359_a(128, 9, 44, 10, mouseX, mouseY)) {
                int range = mx - 133;
                if (range < -1) {
                    range = container.field(0) - 1;
                } else if (range >= 34) {
                    range = container.field(0) + 1;
                } else {
                    range = (int)(0.5 + 4.0 * (double)range / 34.0);
                    range = MathHelper.func_76125_a((int)range, (int)0, (int)4);
                }
                container.onGuiAction("range", range);
            } else if (this.func_195359_a(128, 21, 44, 10, mouseX, mouseY)) {
                int period = mx - 133;
                period = period < -1 ? container.field(3) - 3 : (period >= 35 ? container.field(3) + 3 : (int)(0.5 + 100.0 * (double)period / 34.0));
                period = MathHelper.func_76125_a((int)period, (int)0, (int)100);
                container.onGuiAction("period", period);
            } else if (this.func_195359_a(128, 34, 44, 10, mouseX, mouseY)) {
                int ndrop = mx - 134;
                ndrop = ndrop < -1 ? container.field(1) - 1 : (ndrop >= 34 ? container.field(1) + 1 : MathHelper.func_76125_a((int)(1 + ndrop), (int)1, (int)32));
                container.onGuiAction("xsize", ndrop);
            } else if (this.func_195359_a(133, 49, 9, 9, mouseX, mouseY)) {
                container.onGuiAction("manual_trigger", 1);
            } else if (this.func_195359_a(145, 49, 9, 9, mouseX, mouseY)) {
                int mask = 5;
                int logic = container.field(2) & 5;
                switch (logic) {
                    case 0: {
                        logic = 1;
                        break;
                    }
                    case 1: {
                        logic = 4;
                        break;
                    }
                    case 4: {
                        logic = 0;
                        break;
                    }
                    default: {
                        logic = 4;
                    }
                }
                container.onGuiAction("logic", container.field(2) & 0xFFFFFFFA | logic);
            } else if (this.func_195359_a(159, 49, 7, 9, mouseX, mouseY)) {
                container.onGuiAction("logic", container.field(2) ^ 2);
            }
            return true;
        }

        protected void func_230450_a_(MatrixStack mx, float partialTicks, int mouseX, int mouseY) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/factory_hopper_gui.png"));
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            this.func_238474_b_(mx, x0, y0, 0, 0, w, h);
            HopperContainer container = (HopperContainer)this.func_212873_a_();
            int slot_index = container.field(6);
            if (slot_index < 0 || slot_index >= 18) {
                slot_index = 0;
            }
            int x = x0 + 10 + slot_index % 6 * 18;
            int y = y0 + 8 + slot_index / 6 * 17;
            this.func_238474_b_(mx, x, y, 200, 8, 18, 18);
            int[] lut = new int[]{133, 141, 149, 157, 166};
            int px = lut[MathHelper.func_76125_a((int)container.field(0), (int)0, (int)4)];
            int x2 = x0 + px - 2;
            int y2 = y0 + 14;
            this.func_238474_b_(mx, x2, y2, 179, 40, 5, 5);
            int px2 = (int)Math.round(33.5 * (double)container.field(3) / 100.0 + 1.0);
            x = x0 + 132 - 2 + MathHelper.func_76125_a((int)px2, (int)0, (int)34);
            y = y0 + 27;
            this.func_238474_b_(mx, x, y, 179, 40, 5, 5);
            int x3 = x0 + 133 - 2 + container.field(1);
            int y3 = y0 + 40;
            this.func_238474_b_(mx, x3, y3, 179, 40, 5, 5);
            if (container.field(5) != 0) {
                this.func_238474_b_(mx, x0 + 133, y0 + 49, 217, 49, 9, 9);
            }
            int inverter_offset_x = (container.field(2) & 1) != 0 ? 11 : 0;
            int inverter_offset_y = (container.field(2) & 4) != 0 ? 10 : 0;
            this.func_238474_b_(mx, x0 + 145, y0 + 49, 177 + inverter_offset_x, 49 + inverter_offset_y, 9, 9);
            int pulse_mode_offset = (container.field(2) & 2) != 0 ? 9 : 0;
            this.func_238474_b_(mx, x0 + 159, y0 + 49, 199 + pulse_mode_offset, 49, 9, 9);
            if (container.field(4) > 10 && System.currentTimeMillis() % 1000L < 500L) {
                this.func_238474_b_(mx, x0 + 148, y0 + 22, 187, 22, 3, 3);
            }
            RenderSystem.disableBlend();
        }
    }

    public static class HopperContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        protected static final String QUICK_MOVE_ALL = "quick-move-all";
        private static final int PLAYER_INV_START_SLOTNO = 18;
        private static final int NUM_OF_CONTAINER_SLOTS = 54;
        protected static final int STORAGE_SLOT_BEGIN = 0;
        protected static final int STORAGE_SLOT_END = 18;
        protected static final int PLAYER_SLOT_BEGIN = 18;
        protected static final int PLAYER_SLOT_END = 54;
        private final Inventories.InventoryRange player_inventory_range_;
        private final Inventories.InventoryRange block_storage_range_;
        private final PlayerEntity player_;
        private final IInventory inventory_;
        private final IWorldPosCallable wpc_;
        private final IIntArray fields_;

        public final int field(int index) {
            return this.fields_.func_221476_a(index);
        }

        public HopperContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, (IInventory)new Inventory(18), IWorldPosCallable.field_221489_a, (IIntArray)new IntArray(7));
        }

        private HopperContainer(int cid, PlayerInventory player_inventory, IInventory block_inventory, IWorldPosCallable wpc, IIntArray fields) {
            super(ModContent.CT_FACTORY_HOPPER, cid);
            int x;
            int y;
            this.fields_ = fields;
            this.wpc_ = wpc;
            this.player_ = player_inventory.field_70458_d;
            this.inventory_ = block_inventory;
            this.block_storage_range_ = new Inventories.InventoryRange(this.inventory_, 0, 18);
            this.player_inventory_range_ = Inventories.InventoryRange.fromPlayerInventory(this.player_);
            int i = -1;
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 6; ++x) {
                    int xpos = 11 + x * 18;
                    int ypos = 9 + y * 17;
                    this.func_75146_a(new Slot(this.inventory_, ++i, xpos, ypos));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)player_inventory, x2, 8 + x2 * 18, 129));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)player_inventory, x + y * 9 + 9, 8 + x * 18, 71 + y * 18));
                }
            }
            this.func_216961_a(this.fields_);
        }

        public boolean func_75145_c(PlayerEntity player) {
            return this.inventory_.func_70300_a(player);
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 18) {
                if (!this.func_75135_a(slot_stack, 18, 54, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 18 && index <= 54) {
                if (!this.func_75135_a(slot_stack, 0, 18, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundNBT nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundNBT nbt) {
            nbt.func_74778_a("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
            if (!(this.inventory_ instanceof HopperTileEntity)) {
                return;
            }
            HopperTileEntity te = (HopperTileEntity)this.inventory_;
            if (nbt.func_74764_b("xsize")) {
                te.transfer_count_ = MathHelper.func_76125_a((int)nbt.func_74762_e("xsize"), (int)1, (int)32);
            }
            if (nbt.func_74764_b("period")) {
                te.transfer_period_ = MathHelper.func_76125_a((int)nbt.func_74762_e("period"), (int)0, (int)100);
            }
            if (nbt.func_74764_b("range")) {
                te.collection_range_ = MathHelper.func_76125_a((int)nbt.func_74762_e("range"), (int)0, (int)4);
            }
            if (nbt.func_74764_b("logic")) {
                te.logic_ = nbt.func_74762_e("logic");
            }
            if (nbt.func_74764_b("manual_trigger") && nbt.func_74762_e("manual_trigger") != 0) {
                te.block_power_signal_ = true;
                te.block_power_updated_ = true;
                te.tick_timer_ = 1;
            }
            if (nbt.func_74764_b("action")) {
                boolean changed = false;
                int slotId = nbt.func_74764_b("slot") ? nbt.func_74762_e("slot") : -1;
                switch (nbt.func_74779_i("action")) {
                    case "quick-move-all": {
                        if (slotId >= 0 && slotId < 18 && this.func_75139_a(slotId).func_75216_d()) {
                            changed = this.block_storage_range_.move(this.func_75139_a(slotId).getSlotIndex(), this.player_inventory_range_, true, false, true, true);
                            break;
                        }
                        if (slotId < 18 || slotId >= 54 || !this.func_75139_a(slotId).func_75216_d()) break;
                        changed = this.player_inventory_range_.move(this.func_75139_a(slotId).getSlotIndex(), this.block_storage_range_, true, false, false, true);
                    }
                }
                if (changed) {
                    this.inventory_.func_70296_d();
                    player.field_71071_by.func_70296_d();
                    this.func_75142_b();
                }
            }
            te.func_70296_d();
        }
    }

    public static class HopperTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    INameable,
    IInventory,
    INamedContainerProvider,
    ISidedInventory {
        public static final int NUM_OF_FIELDS = 7;
        public static final int TICK_INTERVAL = 10;
        public static final int COLLECTION_INTERVAL = 50;
        public static final int NUM_OF_SLOTS = 18;
        public static final int MAX_TRANSFER_COUNT = 32;
        public static final int MAX_COLLECTION_RANGE = 4;
        public static final int PERIOD_OFFSET = 10;
        public static final int LOGIC_NOT_INVERTED = 0;
        public static final int LOGIC_INVERTED = 1;
        public static final int LOGIC_CONTINUOUS = 2;
        public static final int LOGIC_IGNORE_EXT = 4;
        private boolean block_power_signal_ = false;
        private boolean block_power_updated_ = false;
        private int collection_timer_ = 0;
        private int delay_timer_ = 0;
        private int transfer_count_ = 1;
        private int logic_ = 3;
        private int transfer_period_ = 0;
        private int collection_range_ = 0;
        private int current_slot_index_ = 0;
        private int tick_timer_ = 0;
        protected NonNullList<ItemStack> stacks_;
        protected final IIntArray fields = new IntArray(7){

            public int func_221476_a(int id) {
                switch (id) {
                    case 0: {
                        return collection_range_;
                    }
                    case 1: {
                        return transfer_count_;
                    }
                    case 2: {
                        return logic_;
                    }
                    case 3: {
                        return transfer_period_;
                    }
                    case 4: {
                        return delay_timer_;
                    }
                    case 5: {
                        return block_power_signal_ ? 1 : 0;
                    }
                    case 6: {
                        return current_slot_index_;
                    }
                }
                return 0;
            }

            public void func_221477_a(int id, int value) {
                switch (id) {
                    case 0: {
                        collection_range_ = MathHelper.func_76125_a((int)value, (int)0, (int)4);
                        return;
                    }
                    case 1: {
                        transfer_count_ = MathHelper.func_76125_a((int)value, (int)1, (int)32);
                        return;
                    }
                    case 2: {
                        logic_ = value;
                        return;
                    }
                    case 3: {
                        transfer_period_ = MathHelper.func_76125_a((int)value, (int)0, (int)100);
                        return;
                    }
                    case 4: {
                        delay_timer_ = MathHelper.func_76125_a((int)value, (int)0, (int)400);
                        return;
                    }
                    case 5: {
                        block_power_signal_ = value != 0;
                        return;
                    }
                    case 6: {
                        current_slot_index_ = MathHelper.func_76125_a((int)value, (int)0, (int)17);
                        return;
                    }
                }
            }
        };
        LazyOptional<? extends IItemHandler>[] item_handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP});
        private static final int[] SIDED_INV_SLOTS = new int[18];

        public HopperTileEntity() {
            this(ModContent.TET_FACTORY_HOPPER);
            this.stacks_ = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            this.reset_rtstate();
        }

        public HopperTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.stacks_ = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            this.reset_rtstate();
        }

        public void reset_rtstate() {
            this.block_power_signal_ = false;
            this.block_power_updated_ = false;
        }

        public CompoundNBT clear_getnbt() {
            CompoundNBT nbt = new CompoundNBT();
            this.block_power_signal_ = false;
            this.writenbt(nbt, false);
            boolean is_empty = true;
            for (int i = 0; i < this.stacks_.size(); ++i) {
                is_empty &= ((ItemStack)this.stacks_.get(i)).func_190926_b();
                this.stacks_.set(i, (Object)ItemStack.field_190927_a);
            }
            this.reset_rtstate();
            this.block_power_updated_ = false;
            if (is_empty) {
                nbt = new CompoundNBT();
            }
            return nbt;
        }

        public void readnbt(CompoundNBT nbt, boolean update_packet) {
            this.stacks_ = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.stacks_);
            while (this.stacks_.size() < 18) {
                this.stacks_.add((Object)ItemStack.field_190927_a);
            }
            this.block_power_signal_ = nbt.func_74767_n("powered");
            this.current_slot_index_ = nbt.func_74762_e("act_slot_index");
            this.transfer_count_ = MathHelper.func_76125_a((int)nbt.func_74762_e("xsize"), (int)1, (int)32);
            this.logic_ = nbt.func_74762_e("logic");
            this.transfer_period_ = nbt.func_74762_e("period");
            this.collection_range_ = nbt.func_74762_e("range");
        }

        protected void writenbt(CompoundNBT nbt, boolean update_packet) {
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.stacks_);
            nbt.func_74757_a("powered", this.block_power_signal_);
            nbt.func_74768_a("act_slot_index", this.current_slot_index_);
            nbt.func_74768_a("xsize", this.transfer_count_);
            nbt.func_74768_a("logic", this.logic_);
            nbt.func_74768_a("period", this.transfer_period_);
            nbt.func_74768_a("range", this.collection_range_);
        }

        public void block_updated() {
            boolean powered = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (this.block_power_signal_ != powered) {
                this.block_power_updated_ = true;
            }
            this.block_power_signal_ = powered;
            this.tick_timer_ = 1;
        }

        public boolean is_input_slot(int index) {
            return index >= 0 && index < 18;
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt, false);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            Arrays.stream(this.item_handlers).forEach(LazyOptional::invalidate);
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return new StringTextComponent(block != null ? block.func_149739_a() : "Factory Hopper");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public ITextComponent func_145748_c_() {
            return super.func_145748_c_();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new HopperContainer(id, inventory, this, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.fields);
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.stacks_.size() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stacks_.set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            if (this.tick_timer_ > 8) {
                this.tick_timer_ = 8;
            }
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && this.func_174877_v().func_177951_i((Vector3i)player.func_233580_cy_()) < 64.0;
        }

        public void func_174889_b(PlayerEntity player) {
        }

        public void func_174886_c(PlayerEntity player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return true;
        }

        public void func_174888_l() {
            this.stacks_.clear();
        }

        public int[] func_180463_a(Direction side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack stack, Direction direction) {
            return this.is_input_slot(index) && this.func_94041_b(index, stack);
        }

        public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
            return direction != Direction.UP;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handlers[0].cast();
            }
            return super.getCapability(capability, facing);
        }

        private IItemHandler inventory_entity_handler(BlockPos where) {
            List entities = this.field_145850_b.func_175674_a(null, new AxisAlignedBB(where), EntityPredicates.field_96566_b);
            return entities.isEmpty() ? null : Inventories.itemhandler((Entity)entities.get(0));
        }

        private static int next_slot(int i) {
            return i < 17 ? i + 1 : 0;
        }

        private int try_insert_into_hopper(ItemStack stack) {
            int max_to_insert;
            int n_to_insert = max_to_insert = stack.func_190916_E();
            int first_empty_slot = -1;
            for (int i = 0; i < this.stacks_.size(); ++i) {
                int nspace;
                ItemStack slotstack = (ItemStack)this.stacks_.get(i);
                if (first_empty_slot < 0 && slotstack.func_190926_b()) {
                    first_empty_slot = i;
                    continue;
                }
                if (Inventories.areItemStacksDifferent(stack, slotstack) || (nspace = slotstack.func_77976_d() - slotstack.func_190916_E()) <= 0) continue;
                if (nspace >= n_to_insert) {
                    slotstack.func_190917_f(n_to_insert);
                    n_to_insert = 0;
                    break;
                }
                slotstack.func_190917_f(nspace);
                n_to_insert -= nspace;
            }
            if (n_to_insert > 0 && first_empty_slot >= 0) {
                ItemStack new_stack = stack.func_77946_l();
                new_stack.func_190920_e(n_to_insert);
                this.stacks_.set(first_empty_slot, (Object)new_stack);
                n_to_insert = 0;
            }
            return max_to_insert - n_to_insert;
        }

        private boolean try_insert(Direction facing) {
            int num_inserted;
            ItemStack target_stack;
            int i;
            ItemStack current_stack = ItemStack.field_190927_a;
            for (int i2 = 0; i2 < 18; ++i2) {
                if (this.current_slot_index_ >= 18) {
                    this.current_slot_index_ = 0;
                }
                if (!(current_stack = (ItemStack)this.stacks_.get(this.current_slot_index_)).func_190926_b()) break;
                this.current_slot_index_ = HopperTileEntity.next_slot(this.current_slot_index_);
            }
            if (current_stack.func_190926_b()) {
                this.current_slot_index_ = 0;
                return false;
            }
            BlockPos facing_pos = this.field_174879_c.func_177972_a(facing);
            IItemHandler ih = null;
            TileEntity te = this.field_145850_b.func_175625_s(facing_pos);
            if (te != null) {
                Direction f;
                ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()).orElse(null);
                if (ih == null) {
                    this.delay_timer_ = 12;
                    return false;
                }
                if (te instanceof net.minecraft.tileentity.HopperTileEntity ? (f = (Direction)this.field_145850_b.func_180495_p(facing_pos).func_177229_b((Property)net.minecraft.block.HopperBlock.field_176430_a)) == facing.func_176734_d() : te instanceof HopperTileEntity && (f = (Direction)this.field_145850_b.func_180495_p(facing_pos).func_177229_b((Property)HopperBlock.FACING)) == facing.func_176734_d()) {
                    return false;
                }
            }
            if (ih == null) {
                ih = this.inventory_entity_handler(facing_pos);
            }
            if (ih == null) {
                this.delay_timer_ = 12;
                return false;
            }
            ItemStack insert_stack = current_stack.func_77946_l();
            if (insert_stack.func_190916_E() > this.transfer_count_) {
                insert_stack.func_190920_e(this.transfer_count_);
            }
            int initial_insert_stack_size = insert_stack.func_190916_E();
            if (ih == null || ih.getSlots() <= 0) {
                return false;
            }
            for (i = 0; i < ih.getSlots() && (Inventories.areItemStacksDifferent(target_stack = ih.getStackInSlot(i), insert_stack) || !(insert_stack = ih.insertItem(i, insert_stack.func_77946_l(), false)).func_190926_b()); ++i) {
            }
            if (!insert_stack.func_190926_b()) {
                for (i = 0; i < ih.getSlots() && !(insert_stack = ih.insertItem(i, insert_stack.func_77946_l(), false)).func_190926_b(); ++i) {
                }
            }
            if ((num_inserted = initial_insert_stack_size - insert_stack.func_190916_E()) > 0) {
                current_stack.func_190918_g(num_inserted);
                this.stacks_.set(this.current_slot_index_, (Object)current_stack);
            }
            if (!insert_stack.func_190926_b()) {
                this.current_slot_index_ = HopperTileEntity.next_slot(this.current_slot_index_);
            }
            return num_inserted > 0;
        }

        private boolean try_item_handler_extract(IItemHandler ih) {
            int end = ih.getSlots();
            int n_to_extract = this.transfer_count_;
            for (int i = 0; i < end; ++i) {
                int n_accepted;
                ItemStack stack;
                if (ih.getStackInSlot(i).func_190926_b() || (stack = ih.extractItem(i, n_to_extract, true)).func_190926_b() || (n_accepted = this.try_insert_into_hopper(stack)) <= 0) continue;
                ItemStack test = ih.extractItem(i, n_accepted, false);
                if ((n_to_extract -= n_accepted) <= 0) break;
            }
            return n_to_extract < this.transfer_count_;
        }

        private boolean try_inventory_extract(IInventory inv) {
            int end = inv.func_70302_i_();
            int n_to_extract = this.transfer_count_;
            for (int i = 0; i < end; ++i) {
                int n_accepted;
                ItemStack stack = inv.func_70301_a(i).func_77946_l();
                if (stack.func_190926_b() || (n_accepted = this.try_insert_into_hopper(stack)) <= 0) continue;
                stack.func_190918_g(n_accepted);
                n_to_extract -= n_accepted;
                if (stack.func_190926_b()) {
                    stack = ItemStack.field_190927_a;
                }
                inv.func_70299_a(i, stack);
                if (n_to_extract <= 0) break;
            }
            if (n_to_extract < this.transfer_count_) {
                inv.func_70296_d();
                return true;
            }
            return false;
        }

        private boolean try_collect(Direction facing) {
            AxisAlignedBB collection_volume;
            Vector3d rpos;
            if (facing == Direction.UP) {
                rpos = new Vector3d(0.5 + (double)this.field_174879_c.func_177958_n(), 1.5 + (double)this.field_174879_c.func_177956_o(), 0.5 + (double)this.field_174879_c.func_177952_p());
                collection_volume = new AxisAlignedBB(this.field_174879_c.func_177984_a()).func_72314_b(0.1 + (double)this.collection_range_, 0.6, 0.1 + (double)this.collection_range_);
            } else {
                rpos = new Vector3d(0.5 + (double)this.field_174879_c.func_177958_n(), -1.5 + (double)this.field_174879_c.func_177956_o(), 0.5 + (double)this.field_174879_c.func_177952_p());
                collection_volume = new AxisAlignedBB(this.field_174879_c.func_177979_c(2)).func_72314_b(0.1 + (double)this.collection_range_, 1.0, 0.1 + (double)this.collection_range_);
            }
            List items = this.field_145850_b.func_175647_a(ItemEntity.class, collection_volume, e -> e.func_70089_S() && e.func_233570_aj_());
            if (items.size() <= 0) {
                return false;
            }
            int max_to_collect = 3;
            int n_collected = 0;
            for (ItemEntity ie : items) {
                int n_accepted;
                ItemStack stack;
                boolean is_direct_collection_tange;
                boolean bl = is_direct_collection_tange = ie.func_195048_a(rpos) < 0.7;
                if (!is_direct_collection_tange && ie.func_174874_s() || (stack = ie.func_92059_d()).func_190926_b() || (n_accepted = this.try_insert_into_hopper(stack)) <= 0) continue;
                if (n_accepted >= stack.func_190916_E()) {
                    stack.func_190920_e(0);
                    ie.func_92058_a(stack);
                    ie.func_70106_y();
                } else {
                    stack.func_190918_g(n_accepted);
                    ie.func_92058_a(stack);
                }
                if (is_direct_collection_tange || ++n_collected < 3) continue;
                break;
            }
            return n_collected > 0;
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (this.delay_timer_ > 0 && --this.delay_timer_ == 0) {
                this.func_70296_d();
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 10;
            boolean dirty = this.block_power_updated_;
            boolean rssignal = (this.logic_ & 4) != 0 || (this.logic_ & 1) != 0 == !this.block_power_signal_;
            boolean pulse_mode = (this.logic_ & 6) == 0;
            boolean trigger = (this.logic_ & 4) != 0 || rssignal && (this.block_power_updated_ || !pulse_mode);
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof HopperBlock)) {
                this.block_power_signal_ = false;
                return;
            }
            Direction hopper_facing = (Direction)state.func_177229_b((Property)HopperBlock.FACING);
            boolean tr = this.field_145850_b.func_175640_z(this.field_174879_c);
            this.block_power_updated_ = this.block_power_signal_ != tr;
            this.block_power_signal_ = tr;
            if (this.block_power_updated_) {
                dirty = true;
            }
            if (rssignal || pulse_mode) {
                IItemHandler ih;
                Direction hopper_input_facing = hopper_facing == Direction.UP ? Direction.DOWN : Direction.UP;
                TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(hopper_input_facing));
                IItemHandler iItemHandler = ih = te == null ? null : (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, hopper_input_facing.func_176734_d()).orElse(null);
                if (ih != null || te instanceof ISidedInventory) {
                    if (ih != null) {
                        if (this.try_item_handler_extract(ih)) {
                            dirty = true;
                        }
                    } else if (this.try_inventory_extract((IInventory)te)) {
                        dirty = true;
                    }
                }
                if (ih == null && (ih = this.inventory_entity_handler(this.field_174879_c.func_177972_a(hopper_input_facing))) != null && this.try_item_handler_extract(ih)) {
                    dirty = true;
                }
                if (ih == null && (this.collection_timer_ -= 10) <= 0) {
                    this.collection_timer_ = 50;
                    if (this.try_collect(hopper_input_facing)) {
                        dirty = true;
                    }
                }
            }
            if (trigger && this.delay_timer_ <= 0) {
                this.delay_timer_ = 10 + this.transfer_period_ * 2;
                if (this.try_insert(hopper_facing)) {
                    dirty = true;
                }
            }
            if (dirty) {
                this.func_70296_d();
            }
            if (trigger && this.tick_timer_ > 10) {
                this.tick_timer_ = 10;
            }
        }

        static {
            for (int i = 0; i < 18; ++i) {
                HopperTileEntity.SIDED_INV_SLOTS[i] = i;
            }
        }
    }

    public static class HopperBlock
    extends DecorBlock.Directed
    implements IDecorBlock {
        public HopperBlock(long config, AbstractBlock.Properties builder, Supplier<ArrayList<VoxelShape>> shape_supplier) {
            super(config, builder, shape_supplier);
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
            return VoxelShapes.func_197868_b();
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new HopperTileEntity();
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.field_72995_K) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
                return;
            }
            CompoundNBT te_nbt = stack.func_77978_p().func_74775_l("tedata");
            if (te_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof HopperTileEntity)) {
                return;
            }
            ((HopperTileEntity)te).readnbt(te_nbt, false);
            ((HopperTileEntity)te).reset_rtstate();
            ((HopperTileEntity)te).func_70296_d();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof HopperTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                CompoundNBT te_nbt = ((HopperTileEntity)te).clear_getnbt();
                if (!te_nbt.isEmpty()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_218657_a("tedata", (INBT)te_nbt);
                    stack.func_77982_d(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((HopperTileEntity)te).stacks_) {
                    if (stack.func_190926_b()) continue;
                    stacks.add(stack);
                }
                ((HopperTileEntity)te).reset_rtstate();
            }
            return stacks;
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof HopperTileEntity)) {
                return ActionResultType.FAIL;
            }
            if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
            return ActionResultType.CONSUME;
        }

        public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            if (!(world instanceof World) || world.field_72995_K) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof HopperTileEntity)) {
                return;
            }
            ((HopperTileEntity)te).block_updated();
        }

        public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
            super.func_180658_a(world, pos, entity, fallDistance);
            if (!(entity instanceof ItemEntity)) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof HopperTileEntity)) {
                return;
            }
            ((HopperTileEntity)te).collection_timer_ = 0;
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        public boolean func_149744_f(BlockState state) {
            return true;
        }

        public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return 0;
        }
    }
}

