/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.client.ContainerGui;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;

public class EdLabeledCrate {
    private static boolean with_gui_mouse_handling = true;
    private static final HashSet<Item> unstorable_containers = new HashSet();

    public static void on_config(boolean without_gui_mouse_handling) {
        with_gui_mouse_handling = !without_gui_mouse_handling;
        unstorable_containers.clear();
        unstorable_containers.add(ModContent.LABELED_CRATE.func_199767_j());
        unstorable_containers.add(Items.field_221970_gq);
        ModConfig.log("Config crate: unstorable:" + unstorable_containers.stream().map(e -> e.getRegistryName().toString()).collect(Collectors.joining(",")));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LabeledCrateGui
    extends ContainerGui<LabeledCrateContainer> {
        protected final PlayerEntity player_;

        public LabeledCrateGui(LabeledCrateContainer container, PlayerInventory player_inventory, ITextComponent title) {
            super(container, player_inventory, title);
            this.player_ = player_inventory.field_70458_d;
            this.field_146999_f = 213;
            this.field_147000_g = 206;
            this.field_238742_p_ = 23;
            this.field_238743_q_ = -10;
        }

        public void func_231160_c_() {
            super.func_231160_c_();
        }

        public void func_230430_a_(MatrixStack mx, int mouseX, int mouseY, float partialTicks) {
            this.func_230446_a_(mx);
            super.func_230430_a_(mx, mouseX, mouseY, partialTicks);
            this.func_230459_a_(mx, mouseX, mouseY);
        }

        protected void func_230451_b_(MatrixStack mx, int x, int y) {
            this.field_230712_o_.func_243248_b(mx, this.field_230704_d_, (float)this.field_238742_p_ + 1.0f, (float)this.field_238743_q_ + 1.0f, 0x303030);
            this.field_230712_o_.func_243248_b(mx, this.field_230704_d_, (float)this.field_238742_p_, (float)this.field_238743_q_, 0x707070);
        }

        protected void func_230450_a_(MatrixStack mx, float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/labeled_crate_gui.png"));
            int x0 = this.field_147003_i;
            int y0 = this.field_147009_r;
            int w = this.field_146999_f;
            int h = this.field_147000_g;
            this.func_238474_b_(mx, x0, y0, 0, 0, w, h);
        }

        protected void action(String message) {
            this.action(message, new CompoundNBT());
        }

        protected void action(String message, CompoundNBT nbt) {
            ((LabeledCrateContainer)this.func_212873_a_()).onGuiAction(message, nbt);
        }

        protected void func_184098_a(Slot slot, int slotId, int button, ClickType type) {
            if (!with_gui_mouse_handling) {
                super.func_184098_a(slot, slotId, button, type);
            } else if (type == ClickType.QUICK_MOVE && slot != null && slot.func_75216_d() && Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown()) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("slot", slotId);
                this.action("quick-move-all", nbt);
            } else {
                super.func_184098_a(slot, slotId, button, type);
            }
        }

        public boolean func_231043_a_(double mouseX, double mouseY, double wheel_inc) {
            if (!with_gui_mouse_handling) {
                return super.func_231043_a_(mouseX, mouseY, wheel_inc);
            }
            Slot slot = this.getSlotUnderMouse();
            if (slot == null || !slot.func_75216_d()) {
                return true;
            }
            int count = slot.func_75211_c().func_190916_E();
            int limit = (Auxiliaries.isShiftDown() ? 2 : 1) * (Auxiliaries.isCtrlDown() ? 4 : 1);
            if (wheel_inc > 0.1) {
                if (count > 0 && count < slot.func_75211_c().func_77976_d() && count < slot.func_75219_a()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74768_a("slot", slot.field_75222_d);
                    if (limit > 1) {
                        nbt.func_74768_a("limit", limit);
                    }
                    this.action("increase-stack", nbt);
                }
            } else if (wheel_inc < -0.1 && count > 0) {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_74768_a("slot", slot.field_75222_d);
                if (limit > 1) {
                    nbt.func_74768_a("limit", limit);
                }
                this.action("decrease-stack", nbt);
            }
            return true;
        }
    }

    public static class LabeledCrateContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        protected static final String QUICK_MOVE_ALL = "quick-move-all";
        protected static final String INCREASE_STACK = "increase-stack";
        protected static final String DECREASE_STACK = "decrease-stack";
        private static final int PLAYER_INV_START_SLOTNO = 55;
        private static final int NUM_OF_CONTAINER_SLOTS = 91;
        protected static final int STORAGE_SLOT_BEGIN = 0;
        protected static final int STORAGE_SLOT_END = 54;
        protected static final int PLAYER_SLOT_BEGIN = 55;
        protected static final int PLAYER_SLOT_END = 91;
        protected final PlayerEntity player_;
        protected final IInventory inventory_;
        protected final IWorldPosCallable wpc_;
        private final IIntArray fields_;
        private final Inventories.InventoryRange player_inventory_range_;
        private final Inventories.InventoryRange block_storage_range_;
        private final Inventories.InventoryRange frame_slot_range_;

        public int field(int index) {
            return this.fields_.func_221476_a(index);
        }

        public PlayerEntity player() {
            return this.player_;
        }

        public IInventory inventory() {
            return this.inventory_;
        }

        public World world() {
            return this.player_.field_70170_p;
        }

        public LabeledCrateContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, (IInventory)new Inventory(55), IWorldPosCallable.field_221489_a, (IIntArray)new IntArray(1));
        }

        private LabeledCrateContainer(int cid, PlayerInventory player_inventory, IInventory block_inventory, IWorldPosCallable wpc, IIntArray fields) {
            super(ModContent.CT_LABELED_CRATE, cid);
            int x;
            int y;
            this.player_ = player_inventory.field_70458_d;
            this.inventory_ = block_inventory;
            this.wpc_ = wpc;
            this.wpc_.func_221486_a((w, p) -> this.inventory_.func_174889_b(this.player_));
            this.fields_ = fields;
            this.block_storage_range_ = new Inventories.InventoryRange(this.inventory_, 0, 54);
            this.player_inventory_range_ = new Inventories.InventoryRange((IInventory)player_inventory, 0, 36);
            this.frame_slot_range_ = new Inventories.InventoryRange(this.inventory_, 54, 1);
            int i = -1;
            for (y = 0; y < 6; ++y) {
                for (x = 0; x < 9; ++x) {
                    int xpos = 28 + x * 18;
                    int ypos = 10 + y * 18;
                    this.func_75146_a(new StorageSlot(this.inventory_, ++i, xpos, ypos));
                }
            }
            this.func_75146_a(new Slot(this.frame_slot_range_, 0, 191, 100){

                public int func_75219_a() {
                    return 1;
                }
            });
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)player_inventory, x2, 28 + x2 * 18, 183));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)player_inventory, x + y * 9 + 9, 28 + x * 18, 125 + y * 18));
                }
            }
        }

        public boolean func_75145_c(PlayerEntity player) {
            return this.inventory_.func_70300_a(player);
        }

        public boolean func_94530_a(ItemStack stack, Slot slot) {
            return slot.func_75219_a() > 1;
        }

        public void func_75134_a(PlayerEntity player) {
            super.func_75134_a(player);
            this.inventory_.func_174886_c(player);
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 55) {
                if (!this.func_75135_a(slot_stack, 55, 91, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 55 && index <= 91) {
                if (!this.func_75135_a(slot_stack, 0, 54, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundNBT nbt) {
            nbt.func_74778_a("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
            if (!nbt.func_74764_b("action")) {
                return;
            }
            boolean changed = false;
            int slotId = nbt.func_74764_b("slot") ? nbt.func_74762_e("slot") : -1;
            switch (nbt.func_74779_i("action")) {
                case "quick-move-all": {
                    if (slotId >= 0 && slotId < 54 && this.func_75139_a(slotId).func_75216_d()) {
                        changed = this.block_storage_range_.move(this.func_75139_a(slotId).getSlotIndex(), this.player_inventory_range_, true, false, true, true);
                        break;
                    }
                    if (slotId < 55 || slotId >= 91 || !this.func_75139_a(slotId).func_75216_d()) break;
                    changed = this.player_inventory_range_.move(this.func_75139_a(slotId).getSlotIndex(), this.block_storage_range_, true, false, false, true);
                    break;
                }
                case "increase-stack": {
                    break;
                }
            }
            if (changed) {
                this.inventory_.func_70296_d();
                player.field_71071_by.func_70296_d();
                this.func_75142_b();
            }
        }

        protected static class StorageSlot
        extends Slot {
            StorageSlot(IInventory inventory, int index, int x, int y) {
                super(inventory, index, x, y);
            }

            public int func_75219_a() {
                return 64;
            }

            public boolean func_75214_a(ItemStack stack) {
                return !LabeledCrateTileEntity.inacceptable(stack);
            }
        }
    }

    public static class LabeledCrateTileEntity
    extends TileEntity
    implements INameable,
    INamedContainerProvider,
    Networking.IPacketTileNotifyReceiver {
        public static final int NUM_OF_FIELDS = 1;
        public static final int NUM_OF_SLOTS = 55;
        public static final int NUM_OF_STORAGE_SLOTS = 54;
        public static final int NUM_OF_STORAGE_ROWS = 6;
        public static final int ITEMFRAME_SLOTNO = 54;
        protected final Inventories.StorageInventory main_inventory_;
        protected LazyOptional<IItemHandler> item_handler_;
        protected final Inventories.InventoryRange storage_range_;
        @Nullable
        private ITextComponent custom_name_;
        protected final IIntArray fields = new IntArray(1){

            public int func_221476_a(int id) {
                switch (id) {
                    default: 
                }
                return 0;
            }

            public void func_221477_a(int id, int value) {
                switch (id) {
                    default: 
                }
            }
        };

        public LabeledCrateTileEntity() {
            this(ModContent.TET_LABELED_CRATE);
        }

        public LabeledCrateTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.main_inventory_ = new Inventories.StorageInventory(this, 55, 1);
            this.storage_range_ = new Inventories.InventoryRange(this.main_inventory_, 0, 54, 6);
            this.item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.storage_range_, (slot, stack) -> slot != 54, (slot, stack) -> slot != 54, IntStream.range(0, 54).boxed().collect(Collectors.toList()));
            this.main_inventory_.setCloseAction(player -> Networking.PacketTileNotifyServerToClient.sendToPlayers(this, this.writenbt(new CompoundNBT())));
            this.main_inventory_.setSlotChangeAction((index, stack) -> {
                if (index == 54) {
                    Networking.PacketTileNotifyServerToClient.sendToPlayers(this, this.writenbt(new CompoundNBT()));
                }
            });
        }

        public CompoundNBT reset_getnbt() {
            CompoundNBT nbt = new CompoundNBT();
            this.writenbt(nbt);
            this.reset();
            return nbt;
        }

        protected void reset() {
            this.main_inventory_.func_174888_l();
        }

        public CompoundNBT readnbt(CompoundNBT nbt) {
            if (nbt.func_150297_b("name", 8)) {
                this.custom_name_ = Auxiliaries.unserializeTextComponent(nbt.func_74779_i("name"));
            }
            this.main_inventory_.load(nbt);
            return nbt;
        }

        protected CompoundNBT writenbt(CompoundNBT nbt) {
            if (this.custom_name_ != null) {
                nbt.func_74778_a("name", Auxiliaries.serializeTextComponent(this.custom_name_));
            }
            if (!this.main_inventory_.func_191420_l()) {
                this.main_inventory_.save(nbt);
            }
            return nbt;
        }

        public ItemStack getItemFrameStack() {
            return this.main_inventory_.func_70301_a(54);
        }

        protected static boolean inacceptable(ItemStack stack) {
            return stack.func_77942_o() && !stack.func_77978_p().isEmpty() && unstorable_containers.contains(stack.func_77973_b());
        }

        @Override
        public void onServerPacketReceived(CompoundNBT nbt) {
            this.readnbt(nbt);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.item_handler_.invalidate();
        }

        public CompoundNBT func_189517_E_() {
            CompoundNBT nbt = super.func_189517_E_();
            this.writenbt(nbt);
            return nbt;
        }

        @Nullable
        public SUpdateTileEntityPacket func_189518_D_() {
            return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
        }

        public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
            this.readnbt(pkt.func_148857_g());
            super.onDataPacket(net, pkt);
        }

        public void handleUpdateTag(BlockState state, CompoundNBT tag) {
            this.func_230337_a_(state, tag);
        }

        @OnlyIn(value=Dist.CLIENT)
        public double func_145833_n() {
            return 1600.0;
        }

        public ITextComponent func_200200_C_() {
            if (this.custom_name_ != null) {
                return this.custom_name_;
            }
            Block block = this.func_195044_w().func_177230_c();
            if (block != null) {
                return new TranslationTextComponent(block.func_149739_a());
            }
            return new StringTextComponent("Labeled Crate");
        }

        @Nullable
        public ITextComponent func_200201_e() {
            return this.custom_name_;
        }

        public boolean func_145818_k_() {
            return this.custom_name_ != null;
        }

        public void setCustomName(ITextComponent name) {
            this.custom_name_ = name;
        }

        public ITextComponent func_145748_c_() {
            return super.func_145748_c_();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new LabeledCrateContainer(id, inventory, this.main_inventory_, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.fields);
        }
    }

    public static class LabeledCrateBlock
    extends StandardBlocks.Horizontal
    implements IDecorBlock {
        public LabeledCrateBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new LabeledCrateTileEntity();
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            CompoundNBT te_nbt;
            if (world.field_72995_K || !stack.func_77942_o()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof LabeledCrateTileEntity)) {
                return;
            }
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("tedata") && !(te_nbt = nbt.func_74775_l("tedata")).isEmpty()) {
                ((LabeledCrateTileEntity)te).readnbt(te_nbt);
            }
            ((LabeledCrateTileEntity)te).setCustomName(Auxiliaries.getItemLabel(stack));
            ((LabeledCrateTileEntity)te).func_70296_d();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof LabeledCrateTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                CompoundNBT te_nbt = ((LabeledCrateTileEntity)te).reset_getnbt();
                CompoundNBT nbt = new CompoundNBT();
                if (!te_nbt.isEmpty()) {
                    nbt.func_218657_a("tedata", (INBT)te_nbt);
                }
                if (!nbt.isEmpty()) {
                    stack.func_77982_d(nbt);
                }
                Auxiliaries.setItemLabel(stack, ((LabeledCrateTileEntity)te).func_200201_e());
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((LabeledCrateTileEntity)te).main_inventory_) {
                    stacks.add(stack);
                }
                ((LabeledCrateTileEntity)te).reset_getnbt();
            }
            return stacks;
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof LabeledCrateTileEntity)) {
                return ActionResultType.FAIL;
            }
            if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
            return ActionResultType.CONSUME;
        }

        @Override
        public PushReaction func_149656_h(BlockState state) {
            return PushReaction.BLOCK;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
            String[] lines;
            CompoundNBT nbt;
            if (!Auxiliaries.Tooltip.extendedTipCondition() || Auxiliaries.Tooltip.helpCondition()) {
                super.func_190948_a(stack, world, tooltip, flag);
                return;
            }
            ItemStack frameStack = ItemStack.field_190927_a;
            int num_used_slots = 0;
            int total_items = 0;
            String stats = "";
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tedata") && (nbt = stack.func_77978_p().func_74775_l("tedata")).func_74764_b("Items")) {
                NonNullList all_items = NonNullList.func_191197_a((int)55, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)nbt, (NonNullList)all_items);
                frameStack = (ItemStack)all_items.get(54);
                all_items.set(54, (Object)ItemStack.field_190927_a);
                HashMap<Item, Integer> item_map = new HashMap<Item, Integer>();
                for (Object e2 : all_items) {
                    if (e2.func_190926_b()) continue;
                    item_map.put(e2.func_77973_b(), item_map.getOrDefault(e2.func_77973_b(), 0) + e2.func_190916_E());
                    ++num_used_slots;
                    total_items += e2.func_190916_E();
                }
                ArrayList<Tuple> itmes = new ArrayList<Tuple>();
                for (Map.Entry entry : item_map.entrySet()) {
                    itmes.add(new Tuple((Object)((Item)entry.getKey()).func_77658_a(), entry.getValue()));
                }
                itmes.sort((a, b) -> (Integer)b.func_76340_b() - (Integer)a.func_76340_b());
                boolean dotdotdot = false;
                if (itmes.size() > 8) {
                    itmes.subList(8, itmes.size()).clear();
                    dotdotdot = true;
                }
                stats = itmes.stream().map(e -> Auxiliaries.localize((String)e.func_76341_a(), new Object[0])).collect(Collectors.joining(", "));
                if (dotdotdot) {
                    stats = stats + "...";
                }
            }
            int num_free_slots = 54 - num_used_slots;
            for (String string : lines = Auxiliaries.localize(this.func_149739_a() + ".tip", frameStack.func_190926_b() ? new StringTextComponent("-/-") : new TranslationTextComponent(frameStack.func_77977_a()), num_used_slots, num_free_slots, total_items, stats).split("\n")) {
                tooltip.add((ITextComponent)new StringTextComponent(string.trim()));
            }
        }
    }
}

