/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;

public class EdMineralSmelter {
    public static void on_config(int consumption, int heatup_per_second) {
        MineralSmelterTileEntity.on_config(consumption, heatup_per_second);
    }

    public static class MineralSmelterTileEntity
    extends TileEntity
    implements INameable,
    ITickableTileEntity,
    ISidedInventory,
    IEnergyStorage,
    ICapabilityProvider {
        public static final int TICK_INTERVAL = 20;
        public static final int MAX_FLUID_LEVEL = 1000;
        public static final int MAX_BUCKET_EXTRACT_FLUID_LEVEL = 900;
        public static final int MAX_ENERGY_BUFFER = 32000;
        public static final int MAX_ENERGY_TRANSFER = 8192;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 92;
        public static final int DEFAULT_HEATUP_RATE = 2;
        public static final int PHASE_WARMUP = 0;
        public static final int PHASE_HOT = 1;
        public static final int PHASE_MAGMABLOCK = 2;
        public static final int PHASE_LAVA = 3;
        private static final ItemStack MAGMA_STACK = new ItemStack((IItemProvider)Blocks.field_196814_hQ);
        private static final ItemStack BUCKET_STACK = new ItemStack((IItemProvider)Items.field_151133_ar);
        private static final ItemStack LAVA_BUCKET_STACK = new ItemStack((IItemProvider)Items.field_151129_at);
        private static final FluidStack LAVA_BUCKET_FLUID_STACK = new FluidStack((Fluid)Fluids.field_204547_b, 1000);
        private static Set<Item> accepted_minerals = new HashSet<Item>();
        private static Set<Item> accepted_lava_contrainers = new HashSet<Item>();
        private static int energy_consumption = 92;
        private static int heatup_rate = 2;
        private static int cooldown_rate = 1;
        private int tick_timer_;
        private int energy_stored_;
        private int progress_;
        private int fluid_level_;
        private boolean force_block_update_;
        private NonNullList<ItemStack> stacks_ = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        private static final int[] SIDED_INV_SLOTS;
        private LazyOptional<IItemHandler> item_handler_ = LazyOptional.of(() -> new BItemHandler(this));
        private LazyOptional<IFluidHandler> fluid_handler_ = LazyOptional.of(() -> new BFluidHandler(this));
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int consumption, int heatup_per_second) {
            energy_consumption = MathHelper.func_76125_a((int)consumption, (int)8, (int)4096);
            heatup_rate = MathHelper.func_76125_a((int)heatup_per_second, (int)1, (int)5);
            cooldown_rate = MathHelper.func_76125_a((int)(heatup_per_second / 2), (int)1, (int)5);
            ModConfig.log("Config mineal smelter: energy consumption:" + energy_consumption + "rf/t, heat-up rate: " + heatup_rate + "%/s.");
        }

        public MineralSmelterTileEntity() {
            this(ModContent.TET_MINERAL_SMELTER);
        }

        public MineralSmelterTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        public int progress() {
            return this.progress_;
        }

        public int phase() {
            if (this.progress_ >= 100) {
                return 3;
            }
            if (this.progress_ >= 90) {
                return 2;
            }
            if (this.progress_ >= 5) {
                return 1;
            }
            return 0;
        }

        public int fluid_level() {
            return this.fluid_level_;
        }

        public int comparator_signal() {
            return this.phase() * 5;
        }

        private boolean accepts_lava_container(ItemStack stack) {
            return accepted_lava_contrainers.contains(stack.func_77973_b());
        }

        private boolean accepts_input(ItemStack stack) {
            if (!((ItemStack)this.stacks_.get(0)).func_190926_b()) {
                return false;
            }
            if (this.fluid_level() > 900) {
                return this.accepts_lava_container(stack);
            }
            if (stack.func_77973_b().getTags().contains(new ResourceLocation("engineersdecor", "accepted_mineral_smelter_input"))) {
                return true;
            }
            return accepted_minerals.contains(stack.func_77973_b());
        }

        public boolean insert(ItemStack stack, boolean simulate) {
            if (stack.func_190926_b() || !this.accepts_input(stack)) {
                return false;
            }
            if (!simulate) {
                ItemStack st = stack.func_77946_l();
                st.func_190920_e(st.func_77976_d());
                this.stacks_.set(0, (Object)st);
                if (!this.accepts_lava_container(stack)) {
                    this.progress_ = 0;
                }
                this.force_block_update_ = true;
            }
            return true;
        }

        public ItemStack extract(boolean simulate) {
            ItemStack stack = ((ItemStack)this.stacks_.get(1)).func_77946_l();
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                this.reset_process();
            }
            return stack;
        }

        protected void reset_process() {
            this.stacks_ = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
            this.force_block_update_ = true;
            this.fluid_level_ = 0;
            this.tick_timer_ = 0;
            this.progress_ = 0;
        }

        public void readnbt(CompoundNBT nbt) {
            this.energy_stored_ = nbt.func_74762_e("energy");
            this.progress_ = nbt.func_74762_e("progress");
            this.fluid_level_ = nbt.func_74762_e("fluidlevel");
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.stacks_);
            if (this.stacks_.size() != 2) {
                this.reset_process();
            }
        }

        protected void writenbt(CompoundNBT nbt) {
            nbt.func_74768_a("energy", MathHelper.func_76125_a((int)this.energy_stored_, (int)0, (int)32000));
            nbt.func_74768_a("progress", MathHelper.func_76125_a((int)this.progress_, (int)0, (int)100));
            nbt.func_74768_a("fluidlevel", MathHelper.func_76125_a((int)this.fluid_level_, (int)0, (int)1000));
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.stacks_);
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.energy_handler_.invalidate();
            this.fluid_handler_.invalidate();
            this.item_handler_.invalidate();
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return new StringTextComponent(block != null ? block.func_149739_a() : "Lab furnace");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index >= 0 && index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.stacks_.set(index, (Object)stack);
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 1;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && this.func_174877_v().func_177951_i((Vector3i)player.func_233580_cy_()) < 64.0;
        }

        public void func_174889_b(PlayerEntity player) {
        }

        public void func_174886_c(PlayerEntity player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index == 0 && this.accepts_input(stack) || index == 1;
        }

        public void func_174888_l() {
            this.reset_process();
        }

        public int[] func_180463_a(Direction side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack stack, Direction direction) {
            return index == 0 && this.func_94041_b(index, stack);
        }

        public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
            return index == 1 && !((ItemStack)this.stacks_.get(1)).func_190926_b();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return 32000;
        }

        public int getEnergyStored() {
            return this.energy_stored_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.energy_stored_ >= 32000) {
                return 0;
            }
            int n = Math.min(maxReceive, 32000 - this.energy_stored_);
            if (n > 8192) {
                n = 8192;
            }
            if (!simulate) {
                this.energy_stored_ += n;
                this.func_70296_d();
            }
            return n;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.fluid_handler_.cast();
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            int n;
            IFluidHandler fh;
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 20;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof MineralSmelterBlock)) {
                return;
            }
            boolean dirty = false;
            int last_phase = this.phase();
            ItemStack istack = (ItemStack)this.stacks_.get(0);
            if (istack.func_190926_b() && this.fluid_level() == 0) {
                this.progress_ = 0;
            } else if (this.energy_stored_ <= 0 || this.field_145850_b.func_175640_z(this.field_174879_c)) {
                this.progress_ = MathHelper.func_76125_a((int)(this.progress_ - cooldown_rate), (int)0, (int)100);
            } else if (this.progress_ >= 100) {
                this.progress_ = 100;
                this.energy_stored_ = MathHelper.func_76125_a((int)(this.energy_stored_ - energy_consumption * 20 / 20), (int)0, (int)32000);
            } else {
                this.energy_stored_ = MathHelper.func_76125_a((int)(this.energy_stored_ - energy_consumption * 20), (int)0, (int)32000);
                this.progress_ = MathHelper.func_76125_a((int)(this.progress_ + heatup_rate), (int)0, (int)100);
            }
            int new_phase = this.phase();
            boolean is_lava_container = this.accepts_lava_container(istack);
            if (is_lava_container || new_phase != last_phase) {
                if (is_lava_container) {
                    if (istack.func_77969_a(BUCKET_STACK)) {
                        if (!((ItemStack)this.stacks_.get(1)).func_77969_a(LAVA_BUCKET_STACK)) {
                            if (this.fluid_level() >= 900) {
                                this.stacks_.set(1, (Object)LAVA_BUCKET_STACK);
                                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 0.2f, 1.3f);
                            } else {
                                this.stacks_.set(1, (Object)istack.func_77946_l());
                            }
                            dirty = true;
                        }
                    } else {
                        this.stacks_.set(1, (Object)istack.func_77946_l());
                    }
                } else if (new_phase > last_phase) {
                    switch (new_phase) {
                        case 3: {
                            this.fluid_level_ = 1000;
                            this.stacks_.set(1, (Object)ItemStack.field_190927_a);
                            this.stacks_.set(0, (Object)ItemStack.field_190927_a);
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f, 1.0f);
                            dirty = true;
                            break;
                        }
                        case 2: {
                            this.stacks_.set(1, (Object)MAGMA_STACK.func_77946_l());
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.2f, 0.8f);
                            dirty = true;
                            break;
                        }
                        case 1: {
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 0.2f, 0.8f);
                        }
                    }
                } else {
                    switch (new_phase) {
                        case 2: {
                            this.stacks_.set(0, (Object)(this.fluid_level_ >= 900 ? MAGMA_STACK.func_77946_l() : ItemStack.field_190927_a));
                            this.stacks_.set(1, (Object)((ItemStack)this.stacks_.get(0)).func_77946_l());
                            this.fluid_level_ = 0;
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 1.1f);
                            dirty = true;
                            break;
                        }
                        case 1: {
                            if (istack.func_77969_a(MAGMA_STACK)) {
                                this.stacks_.set(1, (Object)new ItemStack((IItemProvider)Blocks.field_150343_Z));
                            } else {
                                this.stacks_.set(1, (Object)new ItemStack((IItemProvider)Blocks.field_150347_e));
                            }
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 0.9f);
                            dirty = true;
                            break;
                        }
                        case 0: {
                            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 0.7f);
                        }
                    }
                }
            } else if (this.phase() == 3 && this.fluid_level() >= 900 && (fh = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.func_174877_v().func_177977_b(), (Direction)Direction.UP).orElse(null)) != null && (n = fh.fill(LAVA_BUCKET_FLUID_STACK.copy(), IFluidHandler.FluidAction.SIMULATE)) >= LAVA_BUCKET_FLUID_STACK.getAmount() / 2 && (n = fh.fill(LAVA_BUCKET_FLUID_STACK.copy(), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                this.reset_process();
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 0.7f);
            }
            if (this.force_block_update_ || (Integer)state.func_177229_b((Property)MineralSmelterBlock.PHASE) != new_phase) {
                state = (BlockState)state.func_206870_a((Property)MineralSmelterBlock.PHASE, (Comparable)Integer.valueOf(new_phase));
                this.field_145850_b.func_180501_a(this.field_174879_c, state, 19);
                this.field_145850_b.func_195593_d(this.func_174877_v(), state.func_177230_c());
                this.force_block_update_ = false;
            }
            if (dirty) {
                this.func_70296_d();
            }
        }

        static {
            accepted_lava_contrainers.add(Items.field_151133_ar);
            SIDED_INV_SLOTS = new int[]{0, 1};
        }

        private static class BFluidHandler
        implements IFluidHandler {
            private final FluidStack lava;
            private final MineralSmelterTileEntity te;

            BFluidHandler(MineralSmelterTileEntity te) {
                this.te = te;
                this.lava = new FluidStack((Fluid)Fluids.field_204547_b, 1);
            }

            public int getTanks() {
                return 1;
            }

            public FluidStack getFluidInTank(int tank) {
                return new FluidStack(this.lava, this.te.fluid_level());
            }

            public int getTankCapacity(int tank) {
                return 1000;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return tank == 0 && stack.isFluidEqual(this.lava);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return resource.isFluidEqual(this.lava) ? this.drain(resource.getAmount(), action) : FluidStack.EMPTY;
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                maxDrain = Math.min(maxDrain, this.te.fluid_level());
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    MineralSmelterTileEntity mineralSmelterTileEntity = this.te;
                    mineralSmelterTileEntity.fluid_level_ = mineralSmelterTileEntity.fluid_level_ - maxDrain;
                }
                return maxDrain > 0 ? new FluidStack(this.lava, maxDrain) : FluidStack.EMPTY;
            }
        }

        protected static class BItemHandler
        implements IItemHandler {
            private MineralSmelterTileEntity te;

            BItemHandler(MineralSmelterTileEntity te) {
                this.te = te;
            }

            public int getSlots() {
                return 2;
            }

            public int getSlotLimit(int index) {
                return this.te.func_70297_j_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return this.te.func_94041_b(slot, stack);
            }

            @Nonnull
            public ItemStack insertItem(int index, @Nonnull ItemStack stack, boolean simulate) {
                ItemStack rstack = stack.func_77946_l();
                if (index != 0 || !this.te.insert(stack.func_77946_l(), simulate)) {
                    return rstack;
                }
                rstack.func_190918_g(1);
                return rstack;
            }

            @Nonnull
            public ItemStack extractItem(int index, int amount, boolean simulate) {
                return index != 1 ? ItemStack.field_190927_a : this.te.extract(simulate);
            }

            @Nonnull
            public ItemStack getStackInSlot(int index) {
                return this.te.func_70301_a(index);
            }
        }
    }

    public static class MineralSmelterBlock
    extends DecorBlock.Horizontal
    implements IDecorBlock {
        public static final int PHASE_MAX = 3;
        public static final IntegerProperty PHASE = IntegerProperty.func_177719_a((String)"phase", (int)0, (int)3);

        public MineralSmelterBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{PHASE});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)super.func_196258_a(context).func_206870_a((Property)PHASE, (Comparable)Integer.valueOf(0));
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState state, World world, BlockPos pos) {
            return MathHelper.func_76125_a((int)((Integer)state.func_177229_b((Property)PHASE) * 5), (int)0, (int)15);
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new MineralSmelterTileEntity();
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof MineralSmelterTileEntity)) {
                return stacks;
            }
            ((MineralSmelterTileEntity)te).reset_process();
            stacks.add(new ItemStack((IItemProvider)this, 1));
            return stacks;
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (player.func_225608_bj_()) {
                return ActionResultType.PASS;
            }
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            MineralSmelterTileEntity te = this.getTe(world, pos);
            if (te == null) {
                return ActionResultType.FAIL;
            }
            ItemStack stack = player.func_184586_b(hand);
            boolean dirty = false;
            if (te.accepts_lava_container(stack)) {
                if (stack.func_185136_b(MineralSmelterTileEntity.BUCKET_STACK) && te.fluid_level() >= 900) {
                    if (stack.func_190916_E() > 1) {
                        int target_stack_index = -1;
                        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
                            target_stack_index = i;
                            break;
                        }
                        if (target_stack_index >= 0) {
                            te.reset_process();
                            stack.func_190918_g(1);
                            player.func_184611_a(hand, stack);
                            player.field_71071_by.func_70299_a(target_stack_index, MineralSmelterTileEntity.LAVA_BUCKET_STACK.func_77946_l());
                            world.func_184133_a(null, pos, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            dirty = true;
                        }
                    } else {
                        te.reset_process();
                        player.func_184611_a(hand, MineralSmelterTileEntity.LAVA_BUCKET_STACK.func_77946_l());
                        world.func_184133_a(null, pos, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        dirty = true;
                    }
                }
            } else if (stack.func_190926_b()) {
                ItemStack istack = te.func_70301_a(1).func_77946_l();
                if (te.phase() > 0) {
                    player.func_70015_d(1);
                }
                if (!istack.func_190926_b()) {
                    istack.func_190920_e(1);
                    player.func_184611_a(hand, istack);
                    te.reset_process();
                    dirty = true;
                }
            } else if (te.insert(stack.func_77946_l(), false)) {
                stack.func_190918_g(1);
                dirty = true;
            }
            if (dirty) {
                player.field_71071_by.func_70296_d();
            }
            return ActionResultType.CONSUME;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rnd) {
            if (state.func_177230_c() != this) {
                return;
            }
            BasicParticleType particle = ParticleTypes.field_197601_L;
            switch ((Integer)state.func_177229_b((Property)PHASE)) {
                case 0: {
                    return;
                }
                case 1: {
                    if (rnd.nextInt(10) <= 4) break;
                    return;
                }
                case 2: {
                    if (rnd.nextInt(10) > 7) {
                        return;
                    }
                    particle = ParticleTypes.field_197594_E;
                    break;
                }
                case 3: {
                    if (rnd.nextInt(10) > 2) {
                        return;
                    }
                    particle = ParticleTypes.field_197595_F;
                    break;
                }
                default: {
                    return;
                }
            }
            double x = 0.5 + (double)pos.func_177958_n();
            double y = 0.5 + (double)pos.func_177956_o();
            double z = 0.5 + (double)pos.func_177952_p();
            double xr = rnd.nextDouble() * 0.4 - 0.2;
            double yr = rnd.nextDouble() * 0.5;
            double zr = rnd.nextDouble() * 0.4 - 0.2;
            world.func_195594_a((IParticleData)particle, x + xr, y + yr, z + zr, 0.0, 0.0, 0.0);
        }

        @Nullable
        private MineralSmelterTileEntity getTe(World world, BlockPos pos) {
            TileEntity te = world.func_175625_s(pos);
            return !(te instanceof MineralSmelterTileEntity) ? null : (MineralSmelterTileEntity)te;
        }
    }
}

