/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;

public class EdPipeValve {
    public static final int CFG_CHECK_VALVE = 1;
    public static final int CFG_ANALOG_VALVE = 2;
    public static final int CFG_REDSTONE_CONTROLLED_VALVE = 4;

    public static void on_config(int container_size_decl, int redstone_slope) {
        PipeValveTileEntity.fluid_maxflow_mb = MathHelper.func_76125_a((int)container_size_decl, (int)1, (int)10000);
        PipeValveTileEntity.redstone_flow_slope_mb = MathHelper.func_76125_a((int)redstone_slope, (int)1, (int)10000);
        ModConfig.log("Config pipe valve: maxflow:" + PipeValveTileEntity.fluid_maxflow_mb + "mb, redstone amp:" + PipeValveTileEntity.redstone_flow_slope_mb + "mb/sig.");
    }

    public static class PipeValveTileEntity
    extends TileEntity
    implements ICapabilityProvider {
        protected static int fluid_maxflow_mb = 1000;
        protected static int redstone_flow_slope_mb = 66;
        private Direction block_facing_ = null;
        private boolean filling_ = false;
        private int valve_config_;
        private LazyOptional<IFluidHandler> back_flow_handler_ = LazyOptional.of(() -> new BackFlowHandler());
        private LazyOptional<IFluidHandler> fluid_handler_ = LazyOptional.of(() -> new MainFlowHandler(this));

        public PipeValveTileEntity() {
            this(ModContent.TET_STRAIGHT_PIPE_VALVE);
        }

        public PipeValveTileEntity(TileEntityType<?> te_type) {
            super(te_type);
        }

        private Direction block_facing() {
            BlockState st = this.func_145831_w().func_180495_p(this.func_174877_v());
            return st.func_177230_c() instanceof PipeValveBlock ? (Direction)st.func_177229_b((Property)PipeValveBlock.FACING) : Direction.NORTH;
        }

        private long valve_config() {
            Block block;
            if (this.valve_config_ <= 0 && (block = this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c()) instanceof PipeValveBlock) {
                this.valve_config_ = ((PipeValveBlock)block).valve_config;
            }
            return this.valve_config_;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.back_flow_handler_.invalidate();
            this.fluid_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                Direction bf = this.block_facing();
                if (facing == bf) {
                    return this.back_flow_handler_.cast();
                }
                if (facing == bf.func_176734_d()) {
                    return this.fluid_handler_.cast();
                }
                return LazyOptional.empty();
            }
            return super.getCapability(capability, facing);
        }

        @Nullable
        private IFluidHandler forward_fluid_handler() {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.block_facing()));
            if (te == null) {
                return null;
            }
            return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.block_facing().func_176734_d()).orElse(null);
        }

        private static class BackFlowHandler
        implements IFluidHandler {
            private BackFlowHandler() {
            }

            public int getTanks() {
                return 1;
            }

            public FluidStack getFluidInTank(int tank) {
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                return 0;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return false;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }
        }

        private static class MainFlowHandler
        implements IFluidHandler {
            private PipeValveTileEntity te;

            public MainFlowHandler(PipeValveTileEntity te) {
                this.te = te;
            }

            public int getTanks() {
                return 1;
            }

            public FluidStack getFluidInTank(int tank) {
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                return fluid_maxflow_mb;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return true;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (this.te.filling_) {
                    return 0;
                }
                IFluidHandler fh = this.te.forward_fluid_handler();
                if (fh == null) {
                    return 0;
                }
                FluidStack res = resource.copy();
                if ((this.te.valve_config() & 4L) != 0L) {
                    int rs = this.te.field_145850_b.func_175687_A(this.te.field_174879_c);
                    if (rs <= 0) {
                        return 0;
                    }
                    if ((this.te.valve_config() & 2L) != 0L && rs < 15) {
                        res.setAmount(MathHelper.func_76125_a((int)(rs * redstone_flow_slope_mb), (int)1, (int)res.getAmount()));
                    }
                }
                if (res.getAmount() > fluid_maxflow_mb) {
                    res.setAmount(fluid_maxflow_mb);
                }
                this.te.filling_ = true;
                int n_filled = fh.fill(res, action);
                this.te.filling_ = false;
                return n_filled;
            }
        }
    }

    public static class PipeValveBlock
    extends DecorBlock.DirectedWaterLoggable
    implements IDecorBlock {
        public static final BooleanProperty RS_CN_N = BooleanProperty.func_177716_a((String)"rs_n");
        public static final BooleanProperty RS_CN_S = BooleanProperty.func_177716_a((String)"rs_s");
        public static final BooleanProperty RS_CN_E = BooleanProperty.func_177716_a((String)"rs_e");
        public static final BooleanProperty RS_CN_W = BooleanProperty.func_177716_a((String)"rs_w");
        public static final BooleanProperty RS_CN_U = BooleanProperty.func_177716_a((String)"rs_u");
        public static final BooleanProperty RS_CN_D = BooleanProperty.func_177716_a((String)"rs_d");
        public final int valve_config;

        public PipeValveBlock(long config, int valve_config, AbstractBlock.Properties builder, AxisAlignedBB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
            this.valve_config = valve_config;
        }

        private BlockState get_rsconnector_state(BlockState state, IWorld world, BlockPos pos, @Nullable BlockPos fromPos) {
            if ((this.valve_config & 4) == 0) {
                return state;
            }
            Direction.Axis bfa = ((Direction)state.func_177229_b((Property)FACING)).func_176740_k();
            block8: for (Direction f : Direction.values()) {
                boolean cn;
                boolean bl = cn = f.func_176740_k() != bfa;
                if (cn) {
                    BlockPos nbp = pos.func_177972_a(f);
                    if (fromPos != null && !nbp.equals((Object)fromPos)) continue;
                    BlockState nbs = world.func_180495_p(nbp);
                    if (nbs.func_177230_c() instanceof PipeValveBlock || !nbs.func_185897_m() && !nbs.canConnectRedstone((IBlockReader)world, nbp, f.func_176734_d())) {
                        cn = false;
                    }
                }
                switch (f) {
                    case NORTH: {
                        state = (BlockState)state.func_206870_a((Property)RS_CN_N, (Comparable)Boolean.valueOf(cn));
                        continue block8;
                    }
                    case SOUTH: {
                        state = (BlockState)state.func_206870_a((Property)RS_CN_S, (Comparable)Boolean.valueOf(cn));
                        continue block8;
                    }
                    case EAST: {
                        state = (BlockState)state.func_206870_a((Property)RS_CN_E, (Comparable)Boolean.valueOf(cn));
                        continue block8;
                    }
                    case WEST: {
                        state = (BlockState)state.func_206870_a((Property)RS_CN_W, (Comparable)Boolean.valueOf(cn));
                        continue block8;
                    }
                    case UP: {
                        state = (BlockState)state.func_206870_a((Property)RS_CN_U, (Comparable)Boolean.valueOf(cn));
                        continue block8;
                    }
                    case DOWN: {
                        state = (BlockState)state.func_206870_a((Property)RS_CN_D, (Comparable)Boolean.valueOf(cn));
                    }
                }
            }
            return state;
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return VoxelShapes.func_197868_b();
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{RS_CN_N, RS_CN_S, RS_CN_E, RS_CN_W, RS_CN_U, RS_CN_D});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)RS_CN_N, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RS_CN_S, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RS_CN_E, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RS_CN_W, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RS_CN_U, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RS_CN_D, (Comparable)Boolean.valueOf(false));
        }

        @Override
        public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
            return this.get_rsconnector_state(state, world, pos, null);
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            world.func_195593_d(pos, (Block)this);
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new PipeValveTileEntity();
        }

        public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
            return this.get_rsconnector_state(state, world, pos, null);
        }

        public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
            return side != null && side != state.func_177229_b((Property)FACING) && side != ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        public boolean func_149744_f(BlockState state) {
            return true;
        }

        public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return 0;
        }
    }
}

