/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Fluidics;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Overlay;
import wile.engineersdecor.libmc.detail.RfEnergy;

public class EdTestBlock {

    public static class TestTileEntity
    extends TileEntity
    implements ITickableTileEntity {
        private final RfEnergy.Battery battery_;
        private final LazyOptional<IEnergyStorage> energy_handler_;
        private final Fluidics.Tank tank_;
        private final LazyOptional<IFluidHandler> fluid_handler_;
        private final Inventories.StorageInventory inventory_;
        private final LazyOptional<IItemHandler> item_handler_;
        private int tick_timer = 0;
        private int rf_fed_avg = 0;
        private int rf_fed_total = 0;
        private int rf_fed_acc = 0;
        private int rf_received_avg = 0;
        private int rf_received_total = 0;
        private int liq_filled_avg = 0;
        private int liq_filled_total = 0;
        private int liq_filled_acc = 0;
        private int liq_received_avg = 0;
        private int liq_received_total = 0;
        private int items_inserted_total = 0;
        private int items_received_total = 0;
        private int rf_feed_setting = 4096;
        private FluidStack liq_fill_stack = new FluidStack((Fluid)Fluids.field_204546_a, 128);
        private ItemStack insertion_item = ItemStack.field_190927_a;
        private Direction block_facing = Direction.NORTH;
        private boolean paused = false;

        public TestTileEntity() {
            this(ModContent.TET_TEST_BLOCK);
        }

        public TestTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.battery_ = new RfEnergy.Battery(1000000000, 1000000000, 0, 0);
            this.energy_handler_ = this.battery_.createEnergyHandler();
            this.tank_ = new Fluidics.Tank(1000000000);
            this.fluid_handler_ = this.tank_.createFluidHandler();
            this.inventory_ = new Inventories.StorageInventory(this, 1);
            this.item_handler_ = Inventories.MappedItemHandler.createInsertionHandler(this.inventory_);
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.tank_.load(nbt);
            this.battery_.load(nbt);
            this.rf_fed_avg = nbt.func_74762_e("rf_fed_avg");
            this.rf_fed_total = nbt.func_74762_e("rf_fed_total");
            this.rf_fed_acc = nbt.func_74762_e("rf_fed_acc");
            this.rf_received_avg = nbt.func_74762_e("rf_received_avg");
            this.rf_received_total = nbt.func_74762_e("rf_received_total");
            this.liq_filled_avg = nbt.func_74762_e("liq_filled_avg");
            this.liq_filled_total = nbt.func_74762_e("liq_filled_total");
            this.liq_filled_acc = nbt.func_74762_e("liq_filled_acc");
            this.liq_received_avg = nbt.func_74762_e("liq_received_avg");
            this.liq_received_total = nbt.func_74762_e("liq_received_total");
            this.rf_feed_setting = nbt.func_74762_e("rf_feed_setting");
            this.items_received_total = nbt.func_74762_e("items_received_total");
            this.items_inserted_total = nbt.func_74762_e("items_inserted_total");
            if (nbt.func_74764_b("liq_fill_stack")) {
                this.liq_fill_stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("liq_fill_stack"));
            }
            if (nbt.func_74764_b("insertion_item")) {
                this.insertion_item = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("insertion_item"));
            }
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.tank_.save(nbt);
            this.battery_.save(nbt);
            nbt.func_74768_a("rf_fed_avg", this.rf_fed_avg);
            nbt.func_74768_a("rf_fed_total", this.rf_fed_total);
            nbt.func_74768_a("rf_fed_acc", this.rf_fed_acc);
            nbt.func_74768_a("rf_received_avg", this.rf_received_avg);
            nbt.func_74768_a("rf_received_total", this.rf_received_total);
            nbt.func_74768_a("liq_filled_avg", this.liq_filled_avg);
            nbt.func_74768_a("liq_filled_total", this.liq_filled_total);
            nbt.func_74768_a("liq_filled_acc", this.liq_filled_acc);
            nbt.func_74768_a("liq_received_avg", this.liq_received_avg);
            nbt.func_74768_a("liq_received_total", this.liq_received_total);
            nbt.func_74768_a("rf_feed_setting", this.rf_feed_setting);
            nbt.func_74768_a("items_received_total", this.items_received_total);
            nbt.func_74768_a("items_inserted_total", this.items_inserted_total);
            if (!this.liq_fill_stack.isEmpty()) {
                nbt.func_218657_a("liq_fill_stack", (INBT)this.liq_fill_stack.writeToNBT(new CompoundNBT()));
            }
            if (!this.insertion_item.func_190926_b()) {
                nbt.func_218657_a("insertion_item", (INBT)this.insertion_item.func_77955_b(new CompoundNBT()));
            }
            return nbt;
        }

        private FluidStack getFillFluid(ItemStack stack) {
            if (stack.func_77973_b() == Items.field_151131_as) {
                return new FluidStack((Fluid)Fluids.field_204546_a, 1000);
            }
            if (stack.func_77973_b() == Items.field_151129_at) {
                return new FluidStack((Fluid)Fluids.field_204547_b, 1000);
            }
            return FluidStack.EMPTY;
        }

        private ItemStack getRandomItemstack() {
            int n = (int)Math.floor(Math.random() * (double)ForgeRegistries.ITEMS.getValues().size());
            ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValues().stream().skip(n).findAny().orElse(Items.field_221585_m));
            stack.func_190920_e((int)Math.floor(Math.random() * (double)stack.func_77976_d()));
            return stack;
        }

        public boolean activated(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            ItemStack held = player.func_184586_b(hand);
            if (held.func_190926_b()) {
                ArrayList<String> msgs = new ArrayList<String>();
                if (this.rf_fed_avg > 0) {
                    msgs.add("-" + this.rf_fed_avg + "rf/t");
                }
                if (this.rf_fed_total > 0) {
                    msgs.add("-" + this.rf_fed_total + "rf");
                }
                if (this.rf_received_avg > 0) {
                    msgs.add("+" + this.rf_received_avg + "rf/t");
                }
                if (this.rf_received_total > 0) {
                    msgs.add("+" + this.rf_received_total + "rf");
                }
                if (this.liq_filled_avg > 0) {
                    msgs.add("-" + this.liq_filled_avg + "mb/t");
                }
                if (this.liq_filled_total > 0) {
                    msgs.add("-" + this.liq_filled_total + "mb");
                }
                if (this.liq_received_avg > 0) {
                    msgs.add("+" + this.liq_received_avg + "mb/t");
                }
                if (this.liq_received_total > 0) {
                    msgs.add("+" + this.liq_received_total + "mb");
                }
                if (this.items_received_total > 0) {
                    msgs.add("+" + this.items_received_total + "items");
                }
                if (this.items_inserted_total > 0) {
                    msgs.add("-" + this.items_inserted_total + "items");
                }
                if (msgs.isEmpty()) {
                    msgs.add("Nothing transferred yet.");
                }
                Overlay.show(player, (ITextComponent)new StringTextComponent(String.join((CharSequence)" | ", msgs)), 1000);
                return true;
            }
            if (this.paused) {
                if (!this.getFillFluid(held).isEmpty()) {
                    FluidStack fs = this.getFillFluid(held);
                    if (this.liq_fill_stack.isEmpty() || !this.liq_fill_stack.isFluidEqual(fs)) {
                        fs.setAmount(128);
                        this.liq_fill_stack = fs;
                    } else {
                        int amount = this.liq_fill_stack.getAmount() * 2;
                        if (amount > 4096) {
                            amount = 16;
                        }
                        this.liq_fill_stack.setAmount(amount);
                    }
                    if (this.liq_fill_stack.isEmpty()) {
                        Overlay.show(player, (ITextComponent)new StringTextComponent("Fluid fill: none"), 1000);
                    } else {
                        Overlay.show(player, (ITextComponent)new StringTextComponent("Fluid fill: " + this.liq_fill_stack.getAmount() + "mb/t of " + this.liq_fill_stack.getFluid().getRegistryName()), 1000);
                    }
                } else if (held.func_77973_b() == Items.field_151137_ax) {
                    this.rf_feed_setting = this.rf_feed_setting << 1 & 0xFFFFF0;
                    if (this.rf_feed_setting == 0) {
                        this.rf_feed_setting = 16;
                    }
                    Overlay.show(player, (ITextComponent)new StringTextComponent("RF feed rate: " + this.rf_feed_setting + "rf/t"), 1000);
                } else {
                    BlockState adjacent_state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.block_facing));
                    if (adjacent_state.func_177230_c() == Blocks.field_150438_bZ || adjacent_state.func_177230_c() == ModContent.FACTORY_HOPPER) {
                        this.insertion_item = held.func_77946_l();
                        Overlay.show(player, (ITextComponent)new StringTextComponent("Insertion item: " + (this.insertion_item.func_77973_b() == Items.field_221746_ci ? "random" : this.insertion_item.toString()) + "/s"), 1000);
                    }
                }
                return true;
            }
            return false;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.energy_handler_.invalidate();
            this.fluid_handler_.invalidate();
            this.item_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (!this.paused && facing != this.block_facing) {
                if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                    return this.fluid_handler_.cast();
                }
                if (capability == CapabilityEnergy.ENERGY) {
                    return this.energy_handler_.cast();
                }
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return this.item_handler_.cast();
                }
            }
            return super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            if (this.field_145850_b.func_201670_d()) {
                return;
            }
            this.block_facing = (Direction)this.func_195044_w().func_177229_b((Property)TestBlock.FACING);
            this.paused = this.field_145850_b.func_175640_z(this.func_174877_v());
            if (!this.paused) {
                boolean dirty = false;
                int p = RfEnergy.feed(this.func_145831_w(), this.func_174877_v().func_177972_a(this.block_facing), this.block_facing.func_176734_d(), this.rf_feed_setting);
                this.rf_fed_acc += p;
                dirty |= p > 0;
                if (!this.liq_fill_stack.isEmpty()) {
                    int f = Fluidics.fill(this.func_145831_w(), this.func_174877_v().func_177972_a(this.block_facing), this.block_facing.func_176734_d(), this.liq_fill_stack);
                    this.liq_filled_acc += f;
                    dirty |= f > 0;
                }
                if (!this.inventory_.func_191420_l()) {
                    int i = this.inventory_.func_70301_a(0).func_190916_E();
                    this.items_received_total += i;
                    this.inventory_.func_174888_l();
                    dirty |= i > 0;
                }
                if (this.tick_timer == 1 && !this.insertion_item.func_190926_b()) {
                    ItemStack stack;
                    BlockState adjacent_state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.block_facing));
                    ItemStack itemStack = stack = this.insertion_item.func_77973_b() == Items.field_221746_ci ? this.getRandomItemstack() : this.insertion_item.func_77946_l();
                    if (adjacent_state.func_177230_c() == Blocks.field_150438_bZ || adjacent_state.func_177230_c() == ModContent.FACTORY_HOPPER) {
                        ItemStack remaining = Inventories.insert(this.func_145831_w(), this.func_174877_v().func_177972_a(this.block_facing), this.block_facing.func_176734_d(), stack, false);
                        int n = stack.func_190916_E() - remaining.func_190916_E();
                        this.items_inserted_total += n;
                        dirty |= n > 0;
                    }
                }
                if (dirty) {
                    this.func_70296_d();
                }
            }
            if (--this.tick_timer <= 0) {
                this.tick_timer = 20;
                this.rf_fed_avg = this.rf_fed_acc / 20;
                this.rf_fed_total += this.rf_fed_acc;
                this.rf_fed_acc = 0;
                this.rf_received_avg = this.battery_.getEnergyStored() / 20;
                this.rf_received_total += this.battery_.getEnergyStored();
                this.battery_.clear();
                this.liq_received_avg = this.tank_.getFluidAmount();
                this.liq_received_total += this.tank_.getFluidAmount();
                this.tank_.clear();
                this.liq_filled_avg = this.liq_fill_stack.isEmpty() ? 0 : this.liq_filled_acc / 20;
                this.liq_filled_total = this.liq_fill_stack.isEmpty() ? 0 : this.liq_filled_total + this.liq_filled_acc;
                this.liq_filled_acc = 0;
            }
        }
    }

    public static class TestBlock
    extends DecorBlock.Directed
    implements Auxiliaries.IExperimentalFeature,
    IDecorBlock {
        public TestBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return VoxelShapes.func_197868_b();
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new TestTileEntity();
        }

        public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
            return true;
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, TileEntity te, boolean explosion) {
            return Collections.singletonList(new ItemStack((IItemProvider)this));
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof TestTileEntity)) {
                return ActionResultType.FAIL;
            }
            return ((TestTileEntity)te).activated(player, hand, hit) ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
    }
}

