/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.controller;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.builder.Animation;
import software.bernie.geckolib.animation.builder.AnimationBuilder;
import software.bernie.geckolib.animation.keyframe.AnimationPoint;
import software.bernie.geckolib.animation.keyframe.BoneAnimation;
import software.bernie.geckolib.animation.keyframe.BoneAnimationQueue;
import software.bernie.geckolib.animation.keyframe.EventKeyFrame;
import software.bernie.geckolib.animation.keyframe.KeyFrame;
import software.bernie.geckolib.animation.keyframe.KeyFrameLocation;
import software.bernie.geckolib.animation.keyframe.ParticleEventKeyFrame;
import software.bernie.geckolib.animation.keyframe.VectorKeyFrameList;
import software.bernie.geckolib.animation.render.AnimatedModelRenderer;
import software.bernie.geckolib.animation.snapshot.BoneSnapshot;
import software.bernie.geckolib.animation.snapshot.BoneSnapshotCollection;
import software.bernie.geckolib.easing.EasingType;
import software.bernie.geckolib.entity.IAnimatedEntity;
import software.bernie.geckolib.event.AnimationEvent;
import software.bernie.geckolib.event.AnimationTestEvent;
import software.bernie.geckolib.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib.event.ParticleKeyFrameEvent;
import software.bernie.geckolib.event.SoundKeyframeEvent;
import software.bernie.geckolib.reload.ReloadManager;

public abstract class AnimationController<T extends IAnimatedEntity> {
    protected T entity;
    private String name;
    protected AnimationState animationState = AnimationState.Stopped;
    public double transitionLengthTicks;
    private ISoundListener soundListener;
    private IParticleListener particleListener;
    private ICustomInstructionListener customInstructionListener;
    public class_3419 soundCategory = class_3419.field_15254;
    public float pitch = 1.0f;
    public float volume = 1.0f;
    public boolean distanceSoundDelay = false;
    public boolean isJustStarting = false;
    private final HashMap<String, BoneAnimationQueue> boneAnimationQueues = new HashMap();
    private double tickOffset = 0.0;
    protected Queue<Animation> animationQueue = new LinkedList<Animation>();
    private Animation currentAnimation;
    protected AnimationBuilder currentAnimationBuilder = new AnimationBuilder();
    protected boolean shouldResetTick = false;
    private HashMap<String, BoneSnapshot> boneSnapshots = new HashMap();
    private boolean justStopped = false;
    protected boolean justStartedTransition = false;
    public Function<Double, Double> customEasingMethod;
    protected boolean needsAnimationReload = false;
    protected Consumer<class_3414> soundPlayer;
    public EasingType easingType = EasingType.NONE;

    public abstract void setAnimation(@Nullable AnimationBuilder var1);

    protected AnimationController(T entity, String name, float transitionLengthTicks) {
        this.entity = entity;
        this.name = name;
        this.transitionLengthTicks = transitionLengthTicks;
        ReloadManager.registerAnimationController(this);
    }

    public AnimationController(T entity, String name, float transitionLengthTicks, EasingType easingtype) {
        this.entity = entity;
        this.name = name;
        this.transitionLengthTicks = transitionLengthTicks;
        this.easingType = easingtype;
        ReloadManager.registerAnimationController(this);
    }

    public AnimationController(T entity, String name, float transitionLengthTicks, Function<Double, Double> customEasingMethod) {
        this.entity = entity;
        this.name = name;
        this.transitionLengthTicks = transitionLengthTicks;
        this.customEasingMethod = customEasingMethod;
        this.easingType = EasingType.CUSTOM;
        ReloadManager.registerAnimationController(this);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Animation getCurrentAnimation() {
        return this.currentAnimation;
    }

    public AnimationState getAnimationState() {
        return this.animationState;
    }

    public HashMap<String, BoneAnimationQueue> getBoneAnimationQueues() {
        return this.boneAnimationQueues;
    }

    public void registerSoundListener(ISoundListener soundListener) {
        this.soundListener = soundListener;
    }

    public void registerParticleListener(IParticleListener particleListener) {
        this.particleListener = particleListener;
    }

    public void registerCustomInstructionListener(ICustomInstructionListener customInstructionListener) {
        this.customInstructionListener = customInstructionListener;
    }

    public void process(double tick, AnimationTestEvent animationTestEvent, List<AnimatedModelRenderer> modelRendererList, BoneSnapshotCollection boneSnapshotCollection) {
        boolean shouldStop;
        this.createInitialQueues(modelRendererList);
        double actualTick = tick;
        tick = this.adjustTick(tick);
        if (this.animationState == AnimationState.Transitioning && tick >= this.transitionLengthTicks) {
            this.shouldResetTick = true;
            this.animationState = AnimationState.Running;
            tick = this.adjustTick(actualTick);
        }
        assert (tick >= 0.0) : "GeckoLib: Tick was less than zero";
        boolean bl = shouldStop = !this.testAnimationPredicate(animationTestEvent);
        if (shouldStop || this.currentAnimation == null && this.animationQueue.size() == 0) {
            this.animationState = AnimationState.Stopped;
            this.justStopped = true;
            return;
        }
        if (this.justStartedTransition && (this.shouldResetTick || this.justStopped)) {
            this.justStopped = false;
            tick = this.adjustTick(actualTick);
        } else if (this.animationState != AnimationState.Transitioning) {
            this.animationState = AnimationState.Running;
        }
        if (this.animationState == AnimationState.Transitioning) {
            if (tick == 0.0 || this.isJustStarting) {
                this.justStartedTransition = false;
                this.currentAnimation = this.animationQueue.poll();
                this.resetEventKeyFrames(this.currentAnimation);
                this.saveSnapshotsForAnimation(this.currentAnimation, boneSnapshotCollection);
            }
            if (this.currentAnimation != null) {
                for (BoneAnimation boneAnimation : this.currentAnimation.boneAnimations) {
                    BoneAnimationQueue boneAnimationQueue = this.boneAnimationQueues.get(boneAnimation.boneName);
                    BoneSnapshot boneSnapshot = this.boneSnapshots.get(boneAnimation.boneName);
                    BoneSnapshot initialSnapshot = modelRendererList.stream().filter(x -> x.name.equals(boneAnimation.boneName)).findFirst().get().getInitialSnapshot();
                    assert (boneSnapshot != null) : "Bone snapshot was null";
                    VectorKeyFrameList<KeyFrame<Double>> rotationKeyFrames = boneAnimation.rotationKeyFrames;
                    VectorKeyFrameList<KeyFrame<Double>> positionKeyFrames = boneAnimation.positionKeyFrames;
                    VectorKeyFrameList<KeyFrame<Double>> scaleKeyFrames = boneAnimation.scaleKeyFrames;
                    if (!rotationKeyFrames.xKeyFrames.isEmpty()) {
                        boneAnimationQueue.rotationXQueue.add(new AnimationPoint(null, (Double)tick, (Double)this.transitionLengthTicks, Float.valueOf(boneSnapshot.rotationValueX - initialSnapshot.rotationValueX), (Double)((KeyFrame)rotationKeyFrames.xKeyFrames.get(0)).getStartValue()));
                        boneAnimationQueue.rotationYQueue.add(new AnimationPoint(null, (Double)tick, (Double)this.transitionLengthTicks, Float.valueOf(boneSnapshot.rotationValueY - initialSnapshot.rotationValueY), (Double)((KeyFrame)rotationKeyFrames.yKeyFrames.get(0)).getStartValue()));
                        boneAnimationQueue.rotationZQueue.add(new AnimationPoint(null, (Double)tick, (Double)this.transitionLengthTicks, Float.valueOf(boneSnapshot.rotationValueZ - initialSnapshot.rotationValueZ), (Double)((KeyFrame)rotationKeyFrames.zKeyFrames.get(0)).getStartValue()));
                    }
                    if (!positionKeyFrames.xKeyFrames.isEmpty()) {
                        boneAnimationQueue.positionXQueue.add(new AnimationPoint(null, (Double)tick, (Double)this.transitionLengthTicks, Float.valueOf(boneSnapshot.positionOffsetX), (Double)((KeyFrame)positionKeyFrames.xKeyFrames.get(0)).getStartValue()));
                        boneAnimationQueue.positionYQueue.add(new AnimationPoint(null, (Double)tick, (Double)this.transitionLengthTicks, Float.valueOf(boneSnapshot.positionOffsetY), (Double)((KeyFrame)positionKeyFrames.yKeyFrames.get(0)).getStartValue()));
                        boneAnimationQueue.positionZQueue.add(new AnimationPoint(null, (Double)tick, (Double)this.transitionLengthTicks, Float.valueOf(boneSnapshot.positionOffsetZ), (Double)((KeyFrame)positionKeyFrames.zKeyFrames.get(0)).getStartValue()));
                    }
                    if (scaleKeyFrames.xKeyFrames.isEmpty()) continue;
                    boneAnimationQueue.scaleXQueue.add(new AnimationPoint(null, (Double)tick, (Double)this.transitionLengthTicks, Float.valueOf(boneSnapshot.scaleValueX), (Double)((KeyFrame)scaleKeyFrames.xKeyFrames.get(0)).getStartValue()));
                    boneAnimationQueue.scaleYQueue.add(new AnimationPoint(null, (Double)tick, (Double)this.transitionLengthTicks, Float.valueOf(boneSnapshot.scaleValueY), (Double)((KeyFrame)scaleKeyFrames.yKeyFrames.get(0)).getStartValue()));
                    boneAnimationQueue.scaleZQueue.add(new AnimationPoint(null, (Double)tick, (Double)this.transitionLengthTicks, Float.valueOf(boneSnapshot.scaleValueZ), (Double)((KeyFrame)scaleKeyFrames.zKeyFrames.get(0)).getStartValue()));
                }
            }
        } else if (this.getAnimationState() == AnimationState.Running) {
            this.processCurrentAnimation(tick, actualTick);
        }
    }

    protected abstract boolean testAnimationPredicate(AnimationTestEvent<T> var1);

    private void saveSnapshotsForAnimation(@Nonnull Animation animation, BoneSnapshotCollection boneSnapshotCollection) {
        for (BoneSnapshot snapshot : boneSnapshotCollection.values()) {
            if (animation == null || animation.boneAnimations == null || !animation.boneAnimations.stream().anyMatch(x -> x.boneName.equals(snapshot.name))) continue;
            this.boneSnapshots.put(snapshot.name, new BoneSnapshot(snapshot));
        }
    }

    private void processCurrentAnimation(double tick, double actualTick) {
        assert (this.currentAnimation != null);
        if (tick >= this.currentAnimation.animationLength) {
            this.resetEventKeyFrames(this.currentAnimation);
            if (!this.currentAnimation.loop) {
                Animation peek = this.animationQueue.peek();
                if (peek == null) {
                    this.animationState = AnimationState.Stopped;
                    return;
                }
                this.animationState = AnimationState.Transitioning;
                this.shouldResetTick = true;
            } else {
                this.shouldResetTick = true;
                tick = this.adjustTick(actualTick);
            }
        }
        List<BoneAnimation> boneAnimations = this.currentAnimation.boneAnimations;
        for (BoneAnimation boneAnimation : boneAnimations) {
            BoneAnimationQueue boneAnimationQueue = this.boneAnimationQueues.get(boneAnimation.boneName);
            VectorKeyFrameList<KeyFrame<Double>> rotationKeyFrames = boneAnimation.rotationKeyFrames;
            VectorKeyFrameList<KeyFrame<Double>> positionKeyFrames = boneAnimation.positionKeyFrames;
            VectorKeyFrameList<KeyFrame<Double>> scaleKeyFrames = boneAnimation.scaleKeyFrames;
            if (!rotationKeyFrames.xKeyFrames.isEmpty()) {
                boneAnimationQueue.rotationXQueue.add(this.getAnimationPointAtTick(rotationKeyFrames.xKeyFrames, tick));
                boneAnimationQueue.rotationYQueue.add(this.getAnimationPointAtTick(rotationKeyFrames.yKeyFrames, tick));
                boneAnimationQueue.rotationZQueue.add(this.getAnimationPointAtTick(rotationKeyFrames.zKeyFrames, tick));
            }
            if (!positionKeyFrames.xKeyFrames.isEmpty()) {
                boneAnimationQueue.positionXQueue.add(this.getAnimationPointAtTick(positionKeyFrames.xKeyFrames, tick));
                boneAnimationQueue.positionYQueue.add(this.getAnimationPointAtTick(positionKeyFrames.yKeyFrames, tick));
                boneAnimationQueue.positionZQueue.add(this.getAnimationPointAtTick(positionKeyFrames.zKeyFrames, tick));
            }
            if (scaleKeyFrames.xKeyFrames.isEmpty()) continue;
            boneAnimationQueue.scaleXQueue.add(this.getAnimationPointAtTick(scaleKeyFrames.xKeyFrames, tick));
            boneAnimationQueue.scaleYQueue.add(this.getAnimationPointAtTick(scaleKeyFrames.yKeyFrames, tick));
            boneAnimationQueue.scaleZQueue.add(this.getAnimationPointAtTick(scaleKeyFrames.zKeyFrames, tick));
        }
        if (this.soundListener != null || this.particleListener != null || this.customInstructionListener != null) {
            AnimationEvent event;
            for (EventKeyFrame eventKeyFrame : this.currentAnimation.soundKeyFrames) {
                if (eventKeyFrame.hasExecuted || !(tick >= eventKeyFrame.getStartTick())) continue;
                event = new SoundKeyframeEvent<T>(this.entity, tick, (String)eventKeyFrame.getEventData(), this);
                class_3414 soundEvent = this.soundListener.playSound(event);
                if (soundEvent != null) {
                    this.soundPlayer.accept(soundEvent);
                }
                eventKeyFrame.hasExecuted = true;
            }
            for (ParticleEventKeyFrame particleEventKeyFrame : this.currentAnimation.particleKeyFrames) {
                if (particleEventKeyFrame.hasExecuted || !(tick >= particleEventKeyFrame.getStartTick())) continue;
                event = new ParticleKeyFrameEvent<T>(this.entity, tick, particleEventKeyFrame.effect, particleEventKeyFrame.locator, particleEventKeyFrame.script, this);
                this.particleListener.summonParticle(event);
                particleEventKeyFrame.hasExecuted = true;
            }
            for (EventKeyFrame eventKeyFrame : this.currentAnimation.customInstructionKeyframes) {
                if (eventKeyFrame.hasExecuted || !(tick >= eventKeyFrame.getStartTick())) continue;
                event = new CustomInstructionKeyframeEvent<T>(this.entity, tick, (List)eventKeyFrame.getEventData(), this);
                this.customInstructionListener.executeInstruction(event);
                eventKeyFrame.hasExecuted = true;
            }
        }
    }

    private void createInitialQueues(List<AnimatedModelRenderer> modelRendererList) {
        if (this.boneAnimationQueues.size() == 0) {
            for (AnimatedModelRenderer modelRenderer : modelRendererList) {
                this.boneAnimationQueues.put(modelRenderer.name, new BoneAnimationQueue(modelRenderer));
            }
        }
    }

    private double adjustTick(double tick) {
        if (this.shouldResetTick) {
            this.tickOffset = tick;
            this.shouldResetTick = false;
            return 0.0;
        }
        return tick - this.tickOffset < 0.0 ? 0.0 : tick - this.tickOffset;
    }

    private AnimationPoint getAnimationPointAtTick(List<KeyFrame<Double>> frames, double tick) {
        KeyFrameLocation<KeyFrame<Double>> location = this.getCurrentKeyFrameLocation(frames, tick);
        Object currentFrame = location.CurrentFrame;
        return new AnimationPoint((KeyFrame<Double>)currentFrame, (Double)location.CurrentAnimationTick, ((KeyFrame)currentFrame).getLength(), (Double)((KeyFrame)currentFrame).getStartValue(), (Double)((KeyFrame)currentFrame).getEndValue());
    }

    private KeyFrameLocation<KeyFrame<Double>> getCurrentKeyFrameLocation(List<KeyFrame<Double>> frames, double ageInTicks) {
        double totalTimeTracker = 0.0;
        for (int i = 0; i < frames.size(); ++i) {
            KeyFrame<Double> frame = frames.get(i);
            if (!((totalTimeTracker += frame.getLength().doubleValue()) > ageInTicks)) continue;
            double tick = ageInTicks - (totalTimeTracker - frame.getLength());
            return new KeyFrameLocation<KeyFrame<Double>>(frame, tick);
        }
        return new KeyFrameLocation<KeyFrame<Double>>(frames.get(frames.size() - 1), ageInTicks);
    }

    private void resetEventKeyFrames(Animation animation) {
        if (animation == null) {
            return;
        }
        if (!animation.soundKeyFrames.isEmpty()) {
            for (EventKeyFrame<String> eventKeyFrame : animation.soundKeyFrames) {
                eventKeyFrame.hasExecuted = false;
            }
        }
        if (!animation.particleKeyFrames.isEmpty()) {
            for (EventKeyFrame<String> eventKeyFrame : animation.particleKeyFrames) {
                eventKeyFrame.hasExecuted = false;
            }
        }
        if (!animation.customInstructionKeyframes.isEmpty()) {
            for (EventKeyFrame<Object> eventKeyFrame : animation.customInstructionKeyframes) {
                eventKeyFrame.hasExecuted = false;
            }
        }
    }

    public void markNeedsReload() {
        this.needsAnimationReload = true;
    }

    @FunctionalInterface
    public static interface ICustomInstructionListener {
        public <ENTITY extends class_1297> void executeInstruction(CustomInstructionKeyframeEvent<ENTITY> var1);
    }

    @FunctionalInterface
    public static interface IParticleListener {
        public <ENTITY extends class_1297> void summonParticle(ParticleKeyFrameEvent<ENTITY> var1);
    }

    @FunctionalInterface
    public static interface ISoundListener {
        public <ENTITY extends class_1297> class_3414 playSound(SoundKeyframeEvent<ENTITY> var1);
    }

    @FunctionalInterface
    public static interface IAnimationPredicate<P> {
        public <P> boolean test(AnimationTestEvent<P> var1);
    }
}

