/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.controller;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_3414;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.builder.Animation;
import software.bernie.geckolib.animation.builder.AnimationBuilder;
import software.bernie.geckolib.animation.controller.AnimationController;
import software.bernie.geckolib.animation.model.AnimatedEntityModel;
import software.bernie.geckolib.easing.EasingType;
import software.bernie.geckolib.entity.IAnimatedEntity;
import software.bernie.geckolib.event.AnimationTestEvent;
import software.bernie.geckolib.util.AnimationUtils;

public class EntityAnimationController<T extends class_1297>
extends AnimationController<T> {
    private IEntityAnimationPredicate<T> animationPredicate;

    public EntityAnimationController(T entity, String name, float transitionLengthTicks, IEntityAnimationPredicate<T> animationPredicate) {
        super((IAnimatedEntity)entity, name, transitionLengthTicks);
        this.animationPredicate = animationPredicate;
        this.soundPlayer = this::playSound;
    }

    public EntityAnimationController(T entity, String name, float transitionLengthTicks, IEntityAnimationPredicate<T> animationPredicate, EasingType easingtype) {
        super((IAnimatedEntity)entity, name, transitionLengthTicks, easingtype);
        this.animationPredicate = animationPredicate;
    }

    public EntityAnimationController(T entity, String name, float transitionLengthTicks, IEntityAnimationPredicate<T> animationPredicate, Function<Double, Double> customEasingMethod) {
        super((IAnimatedEntity)entity, name, transitionLengthTicks, customEasingMethod);
        this.animationPredicate = animationPredicate;
    }

    @Override
    public void setAnimation(@Nullable AnimationBuilder builder) {
        AnimatedEntityModel model = AnimationUtils.getModelForEntity((class_1297)this.entity);
        if (model != null) {
            if (builder == null || builder.getRawAnimationList().size() == 0) {
                this.animationState = AnimationState.Stopped;
            } else if (!builder.getRawAnimationList().equals(this.currentAnimationBuilder.getRawAnimationList()) || this.needsAnimationReload) {
                AtomicBoolean encounteredError = new AtomicBoolean(false);
                LinkedList animations = new LinkedList(builder.getRawAnimationList().stream().map(rawAnimation -> {
                    Animation animation = model.getAnimation(rawAnimation.animationName);
                    if (animation == null) {
                        GeckoLib.LOGGER.error("Could not load animation: " + rawAnimation.animationName + ". Is it missing?");
                        encounteredError.set(true);
                    }
                    if (animation != null && rawAnimation.loop != null) {
                        animation.loop = rawAnimation.loop;
                    }
                    return animation;
                }).collect(Collectors.toList()));
                if (encounteredError.get()) {
                    return;
                }
                this.animationQueue = animations;
                this.currentAnimationBuilder = builder;
                this.shouldResetTick = true;
                this.animationState = AnimationState.Transitioning;
                this.justStartedTransition = true;
                this.needsAnimationReload = false;
            }
        }
    }

    @Override
    protected boolean testAnimationPredicate(AnimationTestEvent<T> event) {
        return this.animationPredicate.test(event);
    }

    public void playSound(class_3414 event) {
        ((class_1297)this.entity).field_6002.method_8486(((class_1297)this.entity).method_23317(), ((class_1297)this.entity).method_23318(), ((class_1297)this.entity).method_23321(), event, this.soundCategory, this.volume, this.pitch, this.distanceSoundDelay);
    }

    @FunctionalInterface
    public static interface IEntityAnimationPredicate<E extends class_1297> {
        public <E extends class_1297> boolean test(AnimationTestEvent<E> var1);
    }
}

