/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_2973;
import net.minecraft.class_310;
import net.minecraft.class_3296;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_583;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.animation.builder.Animation;
import software.bernie.geckolib.animation.controller.AnimationController;
import software.bernie.geckolib.animation.keyframe.AnimationPoint;
import software.bernie.geckolib.animation.keyframe.BoneAnimationQueue;
import software.bernie.geckolib.animation.render.AnimatedModelRenderer;
import software.bernie.geckolib.animation.snapshot.BoneSnapshot;
import software.bernie.geckolib.animation.snapshot.BoneSnapshotCollection;
import software.bernie.geckolib.animation.snapshot.DirtyTracker;
import software.bernie.geckolib.animation.snapshot.EntityDirtyTracker;
import software.bernie.geckolib.entity.IAnimatedEntity;
import software.bernie.geckolib.event.AnimationTestEvent;
import software.bernie.geckolib.manager.EntityAnimationManager;
import software.bernie.geckolib.reload.ReloadManager;
import software.bernie.geckolib.util.AnimationUtils;
import software.bernie.geckolib.util.json.JsonAnimationUtils;

public abstract class AnimatedEntityModel<T extends class_1297>
extends class_583<T>
implements class_4013 {
    private JsonObject animationFile;
    private List<AnimatedModelRenderer> modelRendererList = new ArrayList<AnimatedModelRenderer>();
    private HashMap<String, Animation> animationList = new HashMap();
    public List<AnimatedModelRenderer> rootBones = new ArrayList<AnimatedModelRenderer>();
    public double seekTime;
    public double lastGameTickTime;
    public boolean loopByDefault = false;

    public abstract class_2960 getAnimationFileLocation();

    protected AnimatedEntityModel() {
        ReloadManager.registerModel(this);
        class_3296 resourceManager = (class_3296)class_310.method_1551().method_1478();
        this.method_14491((class_3300)resourceManager);
    }

    public void method_14491(class_3300 resourceManager) {
        try (InputStream inputStream = this.getStreamForResourceLocation(this.getAnimationFileLocation());
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            Gson GSON = new Gson();
            JsonObject jsonobject = (JsonObject)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonObject.class);
            this.setAnimationFile(jsonobject);
            this.loadAllAnimations();
        }
        catch (IOException e) {
            GeckoLib.LOGGER.error("Encountered error while loading animations.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public InputStream getStreamForResourceLocation(class_2960 resourceLocation) {
        return new BufferedInputStream(GeckoLib.class.getResourceAsStream("/assets/" + resourceLocation.method_12836() + "/" + resourceLocation.method_12832()));
    }

    private void loadAllAnimations() {
        this.animationList.clear();
        Set<Map.Entry<String, JsonElement>> entrySet = JsonAnimationUtils.getAnimations(this.getAnimationFile());
        for (Map.Entry<String, JsonElement> entry : entrySet) {
            String animationName = entry.getKey();
            Animation animation = null;
            try {
                animation = JsonAnimationUtils.deserializeJsonToAnimation(JsonAnimationUtils.getAnimation(this.getAnimationFile(), animationName));
                if (this.loopByDefault) {
                    animation.loop = true;
                }
            }
            catch (class_2973 e) {
                GeckoLib.LOGGER.error("Could not load animation: " + animationName, (Throwable)e);
                throw new RuntimeException(e);
            }
            this.animationList.put(animationName, animation);
        }
    }

    public JsonObject getAnimationFile() {
        return this.animationFile;
    }

    public void setAnimationFile(JsonObject animationFile) {
        this.animationFile = animationFile;
    }

    public AnimatedModelRenderer getBone(String boneName) {
        return this.modelRendererList.stream().filter(x -> x.name.equals(boneName)).findFirst().orElse(null);
    }

    public void registerModelRenderer(AnimatedModelRenderer modelRenderer) {
        modelRenderer.saveInitialSnapshot();
        this.modelRendererList.add(modelRenderer);
    }

    public Map.Entry<String, JsonElement> getAnimationByName(String name) throws class_2973 {
        return JsonAnimationUtils.getAnimation(this.getAnimationFile(), name);
    }

    public void setRotationAngle(AnimatedModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_3654 = x;
        modelRenderer.field_3675 = y;
        modelRenderer.field_3674 = z;
    }

    public void method_2816(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        EntityDirtyTracker modelTracker = this.createNewDirtyTracker();
        EntityAnimationManager manager = ((IAnimatedEntity)entity).getAnimationManager();
        manager.tick = (float)((class_1297)entity).field_6012 + partialTick;
        double gameTick = manager.tick;
        double deltaTicks = gameTick - this.lastGameTickTime;
        this.seekTime += manager.getCurrentAnimationSpeed() * deltaTicks;
        this.lastGameTickTime = gameTick;
        if (manager.getBoneSnapshotCollection().isEmpty()) {
            manager.setBoneSnapshotCollection(this.createNewBoneSnapshotCollection());
        }
        BoneSnapshotCollection boneSnapshots = manager.getBoneSnapshotCollection();
        for (AnimationController controller : manager.values()) {
            AnimationTestEvent<T> animationTestEvent = new AnimationTestEvent<T>(entity, this.seekTime, limbSwing, limbSwingAmount, partialTick, controller, !(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f));
            controller.isJustStarting = manager.isFirstTick;
            controller.process(this.seekTime, animationTestEvent, this.modelRendererList, boneSnapshots);
            for (BoneAnimationQueue boneAnimation : controller.getBoneAnimationQueues().values()) {
                AnimatedModelRenderer bone = boneAnimation.bone;
                BoneSnapshot snapshot = boneSnapshots.get(bone.name);
                BoneSnapshot initialSnapshot = bone.getInitialSnapshot();
                AnimationPoint rXPoint = (AnimationPoint)boneAnimation.rotationXQueue.poll();
                AnimationPoint rYPoint = (AnimationPoint)boneAnimation.rotationYQueue.poll();
                AnimationPoint rZPoint = (AnimationPoint)boneAnimation.rotationZQueue.poll();
                AnimationPoint pXPoint = (AnimationPoint)boneAnimation.positionXQueue.poll();
                AnimationPoint pYPoint = (AnimationPoint)boneAnimation.positionYQueue.poll();
                AnimationPoint pZPoint = (AnimationPoint)boneAnimation.positionZQueue.poll();
                AnimationPoint sXPoint = (AnimationPoint)boneAnimation.scaleXQueue.poll();
                AnimationPoint sYPoint = (AnimationPoint)boneAnimation.scaleYQueue.poll();
                AnimationPoint sZPoint = (AnimationPoint)boneAnimation.scaleZQueue.poll();
                if (rXPoint != null && rYPoint != null && rZPoint != null) {
                    bone.field_3654 = AnimationUtils.lerpValues(rXPoint, controller.easingType, controller.customEasingMethod) + initialSnapshot.rotationValueX;
                    bone.field_3675 = AnimationUtils.lerpValues(rYPoint, controller.easingType, controller.customEasingMethod) + initialSnapshot.rotationValueY;
                    bone.field_3674 = AnimationUtils.lerpValues(rZPoint, controller.easingType, controller.customEasingMethod) + initialSnapshot.rotationValueZ;
                    snapshot.rotationValueX = bone.field_3654;
                    snapshot.rotationValueY = bone.field_3675;
                    snapshot.rotationValueZ = bone.field_3674;
                    snapshot.isCurrentlyRunningRotationAnimation = true;
                    modelTracker.get((AnimatedModelRenderer)bone).hasRotationChanged = true;
                }
                if (pXPoint != null && pYPoint != null && pZPoint != null) {
                    bone.positionOffsetX = AnimationUtils.lerpValues(pXPoint, controller.easingType, controller.customEasingMethod);
                    bone.positionOffsetY = AnimationUtils.lerpValues(pYPoint, controller.easingType, controller.customEasingMethod);
                    bone.positionOffsetZ = AnimationUtils.lerpValues(pZPoint, controller.easingType, controller.customEasingMethod);
                    snapshot.positionOffsetX = bone.positionOffsetX;
                    snapshot.positionOffsetY = bone.positionOffsetY;
                    snapshot.positionOffsetZ = bone.positionOffsetZ;
                    snapshot.isCurrentlyRunningPositionAnimation = true;
                    modelTracker.get((AnimatedModelRenderer)bone).hasPositionChanged = true;
                }
                if (sXPoint == null || sYPoint == null || sZPoint == null) continue;
                bone.scaleValueX = AnimationUtils.lerpValues(sXPoint, controller.easingType, controller.customEasingMethod);
                bone.scaleValueY = AnimationUtils.lerpValues(sYPoint, controller.easingType, controller.customEasingMethod);
                bone.scaleValueZ = AnimationUtils.lerpValues(sZPoint, controller.easingType, controller.customEasingMethod);
                snapshot.scaleValueX = bone.scaleValueX;
                snapshot.scaleValueY = bone.scaleValueY;
                snapshot.scaleValueZ = bone.scaleValueZ;
                snapshot.isCurrentlyRunningScaleAnimation = true;
                modelTracker.get((AnimatedModelRenderer)bone).hasScaleChanged = true;
            }
        }
        double resetTickLength = manager.getResetSpeed();
        for (DirtyTracker tracker : modelTracker) {
            double percentageReset;
            AnimatedModelRenderer model = tracker.model;
            BoneSnapshot initialSnapshot = model.getInitialSnapshot();
            BoneSnapshot saveSnapshot = boneSnapshots.get(tracker.model.name);
            if (!tracker.hasRotationChanged) {
                if (saveSnapshot.isCurrentlyRunningRotationAnimation) {
                    saveSnapshot.mostRecentResetRotationTick = (float)this.seekTime;
                    saveSnapshot.isCurrentlyRunningRotationAnimation = false;
                }
                percentageReset = Math.min((this.seekTime - (double)saveSnapshot.mostRecentResetRotationTick) / resetTickLength, 1.0);
                model.field_3654 = AnimationUtils.lerpValues(percentageReset, saveSnapshot.rotationValueX, initialSnapshot.rotationValueX);
                model.field_3675 = AnimationUtils.lerpValues(percentageReset, saveSnapshot.rotationValueY, initialSnapshot.rotationValueY);
                model.field_3674 = AnimationUtils.lerpValues(percentageReset, saveSnapshot.rotationValueZ, initialSnapshot.rotationValueZ);
                if (percentageReset >= 1.0) {
                    saveSnapshot.rotationValueX = model.field_3654;
                    saveSnapshot.rotationValueY = model.field_3675;
                    saveSnapshot.rotationValueZ = model.field_3674;
                }
            }
            if (!tracker.hasPositionChanged) {
                if (saveSnapshot.isCurrentlyRunningPositionAnimation) {
                    saveSnapshot.mostRecentResetPositionTick = (float)this.seekTime;
                    saveSnapshot.isCurrentlyRunningPositionAnimation = false;
                }
                percentageReset = Math.min((this.seekTime - (double)saveSnapshot.mostRecentResetPositionTick) / resetTickLength, 1.0);
                model.positionOffsetX = AnimationUtils.lerpValues(percentageReset, saveSnapshot.positionOffsetX, initialSnapshot.positionOffsetX);
                model.positionOffsetY = AnimationUtils.lerpValues(percentageReset, saveSnapshot.positionOffsetY, initialSnapshot.positionOffsetY);
                model.positionOffsetZ = AnimationUtils.lerpValues(percentageReset, saveSnapshot.positionOffsetZ, initialSnapshot.positionOffsetZ);
                if (percentageReset >= 1.0) {
                    saveSnapshot.positionOffsetX = model.positionOffsetX;
                    saveSnapshot.positionOffsetY = model.positionOffsetY;
                    saveSnapshot.positionOffsetZ = model.positionOffsetZ;
                }
            }
            if (tracker.hasScaleChanged) continue;
            if (saveSnapshot.isCurrentlyRunningScaleAnimation) {
                saveSnapshot.mostRecentResetScaleTick = (float)this.seekTime;
                saveSnapshot.isCurrentlyRunningScaleAnimation = false;
            }
            percentageReset = Math.min((this.seekTime - (double)saveSnapshot.mostRecentResetScaleTick) / resetTickLength, 1.0);
            model.scaleValueX = AnimationUtils.lerpValues(percentageReset, saveSnapshot.scaleValueX, initialSnapshot.scaleValueX);
            model.scaleValueY = AnimationUtils.lerpValues(percentageReset, saveSnapshot.scaleValueY, initialSnapshot.scaleValueY);
            model.scaleValueZ = AnimationUtils.lerpValues(percentageReset, saveSnapshot.scaleValueZ, initialSnapshot.scaleValueZ);
            if (!(percentageReset >= 1.0)) continue;
            saveSnapshot.scaleValueX = model.scaleValueX;
            saveSnapshot.scaleValueY = model.scaleValueY;
            saveSnapshot.scaleValueZ = model.scaleValueZ;
        }
        manager.isFirstTick = false;
    }

    private EntityDirtyTracker createNewDirtyTracker() {
        EntityDirtyTracker tracker = new EntityDirtyTracker();
        for (AnimatedModelRenderer bone : this.modelRendererList) {
            tracker.add(new DirtyTracker(false, false, false, bone));
        }
        return tracker;
    }

    private BoneSnapshotCollection createNewBoneSnapshotCollection() {
        BoneSnapshotCollection collection = new BoneSnapshotCollection();
        for (AnimatedModelRenderer bone : this.modelRendererList) {
            collection.put(bone.name, new BoneSnapshot(bone.getInitialSnapshot()));
        }
        return collection;
    }

    public void method_2819(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public Animation getAnimation(String name) {
        return this.animationList.get(name);
    }

    public void method_2828(class_4587 matrixStackIn, class_4588 bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        for (AnimatedModelRenderer model : this.rootBones) {
            model.method_22699(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

