/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_583;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.animation.keyframe.AnimationPoint;
import software.bernie.geckolib.animation.model.AnimatedEntityModel;
import software.bernie.geckolib.easing.EasingManager;
import software.bernie.geckolib.easing.EasingType;

public class AnimationUtils {
    public static double convertTicksToSeconds(double ticks) {
        return ticks / 20.0;
    }

    public static double convertSecondsToTicks(double seconds) {
        return seconds * 20.0;
    }

    public static float lerpValues(double percentCompleted, double startValue, double endValue) {
        return (float)class_3532.method_16436((double)percentCompleted, (double)startValue, (double)endValue);
    }

    public static float lerpValues(AnimationPoint animationPoint, EasingType easingType, Function<Double, Double> customEasingMethod) {
        if (animationPoint.currentTick >= animationPoint.animationEndTick) {
            return animationPoint.animationEndValue.floatValue();
        }
        if (animationPoint.currentTick == 0.0 && animationPoint.animationEndTick == 0.0) {
            return animationPoint.animationEndValue.floatValue();
        }
        if (easingType == EasingType.CUSTOM && customEasingMethod != null) {
            return AnimationUtils.lerpValues(customEasingMethod.apply(animationPoint.currentTick / animationPoint.animationEndTick), animationPoint.animationStartValue.floatValue(), animationPoint.animationEndValue.floatValue());
        }
        if (easingType == EasingType.NONE && animationPoint.keyframe != null) {
            easingType = animationPoint.keyframe.easingType;
        }
        double ease = EasingManager.ease(animationPoint.currentTick / animationPoint.animationEndTick, easingType, animationPoint.keyframe == null ? null : animationPoint.keyframe.easingArgs);
        return AnimationUtils.lerpValues(ease, animationPoint.animationStartValue.floatValue(), animationPoint.animationEndValue.floatValue());
    }

    public static <T extends class_1297> class_897<T> getRenderer(T entity) {
        class_898 renderManager = class_310.method_1551().method_1561();
        return renderManager.method_3953(entity);
    }

    public static <T extends class_1297> AnimatedEntityModel getModelForEntity(T entity) {
        class_897<T> entityRenderer = AnimationUtils.getRenderer(entity);
        if (entityRenderer instanceof class_3883) {
            class_922 renderer = (class_922)entityRenderer;
            class_583 entityModel = renderer.method_4038();
            if (entityModel instanceof AnimatedEntityModel) {
                return (AnimatedEntityModel)entityModel;
            }
            GeckoLib.LOGGER.error("Model for " + entity.method_5477() + " is not an AnimatedEntityModel. Please inherit the proper class.");
            return null;
        }
        GeckoLib.LOGGER.error("Could not find valid renderer for " + entity.method_5477());
        return null;
    }
}

