/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util.json;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2973;
import software.bernie.geckolib.animation.builder.Animation;
import software.bernie.geckolib.animation.keyframe.BoneAnimation;
import software.bernie.geckolib.animation.keyframe.EventKeyFrame;
import software.bernie.geckolib.animation.keyframe.ParticleEventKeyFrame;
import software.bernie.geckolib.animation.keyframe.VectorKeyFrameList;
import software.bernie.geckolib.util.AnimationUtils;
import software.bernie.geckolib.util.json.JsonKeyFrameUtils;

public class JsonAnimationUtils {
    public static Set<Map.Entry<String, JsonElement>> getAnimations(JsonObject json) {
        return JsonAnimationUtils.getObjectListAsArray(json.getAsJsonObject("animations"));
    }

    public static List<Map.Entry<String, JsonElement>> getBones(JsonObject json) {
        JsonObject bones = json.getAsJsonObject("bones");
        return bones == null ? new ArrayList<Map.Entry<String, JsonElement>>() : new ArrayList<Map.Entry<String, JsonElement>>(JsonAnimationUtils.getObjectListAsArray(bones));
    }

    public static Set<Map.Entry<String, JsonElement>> getRotationKeyFrames(JsonObject json) {
        JsonElement rotationObject = json.get("rotation");
        if (rotationObject.isJsonArray()) {
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonArray>("0.001", rotationObject.getAsJsonArray()));
        }
        if (rotationObject.isJsonPrimitive()) {
            double value = rotationObject.getAsDouble();
            Gson gson = new Gson();
            JsonElement jsonElement = gson.toJsonTree(Arrays.asList(value, value, value));
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonElement>("0.001", jsonElement));
        }
        return JsonAnimationUtils.getObjectListAsArray(rotationObject.getAsJsonObject());
    }

    public static Set<Map.Entry<String, JsonElement>> getPositionKeyFrames(JsonObject json) {
        JsonElement positionObject = json.get("position");
        if (positionObject.isJsonArray()) {
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonArray>("0.001", positionObject.getAsJsonArray()));
        }
        if (positionObject.isJsonPrimitive()) {
            double value = positionObject.getAsDouble();
            Gson gson = new Gson();
            JsonElement jsonElement = gson.toJsonTree(Arrays.asList(value, value, value));
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonElement>("0.001", jsonElement));
        }
        return JsonAnimationUtils.getObjectListAsArray(positionObject.getAsJsonObject());
    }

    public static Set<Map.Entry<String, JsonElement>> getScaleKeyFrames(JsonObject json) {
        JsonElement scaleObject = json.get("scale");
        if (scaleObject.isJsonArray()) {
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonArray>("0.001", scaleObject.getAsJsonArray()));
        }
        if (scaleObject.isJsonPrimitive()) {
            double value = scaleObject.getAsDouble();
            Gson gson = new Gson();
            JsonElement jsonElement = gson.toJsonTree(Arrays.asList(value, value, value));
            return ImmutableSet.of(new AbstractMap.SimpleEntry<String, JsonElement>("0.001", jsonElement));
        }
        return JsonAnimationUtils.getObjectListAsArray(scaleObject.getAsJsonObject());
    }

    public static ArrayList<Map.Entry<String, JsonElement>> getSoundEffectFrames(JsonObject json) {
        JsonObject sound_effects = json.getAsJsonObject("sound_effects");
        return sound_effects == null ? new ArrayList<Map.Entry<String, JsonElement>>() : new ArrayList<Map.Entry<String, JsonElement>>(JsonAnimationUtils.getObjectListAsArray(sound_effects));
    }

    public static ArrayList<Map.Entry<String, JsonElement>> getParticleEffectFrames(JsonObject json) {
        JsonObject particle_effects = json.getAsJsonObject("particle_effects");
        return particle_effects == null ? new ArrayList<Map.Entry<String, JsonElement>>() : new ArrayList<Map.Entry<String, JsonElement>>(JsonAnimationUtils.getObjectListAsArray(particle_effects));
    }

    public static ArrayList<Map.Entry<String, JsonElement>> getCustomInstructionKeyFrames(JsonObject json) {
        JsonObject custom_instructions = json.getAsJsonObject("timeline");
        return custom_instructions == null ? new ArrayList<Map.Entry<String, JsonElement>>() : new ArrayList<Map.Entry<String, JsonElement>>(JsonAnimationUtils.getObjectListAsArray(custom_instructions));
    }

    private static JsonElement getObjectByKey(Set<Map.Entry<String, JsonElement>> json, String key) throws class_2973 {
        return (JsonElement)json.stream().filter(x -> ((String)x.getKey()).equals(key)).findFirst().orElseThrow(() -> new class_2973("Could not find key: " + key)).getValue();
    }

    public static Map.Entry<String, JsonElement> getAnimation(JsonObject animationFile, String animationName) throws class_2973 {
        return new AbstractMap.SimpleEntry<String, JsonElement>(animationName, JsonAnimationUtils.getObjectByKey(JsonAnimationUtils.getAnimations(animationFile), animationName));
    }

    public static Set<Map.Entry<String, JsonElement>> getObjectListAsArray(JsonObject json) {
        return json.entrySet();
    }

    public static Animation deserializeJsonToAnimation(Map.Entry<String, JsonElement> element) throws ClassCastException, IllegalStateException {
        ArrayList<Map.Entry<String, JsonElement>> arrayList;
        ArrayList<Map.Entry<String, JsonElement>> particleKeyFrames;
        Animation animation = new Animation();
        JsonObject animationJsonObject = element.getValue().getAsJsonObject();
        animation.animationName = element.getKey();
        JsonElement animation_length = animationJsonObject.get("animation_length");
        animation.animationLength = AnimationUtils.convertSecondsToTicks(animation_length == null ? 0.01 : animation_length.getAsDouble());
        animation.boneAnimations = new ArrayList<BoneAnimation>();
        JsonElement loop = animationJsonObject.get("loop");
        animation.loop = loop != null && loop.getAsBoolean();
        ArrayList<Map.Entry<String, JsonElement>> soundEffectFrames = JsonAnimationUtils.getSoundEffectFrames(animationJsonObject);
        if (soundEffectFrames != null) {
            for (Map.Entry<String, JsonElement> entry : soundEffectFrames) {
                animation.soundKeyFrames.add(new EventKeyFrame<String>(Double.parseDouble(entry.getKey()) * 20.0, entry.getValue().getAsJsonObject().get("effect").getAsString()));
            }
        }
        if ((particleKeyFrames = JsonAnimationUtils.getParticleEffectFrames(animationJsonObject)) != null) {
            for (Map.Entry<String, JsonElement> entry : particleKeyFrames) {
                JsonObject jsonObject = entry.getValue().getAsJsonObject();
                JsonElement effect = jsonObject.get("effect");
                JsonElement locator = jsonObject.get("locator");
                JsonElement pre_effect_script = jsonObject.get("pre_effect_script");
                animation.particleKeyFrames.add(new ParticleEventKeyFrame(Double.parseDouble(entry.getKey()) * 20.0, effect == null ? "" : effect.getAsString(), locator == null ? "" : locator.getAsString(), pre_effect_script == null ? "" : pre_effect_script.getAsString()));
            }
        }
        if ((arrayList = JsonAnimationUtils.getCustomInstructionKeyFrames(animationJsonObject)) != null) {
            for (Map.Entry<String, JsonElement> entry : arrayList) {
                animation.customInstructionKeyframes.add(new EventKeyFrame<List<Double>>(Double.parseDouble(entry.getKey()) * 20.0, JsonAnimationUtils.convertJsonArrayToList(entry.getValue().getAsJsonArray())));
            }
        }
        List<Map.Entry<String, JsonElement>> list = JsonAnimationUtils.getBones(animationJsonObject);
        for (Map.Entry<String, JsonElement> bone : list) {
            BoneAnimation boneAnimation = new BoneAnimation();
            boneAnimation.boneName = bone.getKey();
            JsonObject boneJsonObj = bone.getValue().getAsJsonObject();
            try {
                Set<Map.Entry<String, JsonElement>> scaleKeyFramesJson = JsonAnimationUtils.getScaleKeyFrames(boneJsonObj);
                boneAnimation.scaleKeyFrames = JsonKeyFrameUtils.convertJsonToKeyFrames(new ArrayList<Map.Entry<String, JsonElement>>(scaleKeyFramesJson));
            }
            catch (Exception e) {
                boneAnimation.scaleKeyFrames = new VectorKeyFrameList();
            }
            try {
                Set<Map.Entry<String, JsonElement>> positionKeyFramesJson = JsonAnimationUtils.getPositionKeyFrames(boneJsonObj);
                boneAnimation.positionKeyFrames = JsonKeyFrameUtils.convertJsonToKeyFrames(new ArrayList<Map.Entry<String, JsonElement>>(positionKeyFramesJson));
            }
            catch (Exception e) {
                boneAnimation.positionKeyFrames = new VectorKeyFrameList();
            }
            try {
                Set<Map.Entry<String, JsonElement>> rotationKeyFramesJson = JsonAnimationUtils.getRotationKeyFrames(boneJsonObj);
                boneAnimation.rotationKeyFrames = JsonKeyFrameUtils.convertJsonToRotationKeyFrames(new ArrayList<Map.Entry<String, JsonElement>>(rotationKeyFramesJson));
            }
            catch (Exception e) {
                boneAnimation.rotationKeyFrames = new VectorKeyFrameList();
            }
            animation.boneAnimations.add(boneAnimation);
        }
        return animation;
    }

    static List<Double> convertJsonArrayToList(JsonArray array) {
        return (List)new Gson().fromJson((JsonElement)array, ArrayList.class);
    }
}

