/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.animation.keyframe.KeyFrame;
import software.bernie.geckolib.animation.keyframe.VectorKeyFrameList;
import software.bernie.geckolib.easing.EasingType;
import software.bernie.geckolib.util.AnimationUtils;
import software.bernie.geckolib.util.json.JsonAnimationUtils;

public class JsonKeyFrameUtils {
    private static VectorKeyFrameList<KeyFrame<Double>> convertJson(List<Map.Entry<String, JsonElement>> element, boolean isRotation) throws NumberFormatException {
        Double previousXValue = null;
        Double previousYValue = null;
        Double previousZValue = null;
        ArrayList<KeyFrame<Double>> xKeyFrames = new ArrayList<KeyFrame<Double>>();
        ArrayList<KeyFrame<Double>> yKeyFrames = new ArrayList<KeyFrame<Double>>();
        ArrayList<KeyFrame<Double>> zKeyFrames = new ArrayList<KeyFrame<Double>>();
        for (int i = 0; i < element.size(); ++i) {
            KeyFrame<Double> zKeyFrame;
            KeyFrame<Double> yKeyFrame;
            KeyFrame<Double> xKeyFrame;
            double currentZValue;
            Map.Entry<String, JsonElement> keyframe = element.get(i);
            Map.Entry<String, JsonElement> previousKeyFrame = i == 0 ? null : element.get(i - 1);
            double previousKeyFrameLocation = previousKeyFrame == null ? 0.0 : Double.parseDouble(previousKeyFrame.getKey());
            double currentKeyFrameLocation = Double.parseDouble(keyframe.getKey());
            double animationTimeDifference = currentKeyFrameLocation - previousKeyFrameLocation;
            JsonArray vectorJsonArray = JsonKeyFrameUtils.getKeyFrameVector(keyframe.getValue());
            float double1 = vectorJsonArray.get(0).getAsFloat();
            float double2 = vectorJsonArray.get(1).getAsFloat();
            float double3 = vectorJsonArray.get(2).getAsFloat();
            double currentXValue = isRotation ? (double)((float)Math.toRadians(double1)) : (double)double1;
            double currentYValue = isRotation ? (double)((float)Math.toRadians(double2)) : (double)double2;
            double d = currentZValue = isRotation ? (double)((float)Math.toRadians(double3)) : (double)double3;
            if (keyframe.getValue().isJsonObject() && JsonKeyFrameUtils.hasEasingType(keyframe.getValue())) {
                EasingType easingType = JsonKeyFrameUtils.getEasingType(keyframe.getValue());
                if (JsonKeyFrameUtils.hasEasingArgs(keyframe.getValue())) {
                    List<Double> easingArgs = JsonKeyFrameUtils.getEasingArgs(keyframe.getValue());
                    xKeyFrame = new KeyFrame<Double>(AnimationUtils.convertSecondsToTicks(animationTimeDifference), i == 0 ? currentXValue : previousXValue, currentXValue, easingType, easingArgs);
                    yKeyFrame = new KeyFrame<Double>(AnimationUtils.convertSecondsToTicks(animationTimeDifference), i == 0 ? currentYValue : previousYValue, currentYValue, easingType, easingArgs);
                    zKeyFrame = new KeyFrame<Double>(AnimationUtils.convertSecondsToTicks(animationTimeDifference), i == 0 ? currentZValue : previousZValue, currentZValue, easingType, easingArgs);
                } else {
                    xKeyFrame = new KeyFrame<Double>(AnimationUtils.convertSecondsToTicks(animationTimeDifference), i == 0 ? currentXValue : previousXValue, currentXValue, easingType);
                    yKeyFrame = new KeyFrame<Double>(AnimationUtils.convertSecondsToTicks(animationTimeDifference), i == 0 ? currentYValue : previousYValue, currentYValue, easingType);
                    zKeyFrame = new KeyFrame<Double>(AnimationUtils.convertSecondsToTicks(animationTimeDifference), i == 0 ? currentZValue : previousZValue, currentZValue, easingType);
                }
            } else {
                xKeyFrame = new KeyFrame<Double>(AnimationUtils.convertSecondsToTicks(animationTimeDifference), i == 0 ? currentXValue : previousXValue, currentXValue);
                yKeyFrame = new KeyFrame<Double>(AnimationUtils.convertSecondsToTicks(animationTimeDifference), i == 0 ? currentYValue : previousYValue, currentYValue);
                zKeyFrame = new KeyFrame<Double>(AnimationUtils.convertSecondsToTicks(animationTimeDifference), i == 0 ? currentZValue : previousZValue, currentZValue);
            }
            previousXValue = currentXValue;
            previousYValue = currentYValue;
            previousZValue = currentZValue;
            xKeyFrames.add(xKeyFrame);
            yKeyFrames.add(yKeyFrame);
            zKeyFrames.add(zKeyFrame);
        }
        return new VectorKeyFrameList<KeyFrame<Double>>(xKeyFrames, yKeyFrames, zKeyFrames);
    }

    private static JsonArray getKeyFrameVector(JsonElement element) {
        if (element.isJsonArray()) {
            return element.getAsJsonArray();
        }
        return element.getAsJsonObject().get("vector").getAsJsonArray();
    }

    private static boolean hasEasingType(JsonElement element) {
        return element.getAsJsonObject().has("easing");
    }

    private static boolean hasEasingArgs(JsonElement element) {
        return element.getAsJsonObject().has("easingArgs");
    }

    private static EasingType getEasingType(JsonElement element) {
        String easingString = element.getAsJsonObject().get("easing").getAsString();
        try {
            String uppercaseEasingString = Character.toUpperCase(easingString.charAt(0)) + easingString.substring(1);
            EasingType easing = EasingType.valueOf(uppercaseEasingString);
            return easing;
        }
        catch (Exception e) {
            GeckoLib.LOGGER.fatal("Unknown easing type: " + easingString);
            throw new RuntimeException(e);
        }
    }

    private static List<Double> getEasingArgs(JsonElement element) {
        JsonObject asJsonObject = element.getAsJsonObject();
        JsonElement easingArgs = asJsonObject.get("easingArgs");
        JsonArray asJsonArray = easingArgs.getAsJsonArray();
        return JsonAnimationUtils.convertJsonArrayToList(asJsonArray);
    }

    public static VectorKeyFrameList<KeyFrame<Double>> convertJsonToKeyFrames(List<Map.Entry<String, JsonElement>> element) throws NumberFormatException {
        return JsonKeyFrameUtils.convertJson(element, false);
    }

    public static VectorKeyFrameList<KeyFrame<Double>> convertJsonToRotationKeyFrames(List<Map.Entry<String, JsonElement>> element) throws NumberFormatException {
        VectorKeyFrameList<KeyFrame<Double>> frameList = JsonKeyFrameUtils.convertJson(element, true);
        return new VectorKeyFrameList<KeyFrame<Double>>(frameList.xKeyFrames, frameList.yKeyFrames, frameList.zKeyFrames);
    }
}

