/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy;

import com.bonfyre.fantasy.config.FantasyConfig;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="fantasy")
public class Fantasy {
    private static final Logger logger = LogManager.getLogger();
    public static final String MOD_ID = "fantasy";

    public Fantasy() {
        FantasyConfig.buildSpec();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, FantasyConfig.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        logger.info("setup");
    }

    private void clientSetup(FMLClientSetupEvent event) {
        logger.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            logger.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        logger.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }
}

