/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy;

import com.bonfyre.fantasy.core.entity.EntityId;
import com.bonfyre.fantasy.core.reflection.ReflectionEngine;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Registry {
    private static final Logger logger = LogManager.getLogger();
    private static final ReflectionEngine REFLECTION_ENGINE = new ReflectionEngine("com.bonfyre.fantasy");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"fantasy");
    private static Map<EntityId<?>, RegistryObject<EntityType<?>>> entityTypes;
    public static final DeferredRegister<ParticleType<?>> PARTICLES;
    private static Map<String, RegistryObject<? extends ParticleType<?>>> particleEntries;
    public static final DeferredRegister<Item> ITEMS;
    public static final DeferredRegister<Effect> POTIONS;
    public static final DeferredRegister<SoundEvent> SOUNDS;

    public static ReflectionEngine getReflections() {
        return REFLECTION_ENGINE;
    }

    public static <T extends Entity> void registerEntity(EntityId<String> id, EntityType.Builder<T> builder) {
        entityTypes.put(id, ENTITIES.register(id.get(), () -> builder.func_206830_a((String)id.get())));
    }

    public static <T extends Entity> EntityType<T> findEntityType(EntityId<?> id) {
        RegistryObject<EntityType<?>> registryObject = entityTypes.get(id);
        return registryObject != null ? (EntityType)registryObject.get() : null;
    }

    public static Map<EntityId<?>, RegistryObject<EntityType<?>>> getEntityTypes() {
        return entityTypes;
    }

    public static Map<String, RegistryObject<? extends ParticleType<?>>> getParticleEntries() {
        return particleEntries;
    }

    public static <T extends ParticleType<?>> RegistryObject<T> addParticleEntry(String id, Supplier<? extends T> sup) {
        RegistryObject registryObject = PARTICLES.register(id, sup);
        particleEntries.put(id, registryObject);
        return registryObject;
    }

    static {
        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        entityTypes = new ConcurrentHashMap();
        PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"fantasy");
        PARTICLES.register(FMLJavaModLoadingContext.get().getModEventBus());
        particleEntries = new LinkedHashMap();
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"fantasy");
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        POTIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"fantasy");
        POTIONS.register(FMLJavaModLoadingContext.get().getModEventBus());
        SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"fantasy");
        SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

