/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.client;

import com.bonfyre.fantasy.Registry;
import com.bonfyre.fantasy.core.entity.EntityId;
import com.bonfyre.fantasy.mounts.item.SpawnEggItem;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientLoader {
    private static final Logger logger = LogManager.getLogger();

    public static <T extends Entity> void registerEntity(EntityId<?> entityId, IRenderFactory<T> factory) {
        RenderingRegistry.registerEntityRenderingHandler(Registry.findEntityType(entityId), factory);
    }

    public static <T extends IParticleData> void registerParticle(ParticleType<T> particleType, ParticleManager.IParticleMetaFactory<T> particleMetaFactory) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a(particleType, particleMetaFactory);
    }

    public static <T extends IParticleData, P extends ParticleType<?>> void registerParticle(Map<?, RegistryObject<P>> particleTypeMap, ParticleManager.IParticleMetaFactory<T> particleMetaFactory) {
        particleTypeMap.forEach((o, registryObject) -> Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)registryObject.get(), particleMetaFactory));
    }

    public static void loadSpawnEgg(SpawnEggItem item) {
        Minecraft.func_71410_x().getItemColors().func_199877_a((stack, color) -> item.getColor(color), new IItemProvider[]{item});
    }
}

