/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.client.particle;

import com.bonfyre.fantasy.client.ClientLoader;
import com.bonfyre.fantasy.core.draw.Color;
import com.bonfyre.fantasy.particle.GlimmerParticleType;
import com.bonfyre.fantasy.particle.Particles;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class GlimmerParticle
extends SpriteTexturedParticle {
    private final Integer brightness;

    @SubscribeEvent
    public static void onRegisterParticle(ParticleFactoryRegisterEvent event) {
        ClientLoader.registerParticle(Particles.UNICORN_GLIMMER, Factory::new);
    }

    private GlimmerParticle(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, Color color, Integer brightness) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.field_187129_i *= (double)0.1f;
        this.field_187130_j *= (double)0.1f;
        this.field_187131_k *= (double)0.1f;
        this.field_187129_i += motionX * 0.4;
        this.field_187130_j += motionY * 0.4;
        this.field_187131_k += motionZ * 0.4;
        float f = (float)(Math.random() * (double)0.3f + (double)0.6f);
        this.field_70552_h = color.getRed();
        this.field_70553_i = color.getGreen();
        this.field_70551_j = color.getBlue();
        this.field_82339_as = color.getAlpha();
        this.field_70544_f *= 0.3f;
        this.brightness = brightness;
        this.field_70547_e = Math.max((int)(6.0 / (Math.random() * 0.8 + 0.6)), 1);
        this.field_190017_n = false;
        this.func_189213_a();
    }

    public float func_217561_b(float scaleFactor) {
        return this.field_70544_f * MathHelper.func_76131_a((float)(((float)this.field_70546_d + scaleFactor) / (float)this.field_70547_e * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        } else {
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_70553_i = (float)((double)this.field_70553_i * 0.96);
            this.field_70551_j = (float)((double)this.field_70551_j * 0.9);
            this.field_187129_i *= (double)0.7f;
            this.field_187130_j *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
            this.field_187130_j -= (double)0.02f;
            if (this.field_187132_l) {
                this.field_187129_i *= (double)0.7f;
                this.field_187131_k *= (double)0.7f;
            }
        }
    }

    public int func_189214_a(float partialTick) {
        if (this.brightness == null) {
            int i = super.func_189214_a(partialTick);
            float f = (float)this.field_70546_d / (float)this.field_70547_e;
            f *= f;
            f *= f;
            int j = i & 0xFF;
            int k = i >> 16 & 0xFF;
            if ((k += (int)(f * 15.0f * 16.0f)) > 240) {
                k = 240;
            }
            return j | k << 16;
        }
        return this.brightness;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<GlimmerParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(GlimmerParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            GlimmerParticle particle = new GlimmerParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getColor(), typeIn.getBrightness());
            particle.func_217568_a(this.spriteSet);
            return particle;
        }
    }
}

