/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.client.particle;

import com.bonfyre.fantasy.client.ClientLoader;
import com.bonfyre.fantasy.core.draw.Color;
import com.bonfyre.fantasy.core.util.RandomUtil;
import com.bonfyre.fantasy.particle.Particles;
import com.bonfyre.fantasy.particle.RainParticleType;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.world.ClientWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class RainParticle
extends SpriteTexturedParticle {
    private final double targetPosX;
    private final double targetPosY;
    private final double targetPosZ;

    @SubscribeEvent
    public static void onRegisterParticle(ParticleFactoryRegisterEvent event) {
        ClientLoader.registerParticle(Particles.UNICORN_RAIN, Factory::new);
    }

    protected RainParticle(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ, Color color, float colorLow, float colorHigh) {
        super(world, x, y, z);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.field_187126_f = x;
        this.field_187127_g = y;
        this.field_187128_h = z;
        this.targetPosX = this.field_187126_f;
        this.targetPosY = this.field_187127_g;
        this.targetPosZ = this.field_187128_h;
        this.field_70544_f = 0.1f * (this.field_187136_p.nextFloat() * 0.2f + 0.35f);
        float f = RandomUtil.randFloat(this.field_187136_p, colorLow, colorHigh);
        this.field_70552_h = f + color.getRed();
        this.field_70553_i = f + color.getGreen();
        this.field_70551_j = f + color.getBlue();
        this.field_82339_as = color.getAlpha();
        this.field_70547_e = (int)(Math.random() * 10.0) + 40;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public float func_217561_b(float scaleFactor) {
        float f = ((float)this.field_70546_d + scaleFactor) / (float)this.field_70547_e;
        f = 1.0f - f;
        f *= f;
        f = 1.0f - f;
        return this.field_70544_f * f;
    }

    public int func_189214_a(float partialTick) {
        int i = super.func_189214_a(partialTick);
        float f = (float)this.field_70546_d / (float)this.field_70547_e;
        f *= f;
        f *= f;
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((k += (int)(f * 15.0f * 16.0f)) > 240) {
            k = 240;
        }
        return j | k << 16;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        } else {
            float f = (float)this.field_70546_d / (float)this.field_70547_e;
            float f1 = -f + f * f * 2.0f;
            float f2 = 1.0f - f1;
            this.field_187126_f = this.targetPosX + this.field_187129_i * (double)f2;
            this.field_187127_g = this.targetPosY + this.field_187130_j * (double)f2 + (double)(1.0f - f);
            this.field_187128_h = this.targetPosZ + this.field_187131_k * (double)f2;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<RainParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(RainParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            RainParticle particle = new RainParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getColor(), typeIn.getColorLow(), typeIn.getColorHigh());
            particle.func_217568_a(this.spriteSet);
            return particle;
        }
    }
}

