/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class RenderEffects {
    protected static final RenderState.TransparencyState NO_TRANSPARENCY = new RenderState.TransparencyState("no_transparency", RenderSystem::disableBlend, () -> {});
    protected static final RenderState.TransparencyState ADDITIVE_TRANSPARENCY = new RenderState.TransparencyState("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState LIGHTNING_TRANSPARENCY = new RenderState.TransparencyState("lightning_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState GLINT_TRANSPARENCY = new RenderState.TransparencyState("glint_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState CRUMBLING_TRANSPARENCY = new RenderState.TransparencyState("crumbling_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.AlphaState ZERO_ALPHA = new RenderState.AlphaState(0.0f);
    protected static final RenderState.AlphaState DEFAULT_ALPHA = new RenderState.AlphaState(0.003921569f);
    protected static final RenderState.AlphaState HALF_ALPHA = new RenderState.AlphaState(0.5f);
    protected static final RenderState.ShadeModelState SHADE_DISABLED = new RenderState.ShadeModelState(false);
    protected static final RenderState.ShadeModelState SHADE_ENABLED = new RenderState.ShadeModelState(true);
    protected static final RenderState.TextureState BLOCK_SHEET_MIPPED = new RenderState.TextureState(AtlasTexture.field_110575_b, false, true);
    protected static final RenderState.TextureState BLOCK_SHEET = new RenderState.TextureState(AtlasTexture.field_110575_b, false, false);
    protected static final RenderState.TextureState NO_TEXTURE = new RenderState.TextureState();
    protected static final RenderState.TexturingState DEFAULT_TEXTURING = new RenderState.TexturingState("default_texturing", () -> {}, () -> {});
    protected static final RenderState.TexturingState OUTLINE_TEXTURING = new RenderState.TexturingState("outline_texturing", RenderSystem::setupOutline, RenderSystem::teardownOutline);
    protected static final RenderState.TexturingState GLINT_TEXTURING = new RenderState.TexturingState("glint_texturing", () -> RenderEffects.setupGlintTexturing(8.0f), () -> {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
    });
    protected static final RenderState.TexturingState ENTITY_GLINT_TEXTURING = new RenderState.TexturingState("entity_glint_texturing", () -> RenderEffects.setupGlintTexturing(0.16f), () -> {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
    });
    protected static final RenderState.LightmapState LIGHTMAP_ENABLED = new RenderState.LightmapState(true);
    protected static final RenderState.LightmapState LIGHTMAP_DISABLED = new RenderState.LightmapState(false);
    protected static final RenderState.OverlayState OVERLAY_ENABLED = new RenderState.OverlayState(true);
    protected static final RenderState.OverlayState OVERLAY_DISABLED = new RenderState.OverlayState(false);
    protected static final RenderState.DiffuseLightingState DIFFUSE_LIGHTING_ENABLED = new RenderState.DiffuseLightingState(true);
    protected static final RenderState.DiffuseLightingState DIFFUSE_LIGHTING_DISABLED = new RenderState.DiffuseLightingState(false);
    protected static final RenderState.CullState CULL_ENABLED = new RenderState.CullState(true);
    protected static final RenderState.CullState CULL_DISABLED = new RenderState.CullState(false);
    protected static final RenderState.DepthTestState DEPTH_ALWAYS = new RenderState.DepthTestState("always", 519);
    protected static final RenderState.DepthTestState DEPTH_EQUAL = new RenderState.DepthTestState("==", 514);
    protected static final RenderState.DepthTestState DEPTH_LEQUAL = new RenderState.DepthTestState("<=", 515);
    protected static final RenderState.WriteMaskState COLOR_DEPTH_WRITE = new RenderState.WriteMaskState(true, true);
    protected static final RenderState.WriteMaskState COLOR_WRITE = new RenderState.WriteMaskState(true, false);
    protected static final RenderState.WriteMaskState DEPTH_WRITE = new RenderState.WriteMaskState(false, true);
    protected static final RenderState.LayerState NO_LAYERING = new RenderState.LayerState("no_layering", () -> {}, () -> {});
    protected static final RenderState.LayerState POLYGON_OFFSET_LAYERING = new RenderState.LayerState("polygon_offset_layering", () -> {
        RenderSystem.polygonOffset((float)-1.0f, (float)-10.0f);
        RenderSystem.enablePolygonOffset();
    }, () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
    });
    protected static final RenderState.LayerState field_239235_M_ = new RenderState.LayerState("view_offset_z_layering", () -> {
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)0.99975586f, (float)0.99975586f, (float)0.99975586f);
    }, RenderSystem::popMatrix);
    protected static final RenderState.FogState NO_FOG = new RenderState.FogState("no_fog", () -> {}, () -> {});
    protected static final RenderState.FogState FOG = new RenderState.FogState("fog", () -> {
        FogRenderer.func_228373_b_();
        RenderSystem.enableFog();
    }, () -> RenderSystem.disableFog());
    protected static final RenderState.FogState BLACK_FOG = new RenderState.FogState("black_fog", () -> {
        RenderSystem.fog((int)2918, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.enableFog();
    }, () -> {
        FogRenderer.func_228373_b_();
        RenderSystem.disableFog();
    });
    protected static final RenderState.TargetState MAIN_TARGET = new RenderState.TargetState("main_target", () -> {}, () -> {});
    protected static final RenderState.TargetState OUTLINE_TARGET = new RenderState.TargetState("outline_target", () -> Minecraft.func_71410_x().field_71438_f.func_228448_p_().func_147610_a(false), () -> Minecraft.func_71410_x().func_147110_a().func_147610_a(false));
    protected static final RenderState.TargetState TRANSLUCENT_TARGET = new RenderState.TargetState("translucent_target", () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().field_71438_f.func_239228_q_().func_147610_a(false);
        }
    }, () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
    });
    protected static final RenderState.TargetState PARTICLES_TARGET = new RenderState.TargetState("particles_target", () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().field_71438_f.func_239230_s_().func_147610_a(false);
        }
    }, () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
    });
    protected static final RenderState.TargetState WEATHER_TARGET = new RenderState.TargetState("weather_target", () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().field_71438_f.func_239231_t_().func_147610_a(false);
        }
    }, () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
    });
    protected static final RenderState.TargetState CLOUDS_TARGET = new RenderState.TargetState("clouds_target", () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().field_71438_f.func_239232_u_().func_147610_a(false);
        }
    }, () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
    });
    protected static final RenderState.TargetState ITEM_ENTITY_TARGET = new RenderState.TargetState("item_entity_target", () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().field_71438_f.func_239229_r_().func_147610_a(false);
        }
    }, () -> {
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
    });
    protected static final RenderState.LineState DEFAULT_LINE = new RenderState.LineState(OptionalDouble.of(1.0));

    public static RenderType getUnicornHorn(ResourceLocation locationIn) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228727_a_(COLOR_WRITE).func_228717_a_(NO_FOG).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228728_a_(false);
        return RenderType.func_228633_a_((String)"beacon_beam", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)state);
    }

    private static void setupGlintTexturing(float scaleIn) {
        RenderSystem.matrixMode((int)5890);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        long i = Util.func_211177_b() * 8L;
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        RenderSystem.translatef((float)(-f), (float)f1, (float)0.0f);
        RenderSystem.rotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.scalef((float)scaleIn, (float)scaleIn, (float)scaleIn);
        RenderSystem.matrixMode((int)5888);
    }
}

