/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.core.effect;

import com.bonfyre.fantasy.core.effect.EffectProperties;
import com.bonfyre.fantasy.core.effect.EffectPropertyKey;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractEffect
extends Effect
implements EffectProperties {
    private Map<EffectPropertyKey<?>, Object> properties = new HashMap();
    public static final ResourceLocation ICON_BG = new ResourceLocation("fantasy", "textures/effect/bg.png");
    private ResourceLocation iconTexture;

    public AbstractEffect(EffectType typeIn, int liquidColorIn, ResourceLocation iconTexture) {
        super(typeIn, liquidColorIn);
        this.iconTexture = iconTexture;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventoryEffect(EffectInstance effect, DisplayEffectsScreen<?> gui, MatrixStack mStack, int x, int y, float z) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(ICON_BG);
        AbstractGui.func_238463_a_((MatrixStack)mStack, (int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        textureManager.func_110577_a(this.iconTexture);
        AbstractGui.func_238463_a_((MatrixStack)mStack, (int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUDEffect(EffectInstance effect, AbstractGui gui, MatrixStack mStack, int x, int y, float z, float alpha) {
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        textureManager.func_110577_a(ICON_BG);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        AbstractGui.func_238463_a_((MatrixStack)mStack, (int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
        textureManager.func_110577_a(this.iconTexture);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        AbstractGui.func_238463_a_((MatrixStack)mStack, (int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
    }

    public ResourceLocation getIconTexture() {
        return this.iconTexture;
    }

    public void setIconTexture(ResourceLocation iconTexture) {
        this.iconTexture = iconTexture;
    }

    @Override
    public <T> AbstractEffect addProperty(EffectPropertyKey<T> key, T value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public <T> T getProperty(EffectPropertyKey<T> key) {
        return (T)this.properties.getOrDefault(key, key.defaultValue());
    }

    @Override
    public Map<EffectPropertyKey<?>, Object> getProperties() {
        return this.properties;
    }

    @Override
    public AbstractEffect setProperties(Map<EffectPropertyKey<?>, Object> properties) {
        this.properties = properties;
        return this;
    }
}

