/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.core.world;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldUtil {
    private static final Logger logger = LogManager.getLogger();

    public static Entity findEntityByUuid(UUID entityUuid, Entity fromEntity) {
        return WorldUtil.findEntityByUuid(entityUuid, (IWorld)fromEntity.func_130014_f_(), fromEntity.func_233580_cy_(), 2000);
    }

    public static Entity findEntityByUuid(UUID entityUuid, Entity fromEntity, int searchDistance) {
        return WorldUtil.findEntityByUuid(entityUuid, (IWorld)fromEntity.func_130014_f_(), fromEntity.func_233580_cy_(), searchDistance);
    }

    public static Entity findEntityByUuid(UUID entityUuid, IWorld world, BlockPos fromPos) {
        return WorldUtil.findEntityByUuid(entityUuid, world, fromPos, 2000);
    }

    public static Entity findEntityByUuid(UUID entityUuid, IWorld world, BlockPos fromPos, int searchDistance) {
        double z;
        double y;
        double x = fromPos.func_177958_n();
        AxisAlignedBB scanBox = new AxisAlignedBB(x - (double)searchDistance, (y = (double)fromPos.func_177956_o()) - (double)searchDistance, (z = (double)fromPos.func_177952_p()) - (double)searchDistance, x + (double)searchDistance, y + (double)searchDistance, z + (double)searchDistance);
        List entities = world.func_175647_a(AbstractHorseEntity.class, scanBox, entity -> entity.func_110124_au().equals(entityUuid));
        if (entities.size() < 1) {
            return null;
        }
        if (entities.size() > 1) {
            logger.warn("Found more than one entity with the UUID '" + entityUuid.toString() + "', returning the first");
        }
        return (Entity)entities.get(0);
    }
}

