/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.mounts.client.renderer.config;

import com.bonfyre.fantasy.mounts.client.renderer.HorseRenderer;
import com.bonfyre.fantasy.mounts.client.renderer.layers.HorseMarkingsLayer;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.layers.LeatherHorseArmorLayer;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.entity.passive.horse.HorseEntity;

public class HorseRendererConfig<T extends HorseRenderer<?>> {
    protected float scaleIn;
    protected final List<LayerRenderer<HorseEntity, HorseModel<HorseEntity>>> layerRenderers = Lists.newLinkedList();

    public HorseRendererConfig() {
        this(1.1f);
    }

    public HorseRendererConfig(float scaleIn) {
        this.scaleIn = scaleIn;
    }

    public void loadDefaults(HorseRenderer<?> renderer) {
        this.getLayerRenderers().add(new HorseMarkingsLayer((IEntityRenderer<HorseEntity, HorseModel<HorseEntity>>)renderer));
        this.getLayerRenderers().add((LayerRenderer<HorseEntity, HorseModel<HorseEntity>>)new LeatherHorseArmorLayer(renderer));
    }

    public float getScaleIn() {
        return this.scaleIn;
    }

    public HorseRendererConfig<T> setScaleIn(float scaleIn) {
        this.scaleIn = scaleIn;
        return this;
    }

    public List<LayerRenderer<HorseEntity, HorseModel<HorseEntity>>> getLayerRenderers() {
        return this.layerRenderers;
    }
}

