/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.mounts.entity.ai.goal;

import com.bonfyre.fantasy.mounts.item.GoldenWhistle;
import java.util.EnumSet;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class FollowHorseOwnerGoal
extends Goal {
    private AbstractHorseEntity horseEntity;
    private LivingEntity owner;
    private PathNavigator navigator;
    private World world;
    private final double followSpeed;
    private int timeToRecalcPath;
    private final float maxDist;
    private final float minDist;
    private float oldWaterCost;
    private final boolean teleportToLeaves;
    private boolean enabled;
    private boolean running;
    private Deregister deregister;
    private Predicate<FollowHorseOwnerGoal> predicate;

    public FollowHorseOwnerGoal(AbstractHorseEntity horseEntity, double speed, float minDist, float maxDist, boolean teleportToLeaves, Deregister deregister) {
        this(horseEntity, speed, minDist, maxDist, teleportToLeaves, deregister, null);
    }

    public FollowHorseOwnerGoal(AbstractHorseEntity horseEntity, double speed, float minDist, float maxDist, boolean teleportToLeaves, Deregister deregister, Predicate<FollowHorseOwnerGoal> predicate) {
        this.setHorseEntity(horseEntity);
        this.followSpeed = speed;
        this.minDist = minDist;
        this.maxDist = maxDist;
        this.teleportToLeaves = teleportToLeaves;
        this.deregister = deregister;
        this.predicate = predicate;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        UUID ownerUuid = this.horseEntity.func_184780_dh();
        if (ownerUuid == null) {
            return false;
        }
        if (this.owner == null) {
            this.owner = this.world.func_217371_b(ownerUuid);
        }
        return this.func_75253_b();
    }

    public boolean func_75253_b() {
        this.running = this.canExecute();
        return this.running && this.horseEntity.func_70068_e((Entity)this.owner) <= (double)(this.maxDist * this.maxDist) && this.horseEntity.func_70068_e((Entity)this.owner) >= (double)(this.minDist * this.minDist);
    }

    protected boolean canExecute() {
        if (!this.enabled) {
            return false;
        }
        if (this.owner == null) {
            return false;
        }
        if (this.owner.func_175149_v()) {
            return false;
        }
        if (this.horseEntity.func_110167_bD()) {
            this.enabled = false;
            return false;
        }
        if (Objects.equals(this.horseEntity.func_184179_bs(), this.owner)) {
            return false;
        }
        if (this.horseEntity.func_110205_ce()) {
            this.enabled = false;
            return false;
        }
        if (this.horseEntity.func_110209_cd()) {
            return false;
        }
        ItemStack heldStack = this.owner.func_184586_b(Hand.MAIN_HAND);
        if (heldStack.equals(ItemStack.field_190927_a) || !(heldStack.func_77973_b() instanceof GoldenWhistle)) {
            heldStack = this.owner.func_184586_b(Hand.OFF_HAND);
        }
        if (heldStack.equals(ItemStack.field_190927_a) || !(heldStack.func_77973_b() instanceof GoldenWhistle)) {
            return false;
        }
        return this.predicate == null || this.predicate.test(this);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.horseEntity.func_184643_a(PathNodeType.WATER);
        this.horseEntity.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.navigator.func_75499_g();
        this.horseEntity.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.horseEntity.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.horseEntity.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.horseEntity.func_110167_bD() && !this.horseEntity.func_184218_aH()) {
                if (this.horseEntity.func_70068_e((Entity)this.owner) >= 144.0) {
                    this.tryToTeleportNearEntity();
                } else {
                    this.navigator.func_75497_a((Entity)this.owner, this.followSpeed);
                }
            }
        }
    }

    private void tryToTeleportNearEntity() {
        BlockPos blockpos = this.owner.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomNumber(-3, 3);
            int k = this.getRandomNumber(-1, 1);
            int l = this.getRandomNumber(-3, 3);
            boolean flag = this.tryToTeleportToLocation(blockpos.func_177958_n() + j, blockpos.func_177956_o() + k, blockpos.func_177952_p() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean tryToTeleportToLocation(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.func_226277_ct_()) < 2.0 && Math.abs((double)z - this.owner.func_226281_cx_()) < 2.0) {
            return false;
        }
        if (!this.isTeleportFriendlyBlock(new BlockPos(x, y, z))) {
            return false;
        }
        this.horseEntity.func_70012_b((double)x + 0.5, (double)y, (double)z + 0.5, this.horseEntity.field_70177_z, this.horseEntity.field_70125_A);
        this.navigator.func_75499_g();
        return true;
    }

    private boolean isTeleportFriendlyBlock(BlockPos pos) {
        PathNodeType pathnodetype = WalkNodeProcessor.func_237231_a_((IBlockReader)this.world, (BlockPos.Mutable)pos.func_239590_i_());
        if (pathnodetype != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.func_180495_p(pos.func_177977_b());
        if (!this.teleportToLeaves && blockstate.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.func_177973_b((Vector3i)this.horseEntity.func_233580_cy_());
        return this.world.func_226665_a__((Entity)this.horseEntity, this.horseEntity.func_174813_aQ().func_186670_a(blockpos));
    }

    private int getRandomNumber(int min, int max) {
        return this.horseEntity.func_70681_au().nextInt(max - min + 1) + min;
    }

    public void setHorseEntity(AbstractHorseEntity horseEntity) {
        if (!(horseEntity.func_70661_as() instanceof GroundPathNavigator) && !(horseEntity.func_70661_as() instanceof FlyingPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
        this.horseEntity = horseEntity;
        this.navigator = horseEntity.func_70661_as();
        this.world = horseEntity.field_70170_p;
    }

    public AbstractHorseEntity getHorseEntity() {
        return this.horseEntity;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    public LivingEntity getOwner() {
        return this.owner;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean deregister() {
        if (this.deregister != null) {
            return this.deregister.deregister(this);
        }
        return false;
    }

    public static interface Deregister {
        public boolean deregister(FollowHorseOwnerGoal var1);
    }
}

