/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.mounts.item;

import com.bonfyre.fantasy.config.ConfigWhistle;
import com.bonfyre.fantasy.core.world.WorldUtil;
import com.bonfyre.fantasy.mounts.entity.ai.goal.FollowHorseOwnerGoal;
import com.bonfyre.fantasy.sound.ModSounds;
import com.bonfyre.fantasy.sound.SoundBuilder;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class GoldenWhistle
extends Item {
    private static final Logger logger = LogManager.getLogger();
    private static final Map<String, FollowHorseOwnerGoal> followGoals = Maps.newConcurrentMap();

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        GoldenWhistle.tryBlockEvent((LivingEvent)event);
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        GoldenWhistle.tryBlockEvent((LivingEvent)event);
    }

    public static boolean tryBlockEvent(LivingEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof AbstractHorseEntity && ((Boolean)ConfigWhistle.CONFIG.immuneWhileFollowing.get()).booleanValue()) {
            String uuid = entity.func_110124_au().toString();
            FollowHorseOwnerGoal goal = followGoals.get(uuid);
            boolean blocked = goal != null && goal.isEnabled() && goal.isRunning();
            event.setCanceled(blocked);
            return blocked;
        }
        return false;
    }

    public GoldenWhistle(Item.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        boolean hasTagged = stack.func_77942_o();
        if (hasTagged && ((Boolean)ConfigWhistle.CONFIG.allowWhistle.get()).booleanValue()) {
            CompoundNBT compound = stack.func_77978_p();
            try {
                UUID ownerUid = compound.func_186857_a("Owner");
                UUID targetUid = compound.func_186857_a("Target");
                PlayerEntity owner = worldIn.func_217371_b(ownerUid);
                if (owner != null) {
                    Entity target = WorldUtil.findEntityByUuid(targetUid, (Entity)owner);
                    tooltip.add((ITextComponent)new TranslationTextComponent("item.fantasy.golden_whistle.tagged", new Object[]{target.func_200200_C_(), owner.func_200200_C_()}).func_240699_a_(TextFormatting.GRAY));
                    FollowHorseOwnerGoal goal = followGoals.get(targetUid.toString());
                    boolean enabled = goal != null && goal.isEnabled();
                    tooltip.add((ITextComponent)new TranslationTextComponent("item.fantasy.golden_whistle." + (enabled ? "following" : "staying")).func_240699_a_(enabled ? TextFormatting.GREEN : TextFormatting.RED));
                    hasTagged = true;
                }
            }
            catch (IllegalArgumentException ex) {
                logger.debug("Compound UUID not found", (Throwable)ex);
            }
        }
        if (!hasTagged) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.fantasy.golden_whistle.not_tagged").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        UUID targetUuid;
        Entity entity;
        UUID ownerUuid;
        PlayerEntity owner;
        ActionResult result = super.func_77659_a(worldIn, playerIn, handIn);
        if (!result.func_188397_a().equals((Object)ActionResultType.PASS)) {
            return result;
        }
        ItemStack stack = (ItemStack)result.func_188398_b();
        Item item = stack.func_77973_b();
        if (!((Boolean)ConfigWhistle.CONFIG.allowWhistle.get()).booleanValue()) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        if (!(playerIn instanceof ServerPlayerEntity) || !playerIn.func_70089_S()) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        World world = playerIn.field_70170_p;
        if (!(item instanceof GoldenWhistle)) {
            return new ActionResult(ActionResultType.PASS, (Object)stack);
        }
        CompoundNBT compound = stack.func_77978_p();
        if (compound != null && Objects.equals(owner = world.func_217371_b(ownerUuid = compound.func_186857_a("Owner")), playerIn) && (entity = WorldUtil.findEntityByUuid(targetUuid = compound.func_186857_a("Target"), (Entity)playerIn)) instanceof AbstractHorseEntity && entity.func_70089_S()) {
            AbstractHorseEntity horseEntity = (AbstractHorseEntity)entity;
            String uuidStr = targetUuid.toString();
            FollowHorseOwnerGoal goal = followGoals.get(uuidStr);
            if (goal == null) {
                goal = new FollowHorseOwnerGoal(horseEntity, 1.0, 3.0f, ((Float)ConfigWhistle.CONFIG.maxDistance.get()).floatValue(), true, g -> {
                    horseEntity.field_70714_bg.func_85156_a((Goal)g);
                    g.setEnabled(false);
                    g.func_75251_c();
                    FollowHorseOwnerGoal deleted = followGoals.remove(uuidStr);
                    return deleted != null && ((Object)((Object)deleted)).equals((Object)g);
                });
                followGoals.put(uuidStr, goal);
            } else {
                goal.setHorseEntity(horseEntity);
                goal.setOwner((LivingEntity)owner);
                horseEntity.field_70714_bg.func_85156_a((Goal)goal);
            }
            horseEntity.field_70714_bg.func_75776_a(0, (Goal)goal);
            goal.setEnabled(!goal.isEnabled());
            Float volume = (Float)ConfigWhistle.CONFIG.soundVolume.get();
            if (goal.isEnabled()) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("fantasy.whistle.come", new Object[]{entity.func_200200_C_()}), true);
                SoundBuilder.create((SoundEvent)ModSounds.WHISTLE_COME.get()).volume(volume.floatValue() - 0.4f).pitch(1.0f, 0.4f).pos((Entity)playerIn).play((IWorld)world);
            } else {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("fantasy.whistle.stay", new Object[]{entity.func_200200_C_()}), true);
                SoundBuilder.create((SoundEvent)ModSounds.WHISTLE_STAY.get()).volume(volume.floatValue() - 0.2f).pitch(1.0f, 0.4f).pos((Entity)playerIn).play((IWorld)world);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public ActionResultType func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (target.func_70089_S() && ((Boolean)ConfigWhistle.CONFIG.allowWhistle.get()).booleanValue()) {
            boolean canAllocate = false;
            if (playerIn instanceof ServerPlayerEntity) {
                if (target instanceof TameableEntity) {
                    TameableEntity targetTameable = (TameableEntity)target;
                    canAllocate = targetTameable.func_70909_n() && Objects.equals(targetTameable.func_184753_b(), playerIn.func_110124_au());
                } else if (target instanceof AbstractHorseEntity) {
                    AbstractHorseEntity horseEntity = (AbstractHorseEntity)target;
                    boolean bl = canAllocate = horseEntity.func_110248_bS() && Objects.equals(horseEntity.func_184780_dh(), playerIn.func_110124_au());
                }
            }
            if (canAllocate) {
                UUID targetUuid = target.func_110124_au();
                CompoundNBT compound = stack.func_77978_p();
                if (compound != null && compound.func_186855_b("Target")) {
                    UUID uuid = compound.func_186857_a("Target");
                    FollowHorseOwnerGoal goal = followGoals.get(uuid.toString());
                    if (!uuid.equals(targetUuid) && goal != null) {
                        goal.deregister();
                    }
                } else {
                    compound = new CompoundNBT();
                    stack.func_77982_d(compound);
                }
                compound.func_186854_a("Owner", playerIn.func_110124_au());
                compound.func_186854_a("Target", targetUuid);
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("fantasy.whistle.registered", new Object[]{target.func_200200_C_()}), true);
                SoundBuilder.create((SoundEvent)ModSounds.WHISTLE_TAG.get()).volume(((Float)ConfigWhistle.CONFIG.soundVolume.get()).floatValue() + 1.0f).pitch(1.0f, 0.4f).pos((Entity)playerIn).play((IWorld)playerIn.field_70170_p);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    protected boolean isGoalValid(FollowHorseOwnerGoal goal, ItemStack stack) {
        CompoundNBT compound = stack.func_77978_p();
        if (compound == null || !compound.func_186855_b("Target")) {
            return false;
        }
        UUID horseUuid = goal.getHorseEntity().func_110124_au();
        UUID targetUuid = compound.func_186857_a("Target");
        return horseUuid.equals(targetUuid);
    }
}

