/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.mounts.unicorn.entity;

import com.bonfyre.fantasy.Registry;
import com.bonfyre.fantasy.client.ClientLoader;
import com.bonfyre.fantasy.config.ConfigUnicorn;
import com.bonfyre.fantasy.core.HasId;
import com.bonfyre.fantasy.core.entity.EntityId;
import com.bonfyre.fantasy.core.entity.StringEntityId;
import com.bonfyre.fantasy.core.util.RandomUtil;
import com.bonfyre.fantasy.item.ModItems;
import com.bonfyre.fantasy.mounts.client.unicorn.renderer.UnicornRenderer;
import com.bonfyre.fantasy.mounts.entity.HorseEntity;
import com.bonfyre.fantasy.mounts.item.SpawnEggItem;
import com.bonfyre.fantasy.particle.Particles;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.CoatColors;
import net.minecraft.entity.passive.horse.CoatTypes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class UnicornEntity
extends HorseEntity
implements HasId<EntityId<String>> {
    public static final EntityId<String> ID = new StringEntityId("unicorn");
    public static final RegistryObject<SpawnEggItem> SPAWN_EGG = Registry.ITEMS.register("unicorn_spawn_egg", () -> new SpawnEggItem(null, 12623485, 10051392, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
    private static final Map<Item, FoodStats> FOOD = new ConcurrentHashMap<Item, FoodStats>();
    private IParticleData rainParticle;
    private IParticleData glimmerParticle;

    @SubscribeEvent
    public static void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        if (!(event.getCategory().equals((Object)Biome.Category.FOREST) || event.getCategory().equals((Object)Biome.Category.JUNGLE) || event.getCategory().equals((Object)Biome.Category.MUSHROOM) || event.getCategory().equals((Object)Biome.Category.TAIGA) || event.getCategory().equals((Object)Biome.Category.ICY) || event.getCategory().equals((Object)Biome.Category.PLAINS))) {
            return;
        }
        List spawns = event.getSpawns().getSpawner(EntityClassification.CREATURE);
        EntityType unicornType = Registry.findEntityType(ID);
        if (unicornType != null) {
            spawns.add(new MobSpawnInfo.Spawners(unicornType, ((Integer)ConfigUnicorn.CONFIG.spawnWeight.get()).intValue(), ((Integer)ConfigUnicorn.CONFIG.spawnMinCount.get()).intValue(), ((Integer)ConfigUnicorn.CONFIG.spawnMaxCount.get()).intValue()));
        }
    }

    public UnicornEntity(EntityType<? extends UnicornEntity> type, World worldIn) {
        super(type, worldIn);
        if (!FOOD.containsKey(ModItems.DIAMOND_CARROT.get())) {
            FOOD.put((Item)ModItems.DIAMOND_CARROT.get(), new FoodStats(15.0f, 300, 5, true));
        }
    }

    @Override
    public EntityId<String> getId() {
        return ID;
    }

    @Override
    public void setupInitialAttributes() {
        ModifiableAttributeInstance jumpStrAttr;
        ModifiableAttributeInstance moveSpeedAttr;
        super.setupInitialAttributes();
        ModifiableAttributeInstance maxHealthAttr = this.func_110148_a(Attributes.field_233818_a_);
        if (maxHealthAttr != null) {
            maxHealthAttr.func_111128_a(maxHealthAttr.func_111125_b() + 10.0 + (double)this.field_70146_Z.nextInt(8) + (double)RandomUtil.randomInt(this.field_70146_Z, 2, 8));
        }
        if ((moveSpeedAttr = this.func_110148_a(Attributes.field_233821_d_)) != null) {
            moveSpeedAttr.func_111128_a(moveSpeedAttr.func_111125_b() + 0.1 + this.field_70146_Z.nextDouble() * 0.15);
        }
        if ((jumpStrAttr = this.func_110148_a(Attributes.field_233830_m_)) != null) {
            jumpStrAttr.func_111128_a(jumpStrAttr.func_111125_b() + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.15);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            int i;
            if (this.isMovingX() || this.func_213322_ci().field_72450_a > 1.0E-4 || this.func_213322_ci().field_72450_a < -1.0E-4) {
                for (i = 0; i < 5; ++i) {
                    this.field_70170_p.func_195594_a(this.getRainParticle(), this.func_226282_d_(0.5), this.func_226279_cv_() - 0.6, this.func_226287_g_(0.6), this.field_70146_Z.nextDouble() / 10.0, -this.field_70146_Z.nextDouble() / 10.0, this.field_70146_Z.nextDouble() / 10.0);
                }
            }
            for (i = 0; i < 1; ++i) {
                this.field_70170_p.func_195594_a(this.getGlimmerParticle(), this.func_226282_d_(0.5), this.func_226279_cv_() - 0.2, this.func_226287_g_(0.6), this.field_70146_Z.nextDouble() / 10.0, -this.field_70146_Z.nextDouble() / 20.0, this.field_70146_Z.nextDouble() / 10.0);
            }
        }
        super.func_70636_d();
    }

    public IParticleData getRainParticle() {
        if (this.rainParticle == null) {
            this.rainParticle = (IParticleData)Particles.UNICORN_RAIN.get(this.getCoatColor()).get();
        }
        return this.rainParticle;
    }

    public IParticleData getGlimmerParticle() {
        if (this.glimmerParticle == null) {
            this.glimmerParticle = (IParticleData)Particles.UNICORN_GLIMMER.get(this.getCoatColor()).get();
        }
        return this.glimmerParticle;
    }

    public float func_70013_c() {
        return ((Float)ConfigUnicorn.CONFIG.brightness.get()).floatValue();
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ModItems.DIAMOND_CARROT.get() && (Boolean)ConfigUnicorn.CONFIG.allowBreeding.get() != false;
    }

    protected boolean func_190678_b(PlayerEntity player, ItemStack stack) {
        FoodStats foodStats = FOOD.get(stack.func_77973_b());
        if (foodStats == null) {
            return false;
        }
        boolean flag = false;
        float health = foodStats.health;
        int growth = foodStats.growth;
        int temper = foodStats.temper;
        boolean love = foodStats.love;
        if (love && !this.field_70170_p.field_72995_K && this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
            flag = true;
            this.func_146082_f(player);
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && health > 0.0f) {
            this.func_70691_i(health);
            flag = true;
        }
        if (this.func_70631_g_() && growth > 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(growth);
            }
            flag = true;
        }
        if (temper > 0 && (flag || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            flag = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(temper);
            }
        }
        if (flag) {
            this.func_110266_cB();
        }
        return flag;
    }

    public void func_234177_a_(ServerWorld p_234177_1_, AnimalEntity p_234177_2_) {
        if (p_234177_2_ instanceof UnicornEntity) {
            super.func_234177_a_(p_234177_1_, p_234177_2_);
        }
    }

    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity mate) {
        UnicornEntity offspring = null;
        if (mate instanceof UnicornEntity) {
            UnicornEntity unicornMate = (UnicornEntity)mate;
            EntityType entityType = Registry.findEntityType(ID);
            offspring = (UnicornEntity)entityType.func_200721_a((World)serverWorld);
            int i = this.field_70146_Z.nextInt(9);
            CoatColors coatcolors = i < 4 ? this.func_234239_eK_() : (i < 8 ? unicornMate.func_234239_eK_() : (CoatColors)Util.func_240989_a_((Object[])CoatColors.values(), (Random)this.field_70146_Z));
            int j = this.field_70146_Z.nextInt(5);
            CoatTypes coattypes = j < 2 ? this.func_234240_eM_() : (j < 4 ? unicornMate.func_234240_eM_() : (CoatTypes)Util.func_240989_a_((Object[])CoatTypes.values(), (Random)this.field_70146_Z));
            offspring.func_234238_a_(coatcolors, coattypes);
            this.func_190681_a(mate, (AbstractHorseEntity)offspring);
        }
        return offspring;
    }

    protected void func_184594_b(BlockPos pos) {
        if (((Boolean)ConfigUnicorn.CONFIG.allowFrostWalk.get()).booleanValue()) {
            FrostWalkerEnchantment.func_185266_a((LivingEntity)this, (World)this.field_70170_p, (BlockPos)pos, (int)1);
            if (this.func_230295_b_(this.func_233568_aJ_())) {
                this.func_233641_cN_();
            }
            this.func_233642_cO_();
        }
    }

    private static <T extends MobEntity> boolean canUnicornSpawn(EntityType<T> tEntityType, IServerWorld iServerWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return UnicornEntity.func_223316_b(tEntityType, (IWorld)iServerWorld, (SpawnReason)spawnReason, (BlockPos)blockPos, (Random)random) && (Boolean)ConfigUnicorn.CONFIG.allowWildSpawns.get() != false;
    }

    static {
        FOOD.put(Items.field_151015_O, new FoodStats(2.0f, 20, 3));
        FOOD.put(Items.field_151102_aT, new FoodStats(1.0f, 30, 3));
        FOOD.put(Items.field_221807_eN, new FoodStats(20.0f, 180, 0));
        FOOD.put(Items.field_151034_e, new FoodStats(3.0f, 60, 3));
        FOOD.put(Items.field_151153_ao, new FoodStats(10.0f, 240, 10, true));
        FOOD.put(Items.field_196100_at, new FoodStats(10.0f, 240, 10, true));
    }

    public static class FoodStats {
        float health;
        int growth;
        int temper;
        boolean love;

        public FoodStats(float health, int growth, int temper) {
            this.health = health;
            this.growth = growth;
            this.temper = temper;
        }

        public FoodStats(float health, int growth, int temper, boolean love) {
            this.health = health;
            this.growth = growth;
            this.temper = temper;
            this.love = love;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Init {
        @SubscribeEvent
        public static void init(FMLConstructModEvent event) {
            Registry.registerEntity(ID, EntityType.Builder.func_220322_a(UnicornEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).func_233606_a_(10));
        }

        @SubscribeEvent
        public static void setup(FMLCommonSetupEvent event) {
            EntityType entityType = Registry.findEntityType(ID);
            GlobalEntityTypeAttributes.put(entityType, (AttributeModifierMap)UnicornEntity.func_234237_fg_().func_233813_a_());
            EntitySpawnPlacementRegistry.func_209343_a(entityType, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (x$0, x$1, x$2, x$3, x$4) -> UnicornEntity.canUnicornSpawn(x$0, x$1, x$2, x$3, x$4));
            ((SpawnEggItem)SPAWN_EGG.get()).setTypeIn(entityType);
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            ClientLoader.registerEntity(ID, new UnicornRenderer.RenderFactory());
            ClientLoader.loadSpawnEgg((SpawnEggItem)SPAWN_EGG.get());
        }
    }
}

