/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.potion;

import com.bonfyre.fantasy.config.ConfigUnicorn;
import com.bonfyre.fantasy.core.effect.AbstractEffect;
import com.bonfyre.fantasy.core.effect.EffectPropertyKey;
import com.bonfyre.fantasy.core.effect.EffectUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GlowingVisionEffect
extends AbstractEffect {
    public static final EffectPropertyKey<Class<? extends Entity>> TARGET_PROP = new EffectPropertyKey<Class<Entity>>(Entity.class);
    public static final EffectPropertyKey<Integer> SECONDS_PROP = new EffectPropertyKey<Integer>(10);

    public GlowingVisionEffect(Class<? extends Entity> glowTarget) {
        super(EffectType.BENEFICIAL, 8356754, new ResourceLocation("fantasy", "textures/effect/glowing_vision.png"));
        this.addProperty((EffectPropertyKey)TARGET_PROP, glowTarget);
    }

    public void func_76394_a(LivingEntity entityLiving, int amplifier) {
        if (!((Boolean)ConfigUnicorn.CONFIG.allowGlow.get()).booleanValue()) {
            return;
        }
        World world = entityLiving.field_70170_p;
        BlockPos pos = entityLiving.func_233580_cy_();
        Class<? extends Entity> glowTarget = this.getProperty(TARGET_PROP);
        Integer seconds = this.getProperty(SECONDS_PROP);
        double x = pos.func_177958_n();
        double y = pos.func_177956_o();
        double z = pos.func_177952_p();
        int range = (Integer)ConfigUnicorn.CONFIG.glowingVisionRange.get();
        AxisAlignedBB scanBox = new AxisAlignedBB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range);
        List entities = world.func_175647_a(glowTarget, scanBox, entity -> !(entity instanceof LivingEntity) || !((LivingEntity)entity).func_70644_a(Effects.field_188423_x));
        EffectUtil.addEffect(entities, Effects.field_188423_x, seconds, amplifier, false);
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }
}

