/*
 * Decompiled with CFR 0.152.
 */
package com.bonfyre.fantasy.sound;

import com.bonfyre.fantasy.core.util.Assert;
import com.mojang.datafixers.util.Pair;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;

public class SoundBuilder {
    private SoundEvent sound;
    private PlayerEntity player;
    private SoundCategory category = SoundCategory.NEUTRAL;
    private BlockPos pos;
    private Pair<Float, Float> volume = Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(-1.0f));
    private Pair<Float, Float> pitch = Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(-1.0f));

    public static SoundBuilder create(SoundEvent sound) {
        return new SoundBuilder(sound);
    }

    public SoundBuilder(SoundEvent sound) {
        this.sound = sound;
    }

    public SoundBuilder sound(SoundEvent soundEvent) {
        this.sound = soundEvent;
        return this;
    }

    public SoundBuilder player(PlayerEntity player) {
        this.player = player;
        return this;
    }

    public SoundBuilder pos(double x, double y, double z) {
        return this.pos(new BlockPos(x, y, z));
    }

    public SoundBuilder pos(BlockPos pos) {
        this.pos = pos;
        return this;
    }

    public SoundBuilder pos(Entity entity) {
        this.pos = entity.func_233580_cy_();
        return this;
    }

    public SoundBuilder category(SoundCategory category) {
        this.category = category;
        return this;
    }

    public SoundBuilder volume(float volume) {
        this.volume = Pair.of((Object)Float.valueOf(volume), (Object)this.volume.getSecond());
        return this;
    }

    public SoundBuilder volume(float volume, float variation) {
        this.volume = Pair.of((Object)Float.valueOf(volume), (Object)Float.valueOf(variation));
        return this;
    }

    public SoundBuilder pitch(float pitch) {
        this.pitch = Pair.of((Object)Float.valueOf(pitch), (Object)this.pitch.getSecond());
        return this;
    }

    public SoundBuilder pitch(float pitch, float variation) {
        this.pitch = Pair.of((Object)Float.valueOf(pitch), (Object)Float.valueOf(variation));
        return this;
    }

    public void play(IWorld world) {
        this.validateBuilder(world);
        world.func_184133_a(this.player, this.pos, this.sound, this.category, this.getVolume(world.func_201674_k()), this.getPitch(world.func_201674_k()));
    }

    public void play(Entity entity) {
        this.validateBuilder(entity);
        entity.func_184185_a(this.sound, this.getVolume(entity.field_70170_p.func_201674_k()), this.getPitch(entity.field_70170_p.func_201674_k()));
    }

    public void play(PlayerEntity player) {
        this.validateBuilder(player);
        player.func_184185_a(this.sound, this.getVolume(player.field_70170_p.func_201674_k()), this.getPitch(player.field_70170_p.func_201674_k()));
    }

    protected void validateBuilder(Object caller) {
        Assert.notNull(caller, caller.getClass().getSimpleName() + " cannot be null when playing sound");
        Assert.notNull((Object)this.sound, "Sound event cannot be null");
        Assert.notNull((Object)this.category, "Sound category cannot be null");
    }

    protected float getPitch(Random rand) {
        return this.randomize(this.pitch, rand);
    }

    protected float getVolume(Random rand) {
        return this.randomize(this.volume, rand);
    }

    protected float randomize(Pair<Float, Float> param, Random rand) {
        float value = ((Float)param.getFirst()).floatValue();
        float variation = ((Float)param.getSecond()).floatValue();
        if (variation > 0.0f) {
            value += (rand.nextFloat() - rand.nextFloat()) * variation;
        }
        return value;
    }
}

