/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import teamdraco.fins.init.FinsBlocks;
import teamdraco.fins.init.FinsItems;
import teamdraco.fins.init.FinsRecipes;

public class CrunchingRecipe
implements IRecipe<CraftingInventory> {
    private final Ingredient base;
    private final Ingredient addition;
    private final ItemStack result;
    private final ResourceLocation recipeId;

    public CrunchingRecipe(ResourceLocation recipeId, Ingredient base, Ingredient addition, ItemStack result) {
        this.recipeId = recipeId;
        this.base = base;
        this.addition = addition;
        this.result = result;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.base.test(inv.func_70301_a(0)) && this.addition.test(inv.func_70301_a(1));
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack itemstack = this.result.func_77946_l();
        return itemstack;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)FinsBlocks.CRAB_CRUNCHER.get());
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)FinsRecipes.CRUNCHING_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return FinsRecipes.CRUNCHING_TYPE;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList i = NonNullList.func_191196_a();
        i.add((Object)this.base);
        i.add((Object)this.addition);
        i.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)FinsItems.CRAB_CRUNCHER.get())}));
        return i;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CrunchingRecipe> {
        public CrunchingRecipe read(ResourceLocation recipeId, JsonObject json) {
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"base"));
            Ingredient ingredient1 = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"addition"));
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new CrunchingRecipe(recipeId, ingredient, ingredient1, itemstack);
        }

        public CrunchingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient ingredient1 = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack itemstack = buffer.func_150791_c();
            return new CrunchingRecipe(recipeId, ingredient, ingredient1, itemstack);
        }

        public void write(PacketBuffer buffer, CrunchingRecipe recipe) {
            recipe.base.func_199564_a(buffer);
            recipe.addition.func_199564_a(buffer);
            buffer.func_150788_a(recipe.result);
        }
    }
}

