/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.entities;

import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import teamdraco.fins.init.FinsEntities;
import teamdraco.fins.init.FinsItems;
import teamdraco.fins.init.FinsSounds;

public class MudhorseEntity
extends AnimalEntity {
    private LivingEntity commander;
    private int commanderSetTime;
    private int attackTimer;

    public MudhorseEntity(EntityType<? extends MudhorseEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)FinsItems.SWAMP_MUCKER.get()}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new CommanderHurt(this));
    }

    public boolean func_70648_aU() {
        return true;
    }

    public static AttributeModifierMap.MutableAttribute func_234176_m_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233823_f_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
        if (flag) {
            entityIn.func_213317_d(entityIn.func_213322_ci().func_72441_c(0.0, (double)0.3f, 0.0));
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == FinsItems.SWAMP_MUCKER.get();
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)FinsSounds.MUDHORSE_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)FinsSounds.MUDHORSE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)FinsSounds.MUDHORSE_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187729_cv, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public void func_70636_d() {
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.commanderSetTime > 0) {
            --this.commanderSetTime;
        } else {
            this.commander = null;
        }
        super.func_70636_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return (AgeableEntity)((EntityType)FinsEntities.MUDHORSE.get()).func_200721_a((World)world);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 1.0f : 2.15f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)FinsItems.MUDHORSE_SPAWN_EGG.get());
    }

    public LivingEntity getCommander() {
        return this.commander;
    }

    public void setCommander(LivingEntity commander) {
        this.commander = commander;
        this.commanderSetTime = 600;
    }

    private static class CommanderHurt
    extends TargetGoal {
        private final MudhorseEntity mudhorse;
        private LivingEntity attacker;
        private int timestamp;

        public CommanderHurt(MudhorseEntity mudhorse) {
            super((MobEntity)mudhorse, false);
            this.mudhorse = mudhorse;
            this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.mudhorse.getCommander();
            if (livingentity != null) {
                this.attacker = livingentity.func_110144_aD();
                int i = livingentity.func_142013_aG();
                if (i != this.timestamp && this.func_220777_a(this.attacker, EntityPredicate.field_221016_a)) {
                    if (!(this.field_188509_g instanceof CreeperEntity) && !(this.field_188509_g instanceof GhastEntity)) {
                        if (this.field_188509_g instanceof WolfEntity) {
                            WolfEntity wolfentity = (WolfEntity)this.field_188509_g;
                            return !wolfentity.func_70909_n() || wolfentity.func_70902_q() != livingentity;
                        }
                        if (this.field_188509_g instanceof PlayerEntity && livingentity instanceof PlayerEntity && !((PlayerEntity)livingentity).func_96122_a((PlayerEntity)this.field_188509_g)) {
                            return false;
                        }
                        if (this.field_188509_g instanceof AbstractHorseEntity && ((AbstractHorseEntity)this.field_188509_g).func_110248_bS()) {
                            return false;
                        }
                        return !(this.field_188509_g instanceof TameableEntity) || !((TameableEntity)this.field_188509_g).func_70909_n();
                    }
                    return false;
                }
            }
            return false;
        }

        public void func_75249_e() {
            this.field_75299_d.func_70624_b(this.attacker);
            LivingEntity livingentity = this.mudhorse.getCommander();
            if (livingentity != null) {
                this.timestamp = livingentity.func_142013_aG();
            }
            super.func_75249_e();
        }
    }
}

