/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.entities;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.passive.fish.AbstractGroupFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import teamdraco.fins.init.FinsItems;

public class NightLightSquidEntity
extends AbstractGroupFishEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(NightLightSquidEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float prevSquidPitch;
    public float squidRotation;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public NightLightSquidEntity(EntityType<? extends NightLightSquidEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimGoal(this));
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (entityIn instanceof ServerPlayerEntity) {
            entityIn.func_195064_c(new EffectInstance(Effects.field_76439_r, 200, 0));
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234227_m_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected ItemStack func_203707_dx() {
        return new ItemStack((IItemProvider)FinsItems.NIGHT_LIGHT_SQUID_BUCKET.get());
    }

    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203818_az;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (dataTag == null) {
            this.setVariant(this.field_70146_Z.nextInt(4));
        } else if (dataTag.func_150297_b("Variant", 3)) {
            this.setVariant(dataTag.func_74762_e("Variant"));
        }
        return spawnDataIn;
    }

    protected void func_204211_f(ItemStack bucket) {
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74768_a("Variant", this.getVariant());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount) && this.func_70643_av() != null) {
            this.squirtInk();
            return true;
        }
        return false;
    }

    private Vector3d func_207400_b(Vector3d p_207400_1_) {
        Vector3d vector3d = p_207400_1_.func_178789_a(this.prevSquidPitch * ((float)Math.PI / 180));
        return vector3d.func_178785_b(-this.field_70760_ar * ((float)Math.PI / 180));
    }

    private void squirtInk() {
        this.func_184185_a(SoundEvents.field_203639_hT, this.func_70599_aP(), this.func_70647_i());
        Vector3d vector3d = this.func_207400_b(new Vector3d(0.0, -1.0, 0.0)).func_72441_c(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        for (int i = 0; i < 30; ++i) {
            Vector3d vector3d1 = this.func_207400_b(new Vector3d((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3, -1.0, (double)this.field_70146_Z.nextFloat() * 0.6 - 0.3));
            Vector3d vector3d2 = vector3d1.func_186678_a(0.3 + (double)(this.field_70146_Z.nextFloat() * 2.0f));
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_203219_V, vector3d.field_72450_a, vector3d.field_72448_b + 0.5, vector3d.field_72449_c, 0, vector3d2.field_72450_a, vector3d2.field_72448_b, vector3d2.field_72449_c, (double)0.1f);
        }
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.01f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public static boolean func_223365_b(EntityType<NightLightSquidEntity> entity, IWorld world, SpawnReason reason, BlockPos pos, Random p_223365_4_) {
        return pos.func_177956_o() < world.func_181545_F() && world.func_180495_p(pos.func_177984_a()).func_203425_a(Blocks.field_150355_j);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    public void setMovementVector(float randomMotionVecXIn, float randomMotionVecYIn, float randomMotionVecZIn) {
        this.randomMotionVecX = randomMotionVecXIn;
        this.randomMotionVecY = randomMotionVecYIn;
        this.randomMotionVecZ = randomMotionVecZIn;
    }

    public boolean hasMovementVector() {
        return this.randomMotionVecX != 0.0f || this.randomMotionVecY != 0.0f || this.randomMotionVecZ != 0.0f;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)FinsItems.NIGHT_LIGHT_SQUID_SPAWN_EGG.get());
    }

    static class SwimGoal
    extends RandomSwimmingGoal {
        private final NightLightSquidEntity fish;

        public SwimGoal(NightLightSquidEntity fish) {
            super((CreatureEntity)fish, 1.0, 1);
            this.fish = fish;
        }

        public boolean func_75250_a() {
            return super.func_75250_a();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final NightLightSquidEntity fish;

        MoveHelperController(NightLightSquidEntity fish) {
            super((MobEntity)fish);
            this.fish = fish;
        }

        public void func_75641_c() {
            if (this.fish.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                float f = (float)(this.field_75645_e * this.fish.func_233637_b_(Attributes.field_233821_d_));
                this.fish.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.fish.func_70689_ay(), (float)f));
                double d0 = this.field_75646_b - this.fish.func_226277_ct_();
                double d1 = this.field_75647_c - this.fish.func_226278_cu_();
                double d2 = this.field_75644_d - this.fish.func_226281_cx_();
                if (d1 != 0.0) {
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    this.fish.func_213317_d(this.fish.func_213322_ci().func_72441_c(0.0, (double)this.fish.func_70689_ay() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.fish.field_70761_aq = this.fish.field_70177_z = this.func_75639_a(this.fish.field_70177_z, f1, 90.0f);
                }
            } else {
                this.fish.func_70659_e(0.0f);
            }
        }
    }

    class FleeGoal
    extends Goal {
        private int tickCounter;

        private FleeGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = NightLightSquidEntity.this.func_70643_av();
            if (NightLightSquidEntity.this.func_70090_H() && livingentity != null) {
                return NightLightSquidEntity.this.func_70068_e((Entity)livingentity) < 100.0;
            }
            return false;
        }

        public void func_75249_e() {
            this.tickCounter = 0;
        }

        public void func_75246_d() {
            ++this.tickCounter;
            LivingEntity livingentity = NightLightSquidEntity.this.func_70643_av();
            if (livingentity != null) {
                Vector3d vector3d = new Vector3d(NightLightSquidEntity.this.func_226277_ct_() - livingentity.func_226277_ct_(), NightLightSquidEntity.this.func_226278_cu_() - livingentity.func_226278_cu_(), NightLightSquidEntity.this.func_226281_cx_() - livingentity.func_226281_cx_());
                BlockState blockstate = NightLightSquidEntity.this.field_70170_p.func_180495_p(new BlockPos(NightLightSquidEntity.this.func_226277_ct_() + vector3d.field_72450_a, NightLightSquidEntity.this.func_226278_cu_() + vector3d.field_72448_b, NightLightSquidEntity.this.func_226281_cx_() + vector3d.field_72449_c));
                FluidState fluidstate = NightLightSquidEntity.this.field_70170_p.func_204610_c(new BlockPos(NightLightSquidEntity.this.func_226277_ct_() + vector3d.field_72450_a, NightLightSquidEntity.this.func_226278_cu_() + vector3d.field_72448_b, NightLightSquidEntity.this.func_226281_cx_() + vector3d.field_72449_c));
                if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || blockstate.func_196958_f()) {
                    double d0 = vector3d.func_72433_c();
                    if (d0 > 0.0) {
                        vector3d.func_72432_b();
                        float f = 3.0f;
                        if (d0 > 5.0) {
                            f = (float)((double)f - (d0 - 5.0) / 5.0);
                        }
                        if (f > 0.0f) {
                            vector3d = vector3d.func_186678_a((double)f);
                        }
                    }
                    if (blockstate.func_196958_f()) {
                        vector3d = vector3d.func_178786_a(0.0, vector3d.field_72448_b, 0.0);
                    }
                    NightLightSquidEntity.this.setMovementVector((float)vector3d.field_72450_a / 20.0f, (float)vector3d.field_72448_b / 20.0f, (float)vector3d.field_72449_c / 20.0f);
                }
                if (this.tickCounter % 10 == 5) {
                    NightLightSquidEntity.this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, NightLightSquidEntity.this.func_226277_ct_(), NightLightSquidEntity.this.func_226278_cu_(), NightLightSquidEntity.this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

