/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.entities;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.JumpGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import teamdraco.fins.common.entities.BandedRedbackShrimpEntity;
import teamdraco.fins.common.entities.OrnateBugfishEntity;
import teamdraco.fins.common.entities.SpindlyGemCrabEntity;
import teamdraco.fins.common.entities.WhiteBullCrabEntity;
import teamdraco.fins.common.entities.pathfinding.GroundAndSwimmerNavigator;
import teamdraco.fins.init.FinsEntities;
import teamdraco.fins.init.FinsItems;
import teamdraco.fins.init.FinsSounds;

public class RubberBellyGliderEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> PUFFED = EntityDataManager.func_187226_a(RubberBellyGliderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final EntitySize PUFFED_SIZE = EntitySize.func_220314_b((float)0.7f, (float)0.5f);
    private int puffTimer;
    private static final Predicate<Entity> ENEMY_MATCHER = entity -> {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity instanceof PlayerEntity) {
            return !((PlayerEntity)entity).func_184812_l_() && !entity.func_175149_v();
        }
        return entity instanceof OrnateBugfishEntity || RubberBellyGliderEntity.isEntityPrey(entity);
    };

    public RubberBellyGliderEntity(EntityType<? extends RubberBellyGliderEntity> type, World world) {
        super(type, world);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70138_W = 1.0f;
    }

    private static boolean isEntityPrey(Entity entity) {
        return entity instanceof SquidEntity || entity instanceof BandedRedbackShrimpEntity || entity instanceof WhiteBullCrabEntity;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public void func_70030_z() {
        super.func_70030_z();
        this.func_70050_g(300);
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PUFFED, (Object)false);
    }

    public boolean isPuffed() {
        return (Boolean)this.field_70180_af.func_187225_a(PUFFED);
    }

    public void setPuffed(boolean p_203714_1_) {
        this.field_70180_af.func_187227_b(PUFFED, (Object)p_203714_1_);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Puffed", this.isPuffed());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setPuffed(compound.func_74767_n("Puffed"));
    }

    public void func_184206_a(DataParameter<?> key) {
        if (PUFFED.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new PuffGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new FindWaterGoal((CreatureEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, OrnateBugfishEntity.class, 8.0f, 1.6, 1.4, EntityPredicates.field_180132_d::test));
        this.field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 1.6, 1.4, EntityPredicates.field_180132_d::test));
        this.field_70714_bg.func_75776_a(1, (Goal)new BreedGoal((AnimalEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new PanicGoal((CreatureEntity)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.0, 1){

            public boolean func_75250_a() {
                return super.func_75250_a() && RubberBellyGliderEntity.this.func_70090_H();
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new WanderGoal(this, 1.0, 1));
        this.field_70714_bg.func_75776_a(3, (Goal)new GliderJumpGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SpindlyGemCrabEntity.class, 90, true, false, null));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 10, true, false, RubberBellyGliderEntity::isEntityPrey));
    }

    public static AttributeModifierMap.MutableAttribute registerRBGAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233818_a_, 25.0).func_233815_a_(Attributes.field_233821_d_, 0.12);
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new GroundAndSwimmerNavigator((MobEntity)this, this.field_70170_p);
    }

    public void func_213352_e(Vector3d travelVector) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, travelVector);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(travelVector);
        }
    }

    public int func_70627_aG() {
        return 500;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isPuffed() && ++this.puffTimer >= 100) {
            this.func_184185_a(SoundEvents.field_203825_gn, this.func_70599_aP(), this.func_70647_i());
            this.setPuffed(false);
            this.puffTimer = 0;
        }
    }

    public static boolean canGliderSpawn(EntityType<? extends RubberBellyGliderEntity> type, IWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a) && pos.func_177956_o() >= 40;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)FinsItems.RUBBER_BELLY_GLIDER_SPAWN_EGG.get());
    }

    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)((EntityType)FinsEntities.RUBBER_BELLY_GLIDER.get()).func_200721_a(this.field_70170_p);
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (entityIn instanceof ServerPlayerEntity && this.isPuffed()) {
            entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 2.0f);
            entityIn.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 0));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof AbstractArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)FinsSounds.RUBBER_BELLY_GLIDER_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)FinsSounds.RUBBER_BELLY_GLIDER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)FinsSounds.RUBBER_BELLY_GLIDER_HURT.get();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return this.func_70631_g_() ? 0.05f : 0.15f;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return this.isPuffed() ? PUFFED_SIZE : super.func_213305_a(poseIn);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == FinsItems.AMBER_SPINDLY_GEM_CRAB.get() || stack.func_77973_b() == FinsItems.RUBY_SPINDLY_GEM_CRAB.get() || stack.func_77973_b() == FinsItems.EMERALD_SPINDLY_GEM_CRAB.get() || stack.func_77973_b() == FinsItems.SAPPHIRE_SPINDLY_GEM_CRAB.get() || stack.func_77973_b() == FinsItems.PEARL_SPINDLY_GEM_CRAB.get();
    }

    static class WanderGoal
    extends RandomWalkingGoal {
        private WanderGoal(RubberBellyGliderEntity glider, double speedIn, int chance) {
            super((CreatureEntity)glider, speedIn, chance);
        }

        public boolean func_75250_a() {
            return !this.field_75457_a.func_70090_H() && super.func_75250_a();
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final RubberBellyGliderEntity glider;

        MoveHelperController(RubberBellyGliderEntity glider) {
            super((MobEntity)glider);
            this.glider = glider;
        }

        private void updateSpeed() {
            if (this.glider.func_70090_H()) {
                this.glider.func_213317_d(this.glider.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
                if (this.glider.func_70631_g_()) {
                    this.glider.func_70659_e(Math.max(this.glider.func_70689_ay() / 3.0f, 0.06f));
                }
            } else if (this.glider.field_70122_E) {
                this.glider.func_70659_e(Math.max(this.glider.func_70689_ay() / 1.0f, 0.06f));
            }
        }

        public void func_75641_c() {
            this.updateSpeed();
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.glider.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.glider.func_226277_ct_();
                double d1 = this.field_75647_c - this.glider.func_226278_cu_();
                double d2 = this.field_75644_d - this.glider.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.glider.field_70761_aq = this.glider.field_70177_z = this.func_75639_a(this.glider.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.glider.func_233637_b_(Attributes.field_233821_d_));
                this.glider.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.glider.func_70689_ay(), (float)f1));
                this.glider.func_213317_d(this.glider.func_213322_ci().func_72441_c(0.0, (double)this.glider.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.glider.func_70659_e(0.0f);
            }
        }
    }

    public static class GliderJumpGoal
    extends JumpGoal {
        private static final int[] JUMP_DISTANCES = new int[]{0, 1, 4, 5, 6, 7};
        private final RubberBellyGliderEntity glider;
        private boolean inWater;

        public GliderJumpGoal(RubberBellyGliderEntity glider) {
            this.glider = glider;
        }

        public boolean func_75250_a() {
            if (this.glider.func_70681_au().nextInt(50) != 0) {
                return false;
            }
            Direction direction = this.glider.func_184172_bi();
            int i = direction.func_82601_c();
            int j = direction.func_82599_e();
            BlockPos blockpos = this.glider.func_233580_cy_();
            for (int k : JUMP_DISTANCES) {
                if (this.canJumpTo(blockpos, i, j, k) && this.isAirAbove(blockpos, i, j, k)) continue;
                return false;
            }
            return true;
        }

        private boolean canJumpTo(BlockPos pos, int dx, int dz, int scale) {
            BlockPos blockpos = pos.func_177982_a(dx * scale, 0, dz * scale);
            return this.glider.field_70170_p.func_204610_c(blockpos).func_206884_a((ITag)FluidTags.field_206959_a) && !this.glider.field_70170_p.func_180495_p(blockpos).func_185904_a().func_76230_c();
        }

        private boolean isAirAbove(BlockPos pos, int dx, int dz, int scale) {
            return this.glider.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 1, dz * scale)).func_196958_f() && this.glider.field_70170_p.func_180495_p(pos.func_177982_a(dx * scale, 2, dz * scale)).func_196958_f();
        }

        public boolean func_75253_b() {
            double d0 = this.glider.func_213322_ci().field_72448_b;
            return !(d0 * d0 < (double)0.03f && this.glider.field_70125_A != 0.0f && Math.abs(this.glider.field_70125_A) < 10.0f && this.glider.func_70090_H() || this.glider.func_233570_aj_());
        }

        public boolean func_220685_C_() {
            return false;
        }

        public void func_75249_e() {
            Direction direction = this.glider.func_184172_bi();
            this.glider.func_213317_d(this.glider.func_213322_ci().func_72441_c((double)direction.func_82601_c() * 0.6, 0.7, (double)direction.func_82599_e() * 0.6));
            this.glider.func_70661_as().func_75499_g();
        }

        public void func_75251_c() {
            this.glider.field_70125_A = 0.0f;
        }

        public void func_75246_d() {
            boolean flag = this.inWater;
            if (!flag) {
                FluidState fluidstate = this.glider.field_70170_p.func_204610_c(this.glider.func_233580_cy_());
                this.inWater = fluidstate.func_206884_a((ITag)FluidTags.field_206959_a);
            }
            if (this.inWater && !flag) {
                this.glider.func_184185_a(SoundEvents.field_205209_aZ, 1.0f, 1.0f);
            }
            Vector3d vector3d = this.glider.func_213322_ci();
            if (vector3d.field_72448_b * vector3d.field_72448_b < (double)0.03f && this.glider.field_70125_A != 0.0f) {
                this.glider.field_70125_A = MathHelper.func_226167_j_((float)this.glider.field_70125_A, (float)0.0f, (float)0.2f);
            } else {
                double d0 = Math.sqrt(Entity.func_213296_b((Vector3d)vector3d));
                double d1 = Math.signum(-vector3d.field_72448_b) * Math.acos(d0 / vector3d.func_72433_c()) * 57.2957763671875;
                this.glider.field_70125_A = (float)d1;
            }
        }
    }

    static class PuffGoal
    extends Goal {
        private final RubberBellyGliderEntity glider;

        public PuffGoal(RubberBellyGliderEntity glider) {
            this.glider = glider;
        }

        public boolean func_75250_a() {
            return this.glider.func_70090_H() && !this.glider.isPuffed() && !this.glider.field_70170_p.func_175674_a((Entity)this.glider, this.glider.func_174813_aQ().func_186662_g(2.5), ENEMY_MATCHER).isEmpty();
        }

        public void func_75249_e() {
            this.glider.func_184185_a(SoundEvents.field_203826_go, this.glider.func_70599_aP(), this.glider.func_70647_i());
            this.glider.setPuffed(true);
        }
    }
}

