/*
 * Decompiled with CFR 0.152.
 */
package teamdraco.fins.common.entities;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import teamdraco.fins.init.FinsItems;
import teamdraco.fins.init.FinsSounds;

public class SpindlyGemCrabEntity
extends AbstractFishEntity {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(SpindlyGemCrabEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public SpindlyGemCrabEntity(EntityType<? extends SpindlyGemCrabEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70138_W = 0.7f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new TemptGoal((CreatureEntity)this, 1.0, false, Ingredient.func_199805_a((ITag)Tags.Items.GEMS)));
        this.field_70714_bg.func_75776_a(1, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected PathNavigator func_175447_b(World world) {
        return new GroundPathNavigator((MobEntity)this, world);
    }

    protected ItemStack func_203707_dx() {
        return new ItemStack((IItemProvider)FinsItems.SPINDLY_GEM_CRAB_BUCKET.get());
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (dataTag == null) {
            this.setVariant(this.field_70146_Z.nextInt(5));
        } else if (dataTag.func_150297_b("Variant", 3)) {
            this.setVariant(dataTag.func_74762_e("Variant"));
        }
        return spawnDataIn;
    }

    protected void func_204211_f(ItemStack bucket) {
        CompoundNBT compoundnbt = bucket.func_196082_o();
        compoundnbt.func_74768_a("Variant", this.getVariant());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 38) {
            this.shineParticles((IParticleData)ParticleTypes.field_197624_q);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void shineParticles(IParticleData p_208401_1_) {
        if ((double)this.field_70146_Z.nextFloat() > 0.975) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(p_208401_1_, this.func_226277_ct_(), this.func_226279_cv_(), this.func_226281_cx_(), d0, d1, d2);
        }
    }

    public static AttributeModifierMap.MutableAttribute func_234176_m_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_204414_iY;
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)FinsSounds.CRAB_DEATH.get();
    }

    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_204413_iX;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)FinsItems.SPINDLY_GEM_CRAB_SPAWN_EGG.get());
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70170_p.func_72960_a((Entity)this, (byte)38);
    }

    static class MoveHelperController
    extends MovementController {
        private final SpindlyGemCrabEntity crab;

        MoveHelperController(SpindlyGemCrabEntity crab) {
            super((MobEntity)crab);
            this.crab = crab;
        }

        public void func_75641_c() {
            if (this.crab.func_208600_a((ITag)FluidTags.field_206959_a)) {
                this.crab.func_213317_d(this.crab.func_213322_ci().func_72441_c(0.0, 0.0, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.crab.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.crab.func_226277_ct_();
                double d1 = this.field_75647_c - this.crab.func_226278_cu_();
                double d2 = this.field_75644_d - this.crab.func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.crab.field_70761_aq = this.crab.field_70177_z = this.func_75639_a(this.crab.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.crab.func_233637_b_(Attributes.field_233821_d_));
                this.crab.func_70659_e(MathHelper.func_219799_g((float)0.125f, (float)this.crab.func_70689_ay(), (float)f1));
                this.crab.func_213317_d(this.crab.func_213322_ci().func_72441_c(0.0, (double)this.crab.func_70689_ay() * (d1 /= d3) * 0.1, 0.0));
            } else {
                this.crab.func_70659_e(0.0f);
            }
        }
    }
}

