/*
 * Decompiled with CFR 0.152.
 */
package defeatedcrow.hac.food.block;

import defeatedcrow.hac.api.climate.IClimate;
import defeatedcrow.hac.core.ClimateCore;
import defeatedcrow.hac.core.base.DCTileBlock;
import defeatedcrow.hac.core.util.DCUtil;
import defeatedcrow.hac.food.block.TileAgingBarrel;
import defeatedcrow.hac.food.capability.DrinkCapabilityHandler;
import defeatedcrow.hac.food.capability.IDrinkCustomize;
import defeatedcrow.hac.main.ClimateMain;
import defeatedcrow.hac.main.config.MainCoreConfig;
import defeatedcrow.hac.main.util.DCName;
import defeatedcrow.hac.main.util.MainUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAgingBarrel
extends DCTileBlock {
    public BlockAgingBarrel(String s) {
        super(Material.field_151575_d, s, 0);
    }

    public boolean onRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player != null && !world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            TileEntity tile = world.func_175625_s(pos);
            ItemStack held = player.func_184586_b(hand);
            if (tile != null && tile instanceof TileAgingBarrel) {
                if (!DCUtil.isEmpty((ItemStack)held) && BlockAgingBarrel.onActivateDCTank((TileAgingBarrel)tile, held, world, state, side, player)) {
                    return true;
                }
                player.openGui((Object)ClimateMain.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public static boolean onActivateDCTank(TileAgingBarrel tile, ItemStack item, World world, IBlockState state, EnumFacing side, EntityPlayer player) {
        if (!DCUtil.isEmpty((ItemStack)item) && tile != null && item.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, side) && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            ItemStack copy = item.func_77946_l();
            if (item.func_190916_E() > 1) {
                copy.func_190920_e(1);
            }
            IFluidHandlerItem dummy = (IFluidHandlerItem)copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            IFluidHandler tank = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN);
            if (dummy != null && dummy.getTankProperties() != null && dummy.getTankProperties().length > 0 && tank instanceof TileAgingBarrel.AgingTank) {
                int max = dummy.getTankProperties()[0].getCapacity();
                FluidStack f1 = dummy.drain(max, false);
                TileAgingBarrel.AgingTank dc_in = (TileAgingBarrel.AgingTank)tank;
                ItemStack ret = ItemStack.field_190927_a;
                boolean success = false;
                if (f1 != null && dc_in.fill(f1, false) > 0) {
                    int f2 = dc_in.fill(f1, false);
                    FluidStack fill = dummy.drain(f2, true);
                    ret = dummy.getContainer();
                    if (fill != null && fill.amount > 0) {
                        dc_in.fill(fill, true);
                        success = true;
                    }
                } else if (f1 == null && dc_in.drain(max, false) != null) {
                    int drain = dummy.fill(dc_in.drain(max, false), true);
                    ret = dummy.getContainer();
                    if (!DCUtil.isEmpty((ItemStack)ret) && ret.hasCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null)) {
                        IDrinkCustomize drink = (IDrinkCustomize)ret.getCapability(DrinkCapabilityHandler.DRINK_CUSTOMIZE_CAPABILITY, null);
                        if (dc_in.getAge() >= MainCoreConfig.aging_day) {
                            int level = dc_in.getAge() / MainCoreConfig.aging_day;
                            drink.setAging(level);
                        }
                    }
                    if (drain > 0) {
                        dc_in.drain(drain, true);
                        success = true;
                    }
                }
                if (success) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        DCUtil.reduceStackSize((ItemStack)item, (int)1);
                    }
                    tile.func_70296_d();
                    player.field_71071_by.func_70296_d();
                    if (!DCUtil.isEmpty((ItemStack)ret)) {
                        EntityItem drop = new EntityItem(world, player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, ret.func_77946_l());
                        world.func_72838_d((Entity)drop);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileAgingBarrel();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    }

    public boolean onClimateChange(World world, BlockPos pos, IBlockState state, IClimate clm) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        if (ClimateCore.proxy.isShiftKeyDown()) {
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Requirement ===");
            tooltip.add(DCName.HEAT.getLocalizedName() + ": " + TextFormatting.BLUE.toString() + "COLD " + TextFormatting.RED.toString() + "~ HOT");
            tooltip.add(DCName.HUM.getLocalizedName() + ": " + TextFormatting.GREEN.toString() + "NORMAL-");
            tooltip.add(DCName.AIR.getLocalizedName() + ": " + TextFormatting.GREEN.toString() + "NORMAL-");
            tooltip.add(TextFormatting.YELLOW.toString() + TextFormatting.BOLD.toString() + "=== Output ===");
            tooltip.add(DCName.OUTPUT_FLUID.getLocalizedName());
        } else {
            tooltip.add(TextFormatting.ITALIC.toString() + "=== Lshift key: expand tooltip ===");
        }
        tooltip.add(TextFormatting.BOLD.toString() + "Tier 2");
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return MainUtil.calcTankRedstone(worldIn.func_175625_s(pos));
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }
}

